/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command;

import com.orientechnologies.orient.core.command.OCommandRequestAbstract;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OExecutionThreadLocal;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.ONetworkThreadLocalSerializer;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class OCommandRequestTextAbstract
extends OCommandRequestAbstract
implements OCommandRequestText {
    protected String text;

    protected OCommandRequestTextAbstract() {
    }

    protected OCommandRequestTextAbstract(String iText) {
        if (iText == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        this.text = iText.trim();
    }

    @Override
    public <RET> RET execute(Object ... iArgs) {
        this.setParameters(iArgs);
        ((OExecutionThreadLocal.OExecutionThreadData)OExecutionThreadLocal.INSTANCE.get()).onAsyncReplicationOk = this.onAsyncReplicationOk;
        ((OExecutionThreadLocal.OExecutionThreadData)OExecutionThreadLocal.INSTANCE.get()).onAsyncReplicationError = this.onAsyncReplicationError;
        return (RET)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().command(this);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public OCommandRequestText setText(String iText) {
        this.text = iText;
        return this;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        OMemoryStream buffer = new OMemoryStream(iStream);
        this.fromStream(buffer);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        OMemoryStream buffer = new OMemoryStream();
        return this.toStream(buffer);
    }

    public String toString() {
        return "?." + this.text;
    }

    protected byte[] toStream(OMemoryStream buffer) {
        buffer.setUtf8(this.text);
        if (this.parameters == null || this.parameters.size() == 0) {
            buffer.set(false);
            buffer.set(false);
        } else {
            HashMap params = new HashMap();
            HashMap compositeKeyParams = new HashMap();
            for (Map.Entry paramEntry : this.parameters.entrySet()) {
                if (paramEntry.getValue() instanceof OCompositeKey) {
                    OCompositeKey compositeKey = (OCompositeKey)paramEntry.getValue();
                    compositeKeyParams.put(paramEntry.getKey(), compositeKey.getKeys());
                    continue;
                }
                params.put(paramEntry.getKey(), paramEntry.getValue());
            }
            buffer.set(!params.isEmpty());
            if (!params.isEmpty()) {
                ODocument param = new ODocument();
                param.field("parameters", params);
                buffer.set(param.toStream());
            }
            buffer.set(!compositeKeyParams.isEmpty());
            if (!compositeKeyParams.isEmpty()) {
                ODocument compositeKey = new ODocument();
                compositeKey.field("compositeKeyParams", compositeKeyParams);
                buffer.set(compositeKey.toStream());
            }
        }
        return buffer.toByteArray();
    }

    protected void fromStream(OMemoryStream buffer) {
        boolean compositeKeyParamsPresent;
        this.text = buffer.getAsString();
        this.parameters = null;
        ORecordSerializer serializer = ONetworkThreadLocalSerializer.getNetworkSerializer();
        boolean simpleParams = buffer.getAsBoolean();
        if (simpleParams) {
            byte[] paramBuffer = buffer.getAsByteArray();
            ODocument param = new ODocument();
            if (serializer != null) {
                serializer.fromStream(paramBuffer, param, null);
            } else {
                param.fromStream(paramBuffer);
            }
            Map params = (Map)param.field("params");
            this.parameters = new HashMap();
            if (params != null) {
                for (Map.Entry p : params.entrySet()) {
                    Object value = p.getValue() instanceof String ? ORecordSerializerStringAbstract.getTypeValue((String)p.getValue()) : p.getValue();
                    if (p.getKey() instanceof String && Character.isDigit(((String)p.getKey()).charAt(0))) {
                        this.parameters.put(Integer.parseInt((String)p.getKey()), value);
                        continue;
                    }
                    this.parameters.put(p.getKey(), value);
                }
            } else {
                params = (Map)param.field("parameters");
                for (Map.Entry p : params.entrySet()) {
                    if (p.getKey() instanceof String && Character.isDigit(((String)p.getKey()).charAt(0))) {
                        this.parameters.put(Integer.parseInt((String)p.getKey()), p.getValue());
                        continue;
                    }
                    this.parameters.put(p.getKey(), p.getValue());
                }
            }
        }
        if (compositeKeyParamsPresent = buffer.getAsBoolean()) {
            byte[] paramBuffer = buffer.getAsByteArray();
            ODocument param = new ODocument();
            if (serializer != null) {
                serializer.fromStream(paramBuffer, param, null);
            } else {
                param.fromStream(paramBuffer);
            }
            Map compositeKeyParams = (Map)param.field("compositeKeyParams");
            if (this.parameters == null) {
                this.parameters = new HashMap();
            }
            for (Map.Entry p : compositeKeyParams.entrySet()) {
                if (p.getValue() instanceof List) {
                    OCompositeKey compositeKey = new OCompositeKey((List)p.getValue());
                    if (p.getKey() instanceof String && Character.isDigit(((String)p.getKey()).charAt(0))) {
                        this.parameters.put(Integer.parseInt((String)p.getKey()), compositeKey);
                        continue;
                    }
                    this.parameters.put(p.getKey(), compositeKey);
                    continue;
                }
                OCompositeKey value = OCompositeKeySerializer.INSTANCE.deserialize(OStringSerializerHelper.getBinaryContent(p.getValue()), 0);
                if (p.getKey() instanceof String && Character.isDigit(((String)p.getKey()).charAt(0))) {
                    this.parameters.put(Integer.parseInt((String)p.getKey()), value);
                    continue;
                }
                this.parameters.put(p.getKey(), value);
            }
        }
    }
}

