/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.List;
import java.util.Map;

public class ONotBlock
extends OBooleanExpression {
    protected OBooleanExpression sub;
    protected boolean negate = false;

    public ONotBlock(int id) {
        super(id);
    }

    public ONotBlock(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        if (this.sub == null) {
            return true;
        }
        boolean result = this.sub.evaluate(currentRecord, ctx);
        if (this.negate) {
            return !result;
        }
        return result;
    }

    public OBooleanExpression getSub() {
        return this.sub;
    }

    public void setSub(OBooleanExpression sub) {
        this.sub = sub;
    }

    public boolean isNegate() {
        return this.negate;
    }

    public void setNegate(boolean negate) {
        this.negate = negate;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.negate) {
            builder.append("NOT ");
        }
        this.sub.toString(params, builder);
    }

    @Override
    public boolean supportsBasicCalculation() {
        return true;
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        return this.sub.getNumberOfExternalCalculations();
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        return this.sub.getExternalCalculationConditions();
    }

    @Override
    public List<OBinaryCondition> getIndexedFunctionConditions(OClass iSchemaClass, ODatabaseDocumentInternal database) {
        if (this.sub == null) {
            return null;
        }
        if (this.negate) {
            return null;
        }
        return this.sub.getIndexedFunctionConditions(iSchemaClass, database);
    }

    @Override
    public List<OAndBlock> flatten() {
        if (!this.negate) {
            return this.sub.flatten();
        }
        return super.flatten();
    }
}

