/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.kubernetes.KubernetesComponent;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.consumer.KubernetesNamespacesConsumer;
import org.apache.camel.component.kubernetes.consumer.KubernetesNodesConsumer;
import org.apache.camel.component.kubernetes.consumer.KubernetesPodsConsumer;
import org.apache.camel.component.kubernetes.consumer.KubernetesReplicationControllersConsumer;
import org.apache.camel.component.kubernetes.consumer.KubernetesServicesConsumer;
import org.apache.camel.component.kubernetes.producer.KubernetesBuildConfigsProducer;
import org.apache.camel.component.kubernetes.producer.KubernetesBuildsProducer;
import org.apache.camel.component.kubernetes.producer.KubernetesConfigMapsProducer;
import org.apache.camel.component.kubernetes.producer.KubernetesNamespacesProducer;
import org.apache.camel.component.kubernetes.producer.KubernetesNodesProducer;
import org.apache.camel.component.kubernetes.producer.KubernetesPersistentVolumesClaimsProducer;
import org.apache.camel.component.kubernetes.producer.KubernetesPersistentVolumesProducer;
import org.apache.camel.component.kubernetes.producer.KubernetesPodsProducer;
import org.apache.camel.component.kubernetes.producer.KubernetesReplicationControllersProducer;
import org.apache.camel.component.kubernetes.producer.KubernetesResourcesQuotaProducer;
import org.apache.camel.component.kubernetes.producer.KubernetesSecretsProducer;
import org.apache.camel.component.kubernetes.producer.KubernetesServiceAccountsProducer;
import org.apache.camel.component.kubernetes.producer.KubernetesServicesProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.17.0", scheme="kubernetes", title="Kubernetes", syntax="kubernetes:masterUrl", label="container,cloud,paas")
public class KubernetesEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesEndpoint.class);
    @UriParam
    private KubernetesConfiguration configuration;
    private transient KubernetesClient client;

    public KubernetesEndpoint(String uri, KubernetesComponent component, KubernetesConfiguration config) {
        super(uri, (Component)component);
        this.configuration = config;
    }

    public Producer createProducer() throws Exception {
        String category;
        if (ObjectHelper.isEmpty((Object)this.configuration.getCategory())) {
            throw new IllegalArgumentException("A producer category must be specified");
        }
        switch (category = this.configuration.getCategory()) {
            case "namespaces": {
                return new KubernetesNamespacesProducer(this);
            }
            case "services": {
                return new KubernetesServicesProducer(this);
            }
            case "replicationControllers": {
                return new KubernetesReplicationControllersProducer(this);
            }
            case "pods": {
                return new KubernetesPodsProducer(this);
            }
            case "persistentVolumes": {
                return new KubernetesPersistentVolumesProducer(this);
            }
            case "persistentVolumesClaims": {
                return new KubernetesPersistentVolumesClaimsProducer(this);
            }
            case "secrets": {
                return new KubernetesSecretsProducer(this);
            }
            case "resourcesQuota": {
                return new KubernetesResourcesQuotaProducer(this);
            }
            case "serviceAccounts": {
                return new KubernetesServiceAccountsProducer(this);
            }
            case "nodes": {
                return new KubernetesNodesProducer(this);
            }
            case "configMaps": {
                return new KubernetesConfigMapsProducer(this);
            }
            case "builds": {
                return new KubernetesBuildsProducer(this);
            }
            case "buildConfigs": {
                return new KubernetesBuildConfigsProducer(this);
            }
        }
        throw new IllegalArgumentException("The " + category + " producer category doesn't exist");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        String category;
        if (ObjectHelper.isEmpty((Object)this.configuration.getCategory())) {
            throw new IllegalArgumentException("A consumer category must be specified");
        }
        switch (category = this.configuration.getCategory()) {
            case "pods": {
                return new KubernetesPodsConsumer(this, processor);
            }
            case "services": {
                return new KubernetesServicesConsumer(this, processor);
            }
            case "replicationControllers": {
                return new KubernetesReplicationControllersConsumer(this, processor);
            }
            case "namespaces": {
                return new KubernetesNamespacesConsumer(this, processor);
            }
            case "nodes": {
                return new KubernetesNodesConsumer(this, processor);
            }
        }
        throw new IllegalArgumentException("The " + category + " consumer category doesn't exist");
    }

    public boolean isSingleton() {
        return false;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.client = this.configuration.getKubernetesClient() != null ? this.configuration.getKubernetesClient() : this.createKubernetesClient();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.client != null) {
            this.client.close();
        }
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "KubernetesConsumer", this.configuration.getPoolSize());
    }

    public KubernetesClient getKubernetesClient() {
        return this.client;
    }

    public KubernetesConfiguration getKubernetesConfiguration() {
        return this.configuration;
    }

    private KubernetesClient createKubernetesClient() {
        LOG.debug("Create Kubernetes client with the following Configuration: " + this.configuration.toString());
        ConfigBuilder builder = new ConfigBuilder();
        builder.withMasterUrl(this.configuration.getMasterUrl());
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getUsername()) && ObjectHelper.isNotEmpty((Object)this.configuration.getPassword()) && ObjectHelper.isEmpty((Object)this.configuration.getOauthToken())) {
            builder.withUsername(this.configuration.getUsername());
            builder.withPassword(this.configuration.getPassword());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getOauthToken())) {
            builder.withOauthToken(this.configuration.getOauthToken());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getCaCertData())) {
            builder.withCaCertData(this.configuration.getCaCertData());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getCaCertFile())) {
            builder.withCaCertFile(this.configuration.getCaCertFile());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getClientCertData())) {
            builder.withClientCertData(this.configuration.getClientCertData());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getClientCertFile())) {
            builder.withClientCertFile(this.configuration.getClientCertFile());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getApiVersion())) {
            builder.withApiVersion(this.configuration.getApiVersion());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getClientKeyAlgo())) {
            builder.withClientKeyAlgo(this.configuration.getClientKeyAlgo());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getClientKeyData())) {
            builder.withClientKeyData(this.configuration.getClientKeyData());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getClientKeyFile())) {
            builder.withClientKeyFile(this.configuration.getClientKeyFile());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getClientKeyPassphrase())) {
            builder.withClientKeyPassphrase(this.configuration.getClientKeyPassphrase());
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getTrustCerts())) {
            builder.withTrustCerts(this.configuration.getTrustCerts().booleanValue());
        }
        Config conf = builder.build();
        return new DefaultKubernetesClient(conf);
    }
}

