package org.wildfly.swarm.config.teiid;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Teiid Translator
 */
@Address("/subsystem=teiid/translator=*")
@ResourceType("translator")
public class Translator<T extends Translator<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Name of the module that implements the translator")
	private String module;
	@AttributeDocumentation("Name of the module slot that implements the translator")
	private String slot;

	public Translator(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Name of the module that implements the translator
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Name of the module that implements the translator
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of the module slot that implements the translator
	 */
	@ModelNodeBinding(detypedName = "slot")
	public String slot() {
		return this.slot;
	}

	/**
	 * Name of the module slot that implements the translator
	 */
	@SuppressWarnings("unchecked")
	public T slot(java.lang.String value) {
		Object oldValue = this.slot;
		this.slot = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("slot", oldValue, value);
		return (T) this;
	}
}