package org.wildfly.swarm.config.keycloak;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.keycloak.secure_deployment.CredentialConsumer;
import org.wildfly.swarm.config.keycloak.secure_deployment.CredentialSupplier;
import org.wildfly.swarm.config.keycloak.secure_deployment.Credential;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A deployment secured by Keycloak
 */
@Address("/subsystem=keycloak/secure-deployment=*")
@ResourceType("secure-deployment")
public class SecureDeployment<T extends SecureDeployment<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private SecureDeploymentResources subresources = new SecureDeploymentResources();
	@AttributeDocumentation("SSL Setting")
	private Boolean allowAnyHostname;
	@AttributeDocumentation("Refresh token on every single web request")
	private Boolean alwaysRefreshToken;
	@AttributeDocumentation("Base URL of the Realm Auth Server")
	private String authServerUrl;
	@AttributeDocumentation("URL to use to make background calls to auth server")
	private String authServerUrlForBackendRequests;
	@AttributeDocumentation("Bearer Token Auth only")
	private Boolean bearerOnly;
	@AttributeDocumentation("n/a")
	private String clientKeyPassword;
	@AttributeDocumentation("n/a")
	private String clientKeystore;
	@AttributeDocumentation("n/a")
	private String clientKeystorePassword;
	@AttributeDocumentation("Connection pool size for the client used by the adapter")
	private Integer connectionPoolSize;
	@AttributeDocumentation("CORS allowed headers")
	private String corsAllowedHeaders;
	@AttributeDocumentation("CORS allowed methods")
	private String corsAllowedMethods;
	@AttributeDocumentation("CORS max-age header")
	private Integer corsMaxAge;
	@AttributeDocumentation("Adapter will not use a trust manager when making adapter HTTPS requests")
	private Boolean disableTrustManager;
	@AttributeDocumentation("Enable Basic Authentication")
	private Boolean enableBasicAuth;
	@AttributeDocumentation("Enable Keycloak CORS support")
	private Boolean enableCors;
	@AttributeDocumentation("Enable secure URL that exposes access token")
	private Boolean exposeToken;
	@AttributeDocumentation("If adapter recognize token signed by unknown public key, it will try to download new public key from keycloak server. However it won't try to download if already tried it in less than 'min-time-between-jwks-requests' seconds")
	private Integer minTimeBetweenJwksRequests;
	@AttributeDocumentation("token attribute to use to set Principal name")
	private String principalAttribute;
	@AttributeDocumentation("Public client")
	private Boolean publicClient;
	@AttributeDocumentation("Keycloak realm")
	private String realm;
	@AttributeDocumentation("Public key of the realm")
	private String realmPublicKey;
	@AttributeDocumentation("Cluster setting")
	private Boolean registerNodeAtStartup;
	@AttributeDocumentation("how often to re-register node")
	private Integer registerNodePeriod;
	@AttributeDocumentation("Application name")
	private String resource;
	@AttributeDocumentation("Specify if SSL is required (valid values are all, external and none)")
	private String sslRequired;
	@AttributeDocumentation("The adapter will refresh the token if the current token is expired OR will expire in 'token-minimum-time-to-live' seconds or less")
	private Integer tokenMinimumTimeToLive;
	@AttributeDocumentation("cookie or session storage for auth session data")
	private String tokenStore;
	@AttributeDocumentation("Truststore used for adapter client HTTPS requests")
	private String truststore;
	@AttributeDocumentation("Password of the Truststore")
	private String truststorePassword;
	@AttributeDocumentation("The session id is changed by default on a successful login.  Change this to true if you want to turn this off")
	private Boolean turnOffChangeSessionIdOnLogin;
	@AttributeDocumentation("Use resource level permissions from token")
	private Boolean useResourceRoleMappings;

	public SecureDeployment(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public SecureDeploymentResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Credential objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Credential objects.
	 */
	@SuppressWarnings("unchecked")
	public T credentials(java.util.List<Credential> value) {
		this.subresources.credentials = value;
		return (T) this;
	}

	/**
	 * Add the Credential object to the list of subresources
	 * 
	 * @param value
	 *            The Credential to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T credential(Credential value) {
		this.subresources.credentials.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Credential object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Credential resource
	 * @param config
	 *            The CredentialConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T credential(java.lang.String childKey, CredentialConsumer consumer) {
		Credential<? extends Credential> child = new Credential<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		credential(child);
		return (T) this;
	}

	/**
	 * Create and configure a Credential object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Credential resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T credential(java.lang.String childKey) {
		credential(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Credential object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T credential(CredentialSupplier supplier) {
		credential(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for SecureDeployment
	 */
	public static class SecureDeploymentResources {
		/**
		 * Credential
		 */
		@ResourceDocumentation("Credential")
		@SubresourceInfo("credential")
		private List<Credential> credentials = new java.util.ArrayList<>();

		/**
		 * Get the list of Credential resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Credential> credentials() {
			return this.credentials;
		}

		public Credential credential(java.lang.String key) {
			return this.credentials.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * SSL Setting
	 */
	@ModelNodeBinding(detypedName = "allow-any-hostname")
	public Boolean allowAnyHostname() {
		return this.allowAnyHostname;
	}

	/**
	 * SSL Setting
	 */
	@SuppressWarnings("unchecked")
	public T allowAnyHostname(java.lang.Boolean value) {
		Object oldValue = this.allowAnyHostname;
		this.allowAnyHostname = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowAnyHostname", oldValue, value);
		return (T) this;
	}

	/**
	 * Refresh token on every single web request
	 */
	@ModelNodeBinding(detypedName = "always-refresh-token")
	public Boolean alwaysRefreshToken() {
		return this.alwaysRefreshToken;
	}

	/**
	 * Refresh token on every single web request
	 */
	@SuppressWarnings("unchecked")
	public T alwaysRefreshToken(java.lang.Boolean value) {
		Object oldValue = this.alwaysRefreshToken;
		this.alwaysRefreshToken = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("alwaysRefreshToken", oldValue, value);
		return (T) this;
	}

	/**
	 * Base URL of the Realm Auth Server
	 */
	@ModelNodeBinding(detypedName = "auth-server-url")
	public String authServerUrl() {
		return this.authServerUrl;
	}

	/**
	 * Base URL of the Realm Auth Server
	 */
	@SuppressWarnings("unchecked")
	public T authServerUrl(java.lang.String value) {
		Object oldValue = this.authServerUrl;
		this.authServerUrl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authServerUrl", oldValue, value);
		return (T) this;
	}

	/**
	 * URL to use to make background calls to auth server
	 */
	@ModelNodeBinding(detypedName = "auth-server-url-for-backend-requests")
	public String authServerUrlForBackendRequests() {
		return this.authServerUrlForBackendRequests;
	}

	/**
	 * URL to use to make background calls to auth server
	 */
	@SuppressWarnings("unchecked")
	public T authServerUrlForBackendRequests(java.lang.String value) {
		Object oldValue = this.authServerUrlForBackendRequests;
		this.authServerUrlForBackendRequests = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authServerUrlForBackendRequests",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Bearer Token Auth only
	 */
	@ModelNodeBinding(detypedName = "bearer-only")
	public Boolean bearerOnly() {
		return this.bearerOnly;
	}

	/**
	 * Bearer Token Auth only
	 */
	@SuppressWarnings("unchecked")
	public T bearerOnly(java.lang.Boolean value) {
		Object oldValue = this.bearerOnly;
		this.bearerOnly = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("bearerOnly", oldValue, value);
		return (T) this;
	}

	/**
	 * n/a
	 */
	@ModelNodeBinding(detypedName = "client-key-password")
	public String clientKeyPassword() {
		return this.clientKeyPassword;
	}

	/**
	 * n/a
	 */
	@SuppressWarnings("unchecked")
	public T clientKeyPassword(java.lang.String value) {
		Object oldValue = this.clientKeyPassword;
		this.clientKeyPassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientKeyPassword", oldValue, value);
		return (T) this;
	}

	/**
	 * n/a
	 */
	@ModelNodeBinding(detypedName = "client-keystore")
	public String clientKeystore() {
		return this.clientKeystore;
	}

	/**
	 * n/a
	 */
	@SuppressWarnings("unchecked")
	public T clientKeystore(java.lang.String value) {
		Object oldValue = this.clientKeystore;
		this.clientKeystore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientKeystore", oldValue, value);
		return (T) this;
	}

	/**
	 * n/a
	 */
	@ModelNodeBinding(detypedName = "client-keystore-password")
	public String clientKeystorePassword() {
		return this.clientKeystorePassword;
	}

	/**
	 * n/a
	 */
	@SuppressWarnings("unchecked")
	public T clientKeystorePassword(java.lang.String value) {
		Object oldValue = this.clientKeystorePassword;
		this.clientKeystorePassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clientKeystorePassword", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Connection pool size for the client used by the adapter
	 */
	@ModelNodeBinding(detypedName = "connection-pool-size")
	public Integer connectionPoolSize() {
		return this.connectionPoolSize;
	}

	/**
	 * Connection pool size for the client used by the adapter
	 */
	@SuppressWarnings("unchecked")
	public T connectionPoolSize(java.lang.Integer value) {
		Object oldValue = this.connectionPoolSize;
		this.connectionPoolSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionPoolSize", oldValue, value);
		return (T) this;
	}

	/**
	 * CORS allowed headers
	 */
	@ModelNodeBinding(detypedName = "cors-allowed-headers")
	public String corsAllowedHeaders() {
		return this.corsAllowedHeaders;
	}

	/**
	 * CORS allowed headers
	 */
	@SuppressWarnings("unchecked")
	public T corsAllowedHeaders(java.lang.String value) {
		Object oldValue = this.corsAllowedHeaders;
		this.corsAllowedHeaders = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("corsAllowedHeaders", oldValue, value);
		return (T) this;
	}

	/**
	 * CORS allowed methods
	 */
	@ModelNodeBinding(detypedName = "cors-allowed-methods")
	public String corsAllowedMethods() {
		return this.corsAllowedMethods;
	}

	/**
	 * CORS allowed methods
	 */
	@SuppressWarnings("unchecked")
	public T corsAllowedMethods(java.lang.String value) {
		Object oldValue = this.corsAllowedMethods;
		this.corsAllowedMethods = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("corsAllowedMethods", oldValue, value);
		return (T) this;
	}

	/**
	 * CORS max-age header
	 */
	@ModelNodeBinding(detypedName = "cors-max-age")
	public Integer corsMaxAge() {
		return this.corsMaxAge;
	}

	/**
	 * CORS max-age header
	 */
	@SuppressWarnings("unchecked")
	public T corsMaxAge(java.lang.Integer value) {
		Object oldValue = this.corsMaxAge;
		this.corsMaxAge = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("corsMaxAge", oldValue, value);
		return (T) this;
	}

	/**
	 * Adapter will not use a trust manager when making adapter HTTPS requests
	 */
	@ModelNodeBinding(detypedName = "disable-trust-manager")
	public Boolean disableTrustManager() {
		return this.disableTrustManager;
	}

	/**
	 * Adapter will not use a trust manager when making adapter HTTPS requests
	 */
	@SuppressWarnings("unchecked")
	public T disableTrustManager(java.lang.Boolean value) {
		Object oldValue = this.disableTrustManager;
		this.disableTrustManager = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("disableTrustManager", oldValue, value);
		return (T) this;
	}

	/**
	 * Enable Basic Authentication
	 */
	@ModelNodeBinding(detypedName = "enable-basic-auth")
	public Boolean enableBasicAuth() {
		return this.enableBasicAuth;
	}

	/**
	 * Enable Basic Authentication
	 */
	@SuppressWarnings("unchecked")
	public T enableBasicAuth(java.lang.Boolean value) {
		Object oldValue = this.enableBasicAuth;
		this.enableBasicAuth = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enableBasicAuth", oldValue, value);
		return (T) this;
	}

	/**
	 * Enable Keycloak CORS support
	 */
	@ModelNodeBinding(detypedName = "enable-cors")
	public Boolean enableCors() {
		return this.enableCors;
	}

	/**
	 * Enable Keycloak CORS support
	 */
	@SuppressWarnings("unchecked")
	public T enableCors(java.lang.Boolean value) {
		Object oldValue = this.enableCors;
		this.enableCors = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enableCors", oldValue, value);
		return (T) this;
	}

	/**
	 * Enable secure URL that exposes access token
	 */
	@ModelNodeBinding(detypedName = "expose-token")
	public Boolean exposeToken() {
		return this.exposeToken;
	}

	/**
	 * Enable secure URL that exposes access token
	 */
	@SuppressWarnings("unchecked")
	public T exposeToken(java.lang.Boolean value) {
		Object oldValue = this.exposeToken;
		this.exposeToken = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("exposeToken", oldValue, value);
		return (T) this;
	}

	/**
	 * If adapter recognize token signed by unknown public key, it will try to
	 * download new public key from keycloak server. However it won't try to
	 * download if already tried it in less than
	 * 'min-time-between-jwks-requests' seconds
	 */
	@ModelNodeBinding(detypedName = "min-time-between-jwks-requests")
	public Integer minTimeBetweenJwksRequests() {
		return this.minTimeBetweenJwksRequests;
	}

	/**
	 * If adapter recognize token signed by unknown public key, it will try to
	 * download new public key from keycloak server. However it won't try to
	 * download if already tried it in less than
	 * 'min-time-between-jwks-requests' seconds
	 */
	@SuppressWarnings("unchecked")
	public T minTimeBetweenJwksRequests(java.lang.Integer value) {
		Object oldValue = this.minTimeBetweenJwksRequests;
		this.minTimeBetweenJwksRequests = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("minTimeBetweenJwksRequests", oldValue,
					value);
		return (T) this;
	}

	/**
	 * token attribute to use to set Principal name
	 */
	@ModelNodeBinding(detypedName = "principal-attribute")
	public String principalAttribute() {
		return this.principalAttribute;
	}

	/**
	 * token attribute to use to set Principal name
	 */
	@SuppressWarnings("unchecked")
	public T principalAttribute(java.lang.String value) {
		Object oldValue = this.principalAttribute;
		this.principalAttribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("principalAttribute", oldValue, value);
		return (T) this;
	}

	/**
	 * Public client
	 */
	@ModelNodeBinding(detypedName = "public-client")
	public Boolean publicClient() {
		return this.publicClient;
	}

	/**
	 * Public client
	 */
	@SuppressWarnings("unchecked")
	public T publicClient(java.lang.Boolean value) {
		Object oldValue = this.publicClient;
		this.publicClient = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("publicClient", oldValue, value);
		return (T) this;
	}

	/**
	 * Keycloak realm
	 */
	@ModelNodeBinding(detypedName = "realm")
	public String realm() {
		return this.realm;
	}

	/**
	 * Keycloak realm
	 */
	@SuppressWarnings("unchecked")
	public T realm(java.lang.String value) {
		Object oldValue = this.realm;
		this.realm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("realm", oldValue, value);
		return (T) this;
	}

	/**
	 * Public key of the realm
	 */
	@ModelNodeBinding(detypedName = "realm-public-key")
	public String realmPublicKey() {
		return this.realmPublicKey;
	}

	/**
	 * Public key of the realm
	 */
	@SuppressWarnings("unchecked")
	public T realmPublicKey(java.lang.String value) {
		Object oldValue = this.realmPublicKey;
		this.realmPublicKey = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("realmPublicKey", oldValue, value);
		return (T) this;
	}

	/**
	 * Cluster setting
	 */
	@ModelNodeBinding(detypedName = "register-node-at-startup")
	public Boolean registerNodeAtStartup() {
		return this.registerNodeAtStartup;
	}

	/**
	 * Cluster setting
	 */
	@SuppressWarnings("unchecked")
	public T registerNodeAtStartup(java.lang.Boolean value) {
		Object oldValue = this.registerNodeAtStartup;
		this.registerNodeAtStartup = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("registerNodeAtStartup", oldValue,
					value);
		return (T) this;
	}

	/**
	 * how often to re-register node
	 */
	@ModelNodeBinding(detypedName = "register-node-period")
	public Integer registerNodePeriod() {
		return this.registerNodePeriod;
	}

	/**
	 * how often to re-register node
	 */
	@SuppressWarnings("unchecked")
	public T registerNodePeriod(java.lang.Integer value) {
		Object oldValue = this.registerNodePeriod;
		this.registerNodePeriod = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("registerNodePeriod", oldValue, value);
		return (T) this;
	}

	/**
	 * Application name
	 */
	@ModelNodeBinding(detypedName = "resource")
	public String resource() {
		return this.resource;
	}

	/**
	 * Application name
	 */
	@SuppressWarnings("unchecked")
	public T resource(java.lang.String value) {
		Object oldValue = this.resource;
		this.resource = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("resource", oldValue, value);
		return (T) this;
	}

	/**
	 * Specify if SSL is required (valid values are all, external and none)
	 */
	@ModelNodeBinding(detypedName = "ssl-required")
	public String sslRequired() {
		return this.sslRequired;
	}

	/**
	 * Specify if SSL is required (valid values are all, external and none)
	 */
	@SuppressWarnings("unchecked")
	public T sslRequired(java.lang.String value) {
		Object oldValue = this.sslRequired;
		this.sslRequired = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sslRequired", oldValue, value);
		return (T) this;
	}

	/**
	 * The adapter will refresh the token if the current token is expired OR
	 * will expire in 'token-minimum-time-to-live' seconds or less
	 */
	@ModelNodeBinding(detypedName = "token-minimum-time-to-live")
	public Integer tokenMinimumTimeToLive() {
		return this.tokenMinimumTimeToLive;
	}

	/**
	 * The adapter will refresh the token if the current token is expired OR
	 * will expire in 'token-minimum-time-to-live' seconds or less
	 */
	@SuppressWarnings("unchecked")
	public T tokenMinimumTimeToLive(java.lang.Integer value) {
		Object oldValue = this.tokenMinimumTimeToLive;
		this.tokenMinimumTimeToLive = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("tokenMinimumTimeToLive", oldValue,
					value);
		return (T) this;
	}

	/**
	 * cookie or session storage for auth session data
	 */
	@ModelNodeBinding(detypedName = "token-store")
	public String tokenStore() {
		return this.tokenStore;
	}

	/**
	 * cookie or session storage for auth session data
	 */
	@SuppressWarnings("unchecked")
	public T tokenStore(java.lang.String value) {
		Object oldValue = this.tokenStore;
		this.tokenStore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("tokenStore", oldValue, value);
		return (T) this;
	}

	/**
	 * Truststore used for adapter client HTTPS requests
	 */
	@ModelNodeBinding(detypedName = "truststore")
	public String truststore() {
		return this.truststore;
	}

	/**
	 * Truststore used for adapter client HTTPS requests
	 */
	@SuppressWarnings("unchecked")
	public T truststore(java.lang.String value) {
		Object oldValue = this.truststore;
		this.truststore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("truststore", oldValue, value);
		return (T) this;
	}

	/**
	 * Password of the Truststore
	 */
	@ModelNodeBinding(detypedName = "truststore-password")
	public String truststorePassword() {
		return this.truststorePassword;
	}

	/**
	 * Password of the Truststore
	 */
	@SuppressWarnings("unchecked")
	public T truststorePassword(java.lang.String value) {
		Object oldValue = this.truststorePassword;
		this.truststorePassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("truststorePassword", oldValue, value);
		return (T) this;
	}

	/**
	 * The session id is changed by default on a successful login. Change this
	 * to true if you want to turn this off
	 */
	@ModelNodeBinding(detypedName = "turn-off-change-session-id-on-login")
	public Boolean turnOffChangeSessionIdOnLogin() {
		return this.turnOffChangeSessionIdOnLogin;
	}

	/**
	 * The session id is changed by default on a successful login. Change this
	 * to true if you want to turn this off
	 */
	@SuppressWarnings("unchecked")
	public T turnOffChangeSessionIdOnLogin(java.lang.Boolean value) {
		Object oldValue = this.turnOffChangeSessionIdOnLogin;
		this.turnOffChangeSessionIdOnLogin = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("turnOffChangeSessionIdOnLogin",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Use resource level permissions from token
	 */
	@ModelNodeBinding(detypedName = "use-resource-role-mappings")
	public Boolean useResourceRoleMappings() {
		return this.useResourceRoleMappings;
	}

	/**
	 * Use resource level permissions from token
	 */
	@SuppressWarnings("unchecked")
	public T useResourceRoleMappings(java.lang.Boolean value) {
		Object oldValue = this.useResourceRoleMappings;
		this.useResourceRoleMappings = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useResourceRoleMappings", oldValue,
					value);
		return (T) this;
	}
}