package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> cache-configType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface CacheConfigType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:string ElementType : cache-value
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>cache-value</code> element
    * @param cacheValue the value for the element <code>cache-value</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> cacheValue(String cacheValue);

   /**
    * Returns the <code>cache-value</code> element
    * @return the node defined for the element <code>cache-value</code> 
    */
   public String getCacheValue();

   /**
    * Removes the <code>cache-value</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeCacheValue();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:xsdIntegerType ElementType : cache-max-size
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>cache-max-size</code> element
    * @param cacheMaxSize the value for the element <code>cache-max-size</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> cacheMaxSize(Integer cacheMaxSize);

   /**
    * Returns the <code>cache-max-size</code> element
    * @return the node defined for the element <code>cache-max-size</code> 
    */
   public Integer getCacheMaxSize();

   /**
    * Removes the <code>cache-max-size</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeCacheMaxSize();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:xsdIntegerType ElementType : idle-timeout-seconds
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>idle-timeout-seconds</code> element
    * @param idleTimeoutSeconds the value for the element <code>idle-timeout-seconds</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> idleTimeoutSeconds(Integer idleTimeoutSeconds);

   /**
    * Returns the <code>idle-timeout-seconds</code> element
    * @return the node defined for the element <code>idle-timeout-seconds</code> 
    */
   public Integer getIdleTimeoutSeconds();

   /**
    * Removes the <code>idle-timeout-seconds</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeIdleTimeoutSeconds();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:xsdIntegerType ElementType : remove-timeout-seconds
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>remove-timeout-seconds</code> element
    * @param removeTimeoutSeconds the value for the element <code>remove-timeout-seconds</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeTimeoutSeconds(Integer removeTimeoutSeconds);

   /**
    * Returns the <code>remove-timeout-seconds</code> element
    * @return the node defined for the element <code>remove-timeout-seconds</code> 
    */
   public Integer getRemoveTimeoutSeconds();

   /**
    * Removes the <code>remove-timeout-seconds</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeRemoveTimeoutSeconds();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:string ElementType : cache-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>cache-name</code> element
    * @param cacheName the value for the element <code>cache-name</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> cacheName(String cacheName);

   /**
    * Returns the <code>cache-name</code> element
    * @return the node defined for the element <code>cache-name</code> 
    */
   public String getCacheName();

   /**
    * Removes the <code>cache-name</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeCacheName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:string ElementType : persistence-manager
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>persistence-manager</code> element
    * @param persistenceManager the value for the element <code>persistence-manager</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> persistenceManager(String persistenceManager);

   /**
    * Returns the <code>persistence-manager</code> element
    * @return the node defined for the element <code>persistence-manager</code> 
    */
   public String getPersistenceManager();

   /**
    * Removes the <code>persistence-manager</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removePersistenceManager();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CacheConfigType ElementName: javaee:string ElementType : replication-is-passivation
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>replication-is-passivation</code> element
    * @param replicationIsPassivation the value for the element <code>replication-is-passivation</code> 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> replicationIsPassivation(String replicationIsPassivation);

   /**
    * Returns the <code>replication-is-passivation</code> element
    * @return the node defined for the element <code>replication-is-passivation</code> 
    */
   public String getReplicationIsPassivation();

   /**
    * Removes the <code>replication-is-passivation</code> element 
    * @return the current instance of <code>CacheConfigType<T></code> 
    */
   public CacheConfigType<T> removeReplicationIsPassivation();
}
