package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> remote-bindingType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface RemoteBindingType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RemoteBindingType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> description(String ... values);

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
   public List<String> getAllDescription();

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> removeAllDescription();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RemoteBindingType ElementName: xsd:token ElementType : jndi-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>jndi-name</code> element
    * @param jndiName the value for the element <code>jndi-name</code> 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> jndiName(String jndiName);

   /**
    * Returns the <code>jndi-name</code> element
    * @return the node defined for the element <code>jndi-name</code> 
    */
   public String getJndiName();

   /**
    * Removes the <code>jndi-name</code> element 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> removeJndiName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RemoteBindingType ElementName: javaee:string ElementType : client-bind-url
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>client-bind-url</code> element
    * @param clientBindUrl the value for the element <code>client-bind-url</code> 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> clientBindUrl(String clientBindUrl);

   /**
    * Returns the <code>client-bind-url</code> element
    * @return the node defined for the element <code>client-bind-url</code> 
    */
   public String getClientBindUrl();

   /**
    * Removes the <code>client-bind-url</code> element 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> removeClientBindUrl();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RemoteBindingType ElementName: javaee:string ElementType : interceptor-stack
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>interceptor-stack</code> element
    * @param interceptorStack the value for the element <code>interceptor-stack</code> 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> interceptorStack(String interceptorStack);

   /**
    * Returns the <code>interceptor-stack</code> element
    * @return the node defined for the element <code>interceptor-stack</code> 
    */
   public String getInterceptorStack();

   /**
    * Removes the <code>interceptor-stack</code> element 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> removeInterceptorStack();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RemoteBindingType ElementName: javaee:string ElementType : invoker-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>invoker-name</code> element
    * @param invokerName the value for the element <code>invoker-name</code> 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> invokerName(String invokerName);

   /**
    * Returns the <code>invoker-name</code> element
    * @return the node defined for the element <code>invoker-name</code> 
    */
   public String getInvokerName();

   /**
    * Removes the <code>invoker-name</code> element 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> removeInvokerName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: RemoteBindingType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>RemoteBindingType<T></code> 
    */
   public RemoteBindingType<T> removeId();
}
