package org.jboss.shrinkwrap.descriptor.api.jbossdeployment10; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.DeploymentType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.DeploymentType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ModuleType;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     JBossDeploymentStructureDescriptor descriptor = Descriptors.create(JBossDeploymentStructureDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface JBossDeploymentStructureDescriptor extends Descriptor, DescriptorNamespace<JBossDeploymentStructureDescriptor> {

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JBossDeploymentStructureDescriptor ElementName: xsd:boolean ElementType : ear-subdeployments-isolated
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>ear-subdeployments-isolated</code> element
    * @param earSubdeploymentsIsolated the value for the element <code>ear-subdeployments-isolated</code> 
    * @return the current instance of <code>JBossDeploymentStructureDescriptor</code> 
    */
   public JBossDeploymentStructureDescriptor earSubdeploymentsIsolated(Boolean earSubdeploymentsIsolated);

   /**
    * Returns the <code>ear-subdeployments-isolated</code> element
    * @return the node defined for the element <code>ear-subdeployments-isolated</code> 
    */
   public Boolean isEarSubdeploymentsIsolated();

   /**
    * Removes the <code>ear-subdeployments-isolated</code> element 
    * @return the current instance of <code>JBossDeploymentStructureDescriptor</code> 
    */
   public JBossDeploymentStructureDescriptor removeEarSubdeploymentsIsolated();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JBossDeploymentStructureDescriptor ElementName: jboss:deploymentType ElementType : deployment
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>deployment</code> element with the given value will be created.
    * Otherwise, the existing <code>deployment</code> element will be returned.
    * @return  a new or existing instance of <code>DeploymentType<JBossDeploymentStructureDescriptor></code> 
    */
   public DeploymentType<JBossDeploymentStructureDescriptor> getOrCreateDeployment();

   /**
    * Removes the <code>deployment</code> element 
    * @return the current instance of <code>JBossDeploymentStructureDescriptor</code> 
    */
   public JBossDeploymentStructureDescriptor removeDeployment();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JBossDeploymentStructureDescriptor ElementName: jboss:deploymentType ElementType : sub-deployment
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>sub-deployment</code> element will be created and returned.
    * Otherwise, the first existing <code>sub-deployment</code> element will be returned.
    * @return the instance defined for the element <code>sub-deployment</code> 
    */
   public DeploymentType<JBossDeploymentStructureDescriptor> getOrCreateSubDeployment();

   /**
    * Creates a new <code>sub-deployment</code> element 
    * @return the new created instance of <code>DeploymentType<JBossDeploymentStructureDescriptor></code> 
    */
   public DeploymentType<JBossDeploymentStructureDescriptor> createSubDeployment();

   /**
    * Returns all <code>sub-deployment</code> elements
    * @return list of <code>sub-deployment</code> 
    */
   public List<DeploymentType<JBossDeploymentStructureDescriptor>> getAllSubDeployment();

   /**
    * Removes all <code>sub-deployment</code> elements 
    * @return the current instance of <code>DeploymentType<JBossDeploymentStructureDescriptor></code> 
    */
   public JBossDeploymentStructureDescriptor removeAllSubDeployment();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JBossDeploymentStructureDescriptor ElementName: jboss:moduleType ElementType : module
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>module</code> element will be created and returned.
    * Otherwise, the first existing <code>module</code> element will be returned.
    * @return the instance defined for the element <code>module</code> 
    */
   public ModuleType<JBossDeploymentStructureDescriptor> getOrCreateModule();

   /**
    * Creates a new <code>module</code> element 
    * @return the new created instance of <code>ModuleType<JBossDeploymentStructureDescriptor></code> 
    */
   public ModuleType<JBossDeploymentStructureDescriptor> createModule();

   /**
    * Returns all <code>module</code> elements
    * @return list of <code>module</code> 
    */
   public List<ModuleType<JBossDeploymentStructureDescriptor>> getAllModule();

   /**
    * Removes all <code>module</code> elements 
    * @return the current instance of <code>ModuleType<JBossDeploymentStructureDescriptor></code> 
    */
   public JBossDeploymentStructureDescriptor removeAllModule();
}
