package org.jboss.shrinkwrap.descriptor.api.jbossdeployment11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.ModuleAliasType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.FilterType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.DependenciesType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.ExclusionsType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.ResourcesType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.TransformerSetType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.LocalLast;
/**
 * This interface defines the contract for the <code> deploymentType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface DeploymentType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:moduleAliasType ElementType : module-alias
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>module-alias</code> element with the given value will be created.
    * Otherwise, the existing <code>module-alias</code> element will be returned.
    * @return  a new or existing instance of <code>ModuleAliasType<DeploymentType<T>></code> 
    */
   public ModuleAliasType<DeploymentType<T>> getOrCreateModuleAlias();

   /**
    * Removes the <code>module-alias</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeModuleAlias();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<DeploymentType<T>></code> 
    */
   public FilterType<DeploymentType<T>> getOrCreateExports();

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeExports();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:dependenciesType ElementType : dependencies
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<DeploymentType<T>></code> 
    */
   public DependenciesType<DeploymentType<T>> getOrCreateDependencies();

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeDependencies();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:exclusionsType ElementType : exclusions
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclusions</code> element with the given value will be created.
    * Otherwise, the existing <code>exclusions</code> element will be returned.
    * @return  a new or existing instance of <code>ExclusionsType<DeploymentType<T>></code> 
    */
   public ExclusionsType<DeploymentType<T>> getOrCreateExclusions();

   /**
    * Removes the <code>exclusions</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeExclusions();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:resourcesType ElementType : resources
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resources</code> element with the given value will be created.
    * Otherwise, the existing <code>resources</code> element will be returned.
    * @return  a new or existing instance of <code>ResourcesType<DeploymentType<T>></code> 
    */
   public ResourcesType<DeploymentType<T>> getOrCreateResources();

   /**
    * Removes the <code>resources</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeResources();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:transformerSetType ElementType : transformers
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>transformers</code> element with the given value will be created.
    * Otherwise, the existing <code>transformers</code> element will be returned.
    * @return  a new or existing instance of <code>TransformerSetType<DeploymentType<T>></code> 
    */
   public TransformerSetType<DeploymentType<T>> getOrCreateTransformers();

   /**
    * Removes the <code>transformers</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeTransformers();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:localLast ElementType : local-last
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>local-last</code> element with the given value will be created.
    * Otherwise, the existing <code>local-last</code> element will be returned.
    * @return  a new or existing instance of <code>LocalLast<DeploymentType<T>></code> 
    */
   public LocalLast<DeploymentType<T>> getOrCreateLocalLast();

   /**
    * Removes the <code>local-last</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeLocalLast();
}
