package org.jboss.shrinkwrap.descriptor.api.jbossdeployment13; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.PathType;
/**
 * This interface defines the contract for the <code> pathSetType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface PathSetType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PathSetType ElementName: jboss:pathType ElementType : path
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>path</code> element will be created and returned.
    * Otherwise, the first existing <code>path</code> element will be returned.
    * @return the instance defined for the element <code>path</code> 
    */
   public PathType<PathSetType<T>> getOrCreatePath();

   /**
    * Creates a new <code>path</code> element 
    * @return the new created instance of <code>PathType<PathSetType<T>></code> 
    */
   public PathType<PathSetType<T>> createPath();

   /**
    * Returns all <code>path</code> elements
    * @return list of <code>path</code> 
    */
   public List<PathType<PathSetType<T>>> getAllPath();

   /**
    * Removes all <code>path</code> elements 
    * @return the current instance of <code>PathType<PathSetType<T>></code> 
    */
   public PathSetType<T> removeAllPath();
}
