package org.jboss.shrinkwrap.descriptor.api.jbossweb60; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.javaee6.GenericBooleanType;
/**
 * This interface defines the contract for the <code> passivation-configType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface PassivationConfigType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PassivationConfigType ElementName: javaee:generic-booleanType ElementType : use-session-passivation
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>use-session-passivation</code> element
    * @param useSessionPassivation the value for the element <code>use-session-passivation</code> 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> useSessionPassivation(GenericBooleanType useSessionPassivation);
   /**
    * Sets the <code>use-session-passivation</code> element
    * @param useSessionPassivation the value for the element <code>use-session-passivation</code> 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> useSessionPassivation(String useSessionPassivation);

   /**
    * Returns the <code>use-session-passivation</code> element
    * @return the value found for the element <code>use-session-passivation</code> 
    */
   public GenericBooleanType getUseSessionPassivation();

   /**
    * Returns the <code>use-session-passivation</code> element
    * @return the value found for the element <code>use-session-passivation</code> 
    */
   public String  getUseSessionPassivationAsString();

   /**
    * Removes the <code>use-session-passivation</code> attribute 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> removeUseSessionPassivation();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PassivationConfigType ElementName: xsd:integer ElementType : passivation-min-idle-time
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>passivation-min-idle-time</code> element
    * @param passivationMinIdleTime the value for the element <code>passivation-min-idle-time</code> 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> passivationMinIdleTime(Integer passivationMinIdleTime);

   /**
    * Returns the <code>passivation-min-idle-time</code> element
    * @return the node defined for the element <code>passivation-min-idle-time</code> 
    */
   public Integer getPassivationMinIdleTime();

   /**
    * Removes the <code>passivation-min-idle-time</code> element 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> removePassivationMinIdleTime();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PassivationConfigType ElementName: xsd:integer ElementType : passivation-max-idle-time
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>passivation-max-idle-time</code> element
    * @param passivationMaxIdleTime the value for the element <code>passivation-max-idle-time</code> 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> passivationMaxIdleTime(Integer passivationMaxIdleTime);

   /**
    * Returns the <code>passivation-max-idle-time</code> element
    * @return the node defined for the element <code>passivation-max-idle-time</code> 
    */
   public Integer getPassivationMaxIdleTime();

   /**
    * Removes the <code>passivation-max-idle-time</code> element 
    * @return the current instance of <code>PassivationConfigType<T></code> 
    */
   public PassivationConfigType<T> removePassivationMaxIdleTime();
}
