package org.jboss.shrinkwrap.descriptor.api.jbossweb60; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ReplicationTriggerType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ReplicationGranularityType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ReplicationModeType;
import org.jboss.shrinkwrap.descriptor.api.javaee6.GenericBooleanType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.SnapshotModeType;
/**
 * This interface defines the contract for the <code> replication-configType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ReplicationConfigType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: javaee:string ElementType : cache-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>cache-name</code> element
    * @param cacheName the value for the element <code>cache-name</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> cacheName(String cacheName);

   /**
    * Returns the <code>cache-name</code> element
    * @return the node defined for the element <code>cache-name</code> 
    */
   public String getCacheName();

   /**
    * Removes the <code>cache-name</code> element 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeCacheName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: jboss:replication-triggerType ElementType : replication-trigger
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>replication-trigger</code> element
    * @param replicationTrigger the value for the element <code>replication-trigger</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> replicationTrigger(ReplicationTriggerType replicationTrigger);
   /**
    * Sets the <code>replication-trigger</code> element
    * @param replicationTrigger the value for the element <code>replication-trigger</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> replicationTrigger(String replicationTrigger);

   /**
    * Returns the <code>replication-trigger</code> element
    * @return the value found for the element <code>replication-trigger</code> 
    */
   public ReplicationTriggerType getReplicationTrigger();

   /**
    * Returns the <code>replication-trigger</code> element
    * @return the value found for the element <code>replication-trigger</code> 
    */
   public String  getReplicationTriggerAsString();

   /**
    * Removes the <code>replication-trigger</code> attribute 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeReplicationTrigger();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: jboss:replication-granularityType ElementType : replication-granularity
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>replication-granularity</code> element
    * @param replicationGranularity the value for the element <code>replication-granularity</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> replicationGranularity(ReplicationGranularityType replicationGranularity);
   /**
    * Sets the <code>replication-granularity</code> element
    * @param replicationGranularity the value for the element <code>replication-granularity</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> replicationGranularity(String replicationGranularity);

   /**
    * Returns the <code>replication-granularity</code> element
    * @return the value found for the element <code>replication-granularity</code> 
    */
   public ReplicationGranularityType getReplicationGranularity();

   /**
    * Returns the <code>replication-granularity</code> element
    * @return the value found for the element <code>replication-granularity</code> 
    */
   public String  getReplicationGranularityAsString();

   /**
    * Removes the <code>replication-granularity</code> attribute 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeReplicationGranularity();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: jboss:replication-modeType ElementType : replication-mode
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>replication-mode</code> element
    * @param replicationMode the value for the element <code>replication-mode</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> replicationMode(ReplicationModeType replicationMode);
   /**
    * Sets the <code>replication-mode</code> element
    * @param replicationMode the value for the element <code>replication-mode</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> replicationMode(String replicationMode);

   /**
    * Returns the <code>replication-mode</code> element
    * @return the value found for the element <code>replication-mode</code> 
    */
   public ReplicationModeType getReplicationMode();

   /**
    * Returns the <code>replication-mode</code> element
    * @return the value found for the element <code>replication-mode</code> 
    */
   public String  getReplicationModeAsString();

   /**
    * Removes the <code>replication-mode</code> attribute 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeReplicationMode();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: xsd:integer ElementType : backups
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>backups</code> element
    * @param backups the value for the element <code>backups</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> backups(Integer backups);

   /**
    * Returns the <code>backups</code> element
    * @return the node defined for the element <code>backups</code> 
    */
   public Integer getBackups();

   /**
    * Removes the <code>backups</code> element 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeBackups();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: javaee:generic-booleanType ElementType : use-jk
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>use-jk</code> element
    * @param useJk the value for the element <code>use-jk</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> useJk(GenericBooleanType useJk);
   /**
    * Sets the <code>use-jk</code> element
    * @param useJk the value for the element <code>use-jk</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> useJk(String useJk);

   /**
    * Returns the <code>use-jk</code> element
    * @return the value found for the element <code>use-jk</code> 
    */
   public GenericBooleanType getUseJk();

   /**
    * Returns the <code>use-jk</code> element
    * @return the value found for the element <code>use-jk</code> 
    */
   public String  getUseJkAsString();

   /**
    * Removes the <code>use-jk</code> attribute 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeUseJk();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: xsd:integer ElementType : max-unreplicated-interval
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>max-unreplicated-interval</code> element
    * @param maxUnreplicatedInterval the value for the element <code>max-unreplicated-interval</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> maxUnreplicatedInterval(Integer maxUnreplicatedInterval);

   /**
    * Returns the <code>max-unreplicated-interval</code> element
    * @return the node defined for the element <code>max-unreplicated-interval</code> 
    */
   public Integer getMaxUnreplicatedInterval();

   /**
    * Removes the <code>max-unreplicated-interval</code> element 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeMaxUnreplicatedInterval();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: jboss:snapshot-modeType ElementType : snapshot-mode
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>snapshot-mode</code> element
    * @param snapshotMode the value for the element <code>snapshot-mode</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> snapshotMode(SnapshotModeType snapshotMode);
   /**
    * Sets the <code>snapshot-mode</code> element
    * @param snapshotMode the value for the element <code>snapshot-mode</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> snapshotMode(String snapshotMode);

   /**
    * Returns the <code>snapshot-mode</code> element
    * @return the value found for the element <code>snapshot-mode</code> 
    */
   public SnapshotModeType getSnapshotMode();

   /**
    * Returns the <code>snapshot-mode</code> element
    * @return the value found for the element <code>snapshot-mode</code> 
    */
   public String  getSnapshotModeAsString();

   /**
    * Removes the <code>snapshot-mode</code> attribute 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeSnapshotMode();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: xsd:integer ElementType : snapshot-interval
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>snapshot-interval</code> element
    * @param snapshotInterval the value for the element <code>snapshot-interval</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> snapshotInterval(Integer snapshotInterval);

   /**
    * Returns the <code>snapshot-interval</code> element
    * @return the node defined for the element <code>snapshot-interval</code> 
    */
   public Integer getSnapshotInterval();

   /**
    * Removes the <code>snapshot-interval</code> element 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeSnapshotInterval();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ReplicationConfigType ElementName: javaee:fully-qualified-classType ElementType : session-notification-policy
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>session-notification-policy</code> element
    * @param sessionNotificationPolicy the value for the element <code>session-notification-policy</code> 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> sessionNotificationPolicy(String sessionNotificationPolicy);

   /**
    * Returns the <code>session-notification-policy</code> element
    * @return the node defined for the element <code>session-notification-policy</code> 
    */
   public String getSessionNotificationPolicy();

   /**
    * Removes the <code>session-notification-policy</code> element 
    * @return the current instance of <code>ReplicationConfigType<T></code> 
    */
   public ReplicationConfigType<T> removeSessionNotificationPolicy();
}
