package org.jboss.shrinkwrap.descriptor.api.jbossweb60; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ServletSecurityType;
/**
 * This interface defines the contract for the <code> servletType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ServletType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletType ElementName: xsd:token ElementType : servlet-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>servlet-name</code> element
    * @param servletName the value for the element <code>servlet-name</code> 
    * @return the current instance of <code>ServletType<T></code> 
    */
   public ServletType<T> servletName(String servletName);

   /**
    * Returns the <code>servlet-name</code> element
    * @return the node defined for the element <code>servlet-name</code> 
    */
   public String getServletName();

   /**
    * Removes the <code>servlet-name</code> element 
    * @return the current instance of <code>ServletType<T></code> 
    */
   public ServletType<T> removeServletName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletType ElementName: xsd:token ElementType : run-as-principal
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>run-as-principal</code> element
    * @param runAsPrincipal the value for the element <code>run-as-principal</code> 
    * @return the current instance of <code>ServletType<T></code> 
    */
   public ServletType<T> runAsPrincipal(String runAsPrincipal);

   /**
    * Returns the <code>run-as-principal</code> element
    * @return the node defined for the element <code>run-as-principal</code> 
    */
   public String getRunAsPrincipal();

   /**
    * Removes the <code>run-as-principal</code> element 
    * @return the current instance of <code>ServletType<T></code> 
    */
   public ServletType<T> removeRunAsPrincipal();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ServletType ElementName: jboss:servlet-securityType ElementType : servlet-security
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>servlet-security</code> element with the given value will be created.
    * Otherwise, the existing <code>servlet-security</code> element will be returned.
    * @return  a new or existing instance of <code>ServletSecurityType<ServletType<T>></code> 
    */
   public ServletSecurityType<ServletType<T>> getOrCreateServletSecurity();

   /**
    * Removes the <code>servlet-security</code> element 
    * @return the current instance of <code>ServletType<T></code> 
    */
   public ServletType<T> removeServletSecurity();
}
