package org.jboss.shrinkwrap.descriptor.api.jbossweb60; 

/**
 * This class implements the <code> snapshot-modeType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public enum SnapshotModeType
{
   _INSTANT("INSTANT"),
   _FIELD("FIELD");

   private String value;

   SnapshotModeType (String value) { this.value = value; }

   public String toString() {return value;}

   public static SnapshotModeType getFromStringValue(String value)
   {
      for(SnapshotModeType type: SnapshotModeType.values())
      {
         if(value != null && type.toString().equals(value))
        { return type;}
      }
      return null;
   }

}

