package org.wildfly.swarm.config;

import org.wildfly.swarm.config.IIOPOpenjdk;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface IIOPOpenjdkConsumer<T extends IIOPOpenjdk<T>> {

	/**
	 * Configure a pre-constructed instance of IIOPOpenjdk resource
	 * 
	 * @parameter Instance of IIOPOpenjdk to configure
	 * @return nothing
	 */
	void accept(T value);

	default IIOPOpenjdkConsumer<T> andThen(IIOPOpenjdkConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}