package org.wildfly.swarm.config;

import org.wildfly.swarm.config.JAXRS;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface JAXRSConsumer<T extends JAXRS<T>> {

	/**
	 * Configure a pre-constructed instance of JAXRS resource
	 * 
	 * @parameter Instance of JAXRS to configure
	 * @return nothing
	 */
	void accept(T value);

	default JAXRSConsumer<T> andThen(JAXRSConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}