package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The cache expiration configuration.
 */
@Addresses({
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/component=expiration",
		"/subsystem=infinispan/cache-container=*/local-cache=*/component=expiration",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/component=expiration",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/component=expiration"})
@ResourceType("component")
@Implicit
public class ExpirationComponent<T extends ExpirationComponent<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Interval (in milliseconds) between subsequent runs to purge expired entries from memory and any cache stores. If you wish to disable the periodic eviction process altogether, set wakeupInterval to -1.")
	private Long interval;
	@AttributeDocumentation("Maximum lifespan of a cache entry, after which the entry is expired cluster-wide, in milliseconds. -1 means the entries never expire.")
	private Long lifespan;
	@AttributeDocumentation("Maximum idle time a cache entry will be maintained in the cache, in milliseconds. If the idle time is exceeded, the entry will be expired cluster-wide. -1 means the entries never expire.")
	private Long maxIdle;

	public ExpirationComponent() {
		super();
		this.key = "expiration";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Interval (in milliseconds) between subsequent runs to purge expired
	 * entries from memory and any cache stores. If you wish to disable the
	 * periodic eviction process altogether, set wakeupInterval to -1.
	 */
	@ModelNodeBinding(detypedName = "interval")
	public Long interval() {
		return this.interval;
	}

	/**
	 * Interval (in milliseconds) between subsequent runs to purge expired
	 * entries from memory and any cache stores. If you wish to disable the
	 * periodic eviction process altogether, set wakeupInterval to -1.
	 */
	@SuppressWarnings("unchecked")
	public T interval(java.lang.Long value) {
		Object oldValue = this.interval;
		this.interval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("interval", oldValue, value);
		return (T) this;
	}

	/**
	 * Maximum lifespan of a cache entry, after which the entry is expired
	 * cluster-wide, in milliseconds. -1 means the entries never expire.
	 */
	@ModelNodeBinding(detypedName = "lifespan")
	public Long lifespan() {
		return this.lifespan;
	}

	/**
	 * Maximum lifespan of a cache entry, after which the entry is expired
	 * cluster-wide, in milliseconds. -1 means the entries never expire.
	 */
	@SuppressWarnings("unchecked")
	public T lifespan(java.lang.Long value) {
		Object oldValue = this.lifespan;
		this.lifespan = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("lifespan", oldValue, value);
		return (T) this;
	}

	/**
	 * Maximum idle time a cache entry will be maintained in the cache, in
	 * milliseconds. If the idle time is exceeded, the entry will be expired
	 * cluster-wide. -1 means the entries never expire.
	 */
	@ModelNodeBinding(detypedName = "max-idle")
	public Long maxIdle() {
		return this.maxIdle;
	}

	/**
	 * Maximum idle time a cache entry will be maintained in the cache, in
	 * milliseconds. If the idle time is exceeded, the entry will be expired
	 * cluster-wide. -1 means the entries never expire.
	 */
	@SuppressWarnings("unchecked")
	public T maxIdle(java.lang.Long value) {
		Object oldValue = this.maxIdle;
		this.maxIdle = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxIdle", oldValue, value);
		return (T) this;
	}
}