package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A file handler for use with the management audit logging service.
 */
@Address("/core-service=management/access=audit/file-handler=*")
@ResourceType("file-handler")
public class FileHandler<T extends FileHandler<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Whether this handler has been disabled due to logging failures.")
	private Boolean disabledDueToFailure;
	@AttributeDocumentation("The number of logging failures since the handler was initialized.")
	private Integer failureCount;
	@AttributeDocumentation("The formatter used to format the log messages.")
	private String formatter;
	@AttributeDocumentation("The maximum number of logging failures before disabling this handler.")
	private Integer maxFailureCount;
	@AttributeDocumentation("The path of the audit log file.")
	private String path;
	@AttributeDocumentation("The name of another previously named path, or of one of the standard paths provided by the system. If 'relative-to' is provided, the value of the 'path' attribute is treated as relative to the path specified by this attribute.")
	private String relativeTo;

	public FileHandler(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Whether this handler has been disabled due to logging failures.
	 */
	@ModelNodeBinding(detypedName = "disabled-due-to-failure")
	public Boolean disabledDueToFailure() {
		return this.disabledDueToFailure;
	}

	/**
	 * Whether this handler has been disabled due to logging failures.
	 */
	@SuppressWarnings("unchecked")
	public T disabledDueToFailure(java.lang.Boolean value) {
		Object oldValue = this.disabledDueToFailure;
		this.disabledDueToFailure = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("disabledDueToFailure", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of logging failures since the handler was initialized.
	 */
	@ModelNodeBinding(detypedName = "failure-count")
	public Integer failureCount() {
		return this.failureCount;
	}

	/**
	 * The number of logging failures since the handler was initialized.
	 */
	@SuppressWarnings("unchecked")
	public T failureCount(java.lang.Integer value) {
		Object oldValue = this.failureCount;
		this.failureCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("failureCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The formatter used to format the log messages.
	 */
	@ModelNodeBinding(detypedName = "formatter")
	public String formatter() {
		return this.formatter;
	}

	/**
	 * The formatter used to format the log messages.
	 */
	@SuppressWarnings("unchecked")
	public T formatter(java.lang.String value) {
		Object oldValue = this.formatter;
		this.formatter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("formatter", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of logging failures before disabling this handler.
	 */
	@ModelNodeBinding(detypedName = "max-failure-count")
	public Integer maxFailureCount() {
		return this.maxFailureCount;
	}

	/**
	 * The maximum number of logging failures before disabling this handler.
	 */
	@SuppressWarnings("unchecked")
	public T maxFailureCount(java.lang.Integer value) {
		Object oldValue = this.maxFailureCount;
		this.maxFailureCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxFailureCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The path of the audit log file.
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * The path of the audit log file.
	 */
	@SuppressWarnings("unchecked")
	public T path(java.lang.String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of another previously named path, or of one of the standard
	 * paths provided by the system. If 'relative-to' is provided, the value of
	 * the 'path' attribute is treated as relative to the path specified by this
	 * attribute.
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The name of another previously named path, or of one of the standard
	 * paths provided by the system. If 'relative-to' is provided, the value of
	 * the 'path' attribute is treated as relative to the path specified by this
	 * attribute.
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(java.lang.String value) {
		Object oldValue = this.relativeTo;
		this.relativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("relativeTo", oldValue, value);
		return (T) this;
	}
}