package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.management.security_realm.authentication.UserConsumer;
import org.wildfly.swarm.config.management.security_realm.authentication.UserSupplier;
import org.wildfly.swarm.config.management.security_realm.authentication.User;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Configuration to use a list users stored directly within the standalone.xml
 * or host.xml configuration file as the user repository.
 */
@Address("/core-service=management/security-realm=*/authentication=users")
@ResourceType("authentication")
@Implicit
public class UsersAuthentication<T extends UsersAuthentication<T>>
		extends
			HashMap implements org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private UsersAuthenticationResources subresources = new UsersAuthenticationResources();

	public UsersAuthentication() {
		super();
		this.key = "users";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public UsersAuthenticationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all User objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of User objects.
	 */
	@SuppressWarnings("unchecked")
	public T users(java.util.List<User> value) {
		this.subresources.users = value;
		return (T) this;
	}

	/**
	 * Add the User object to the list of subresources
	 * 
	 * @param value
	 *            The User to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T user(User value) {
		this.subresources.users.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a User object to the list of subresources
	 * 
	 * @param key
	 *            The key for the User resource
	 * @param config
	 *            The UserConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T user(java.lang.String childKey, UserConsumer consumer) {
		User<? extends User> child = new User<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		user(child);
		return (T) this;
	}

	/**
	 * Create and configure a User object to the list of subresources
	 * 
	 * @param key
	 *            The key for the User resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T user(java.lang.String childKey) {
		user(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied User object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T user(UserSupplier supplier) {
		user(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for UsersAuthentication
	 */
	public static class UsersAuthenticationResources {
		/**
		 * An authorized user.
		 */
		@ResourceDocumentation("An authorized user.")
		@SubresourceInfo("user")
		private List<User> users = new java.util.ArrayList<>();

		/**
		 * Get the list of User resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<User> users() {
			return this.users;
		}

		public User user(java.lang.String key) {
			return this.users.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}
}