package org.jboss.shrinkwrap.descriptor.api.jobXML; 

import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;


public interface JobXMLCommonDescriptor<T extends JobXMLCommonDescriptor<T, PROPERTIES1, LISTENERS2, DECISION3, FLOW4, SPLIT5, STEP6>, 
    PROPERTIES1 extends JslPropertiesCommType<T, PROPERTIES1, ?>, 
    LISTENERS2 extends JslListenersCommType<T, LISTENERS2, ?>, 
    DECISION3 extends JslDecisionCommType<T, DECISION3, ?>, 
    FLOW4 extends JslFlowCommType<T, FLOW4, ?, ?, ?, ?>, 
    SPLIT5 extends JslSplitCommType<T, SPLIT5, ?>, 
    STEP6 extends JslStepCommType<T, STEP6, ?, ?, ?, ?, ?>> 
    extends Descriptor {


   /**
    * Sets the <code>Version</code> attribute
    * @param Version the value for the attribute <code>Version</code> 
    * @return the current instance of <code>T</code> 
    */
   public T version(String Version);

   /**
    * Returns the <code>Version</code> attribute
    * @return the value defined for the attribute <code>Version</code> 
    */
   public String getVersion();

   /**
    * Removes the <code>Version</code> attribute 
    * @return the current instance of <code>T</code> 
    */
   public T removeVersion();

   /**
    * Sets the <code>Id</code> attribute
    * @param Id the value for the attribute <code>Id</code> 
    * @return the current instance of <code>T</code> 
    */
   public T id(String Id);

   /**
    * Returns the <code>Id</code> attribute
    * @return the value defined for the attribute <code>Id</code> 
    */
   public String getId();

   /**
    * Removes the <code>Id</code> attribute 
    * @return the current instance of <code>T</code> 
    */
   public T removeId();

   /**
    * Sets the <code>Restartable</code> attribute
    * @param Restartable the value for the attribute <code>Restartable</code> 
    * @return the current instance of <code>T</code> 
    */
   public T restartable(String Restartable);

   /**
    * Returns the <code>Restartable</code> attribute
    * @return the value defined for the attribute <code>Restartable</code> 
    */
   public String getRestartable();

   /**
    * Removes the <code>Restartable</code> attribute 
    * @return the current instance of <code>T</code> 
    */
   public T removeRestartable();
}
