/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snakeyaml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.snakeyaml.TypeFilter;
import org.apache.camel.component.snakeyaml.TypeFilters;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public final class SnakeYAMLDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private final ThreadLocal<WeakReference<Yaml>> yamlCache = new ThreadLocal();
    private Function<CamelContext, BaseConstructor> constructor = this::defaultConstructor;
    private Function<CamelContext, Representer> representer = this::defaultRepresenter;
    private Function<CamelContext, DumperOptions> dumperOptions = this::defaultDumperOptions;
    private Function<CamelContext, Resolver> resolver = this::defaultResolver;
    private ClassLoader classLoader;
    private Class<?> unmarshalType;
    private List<TypeDescription> typeDescriptions;
    private ConcurrentMap<Class<?>, Tag> classTags;
    private boolean useApplicationContextClassLoader = true;
    private boolean prettyFlow = false;
    private boolean allowAnyType = false;
    private List<TypeFilter> typeFilters;

    public SnakeYAMLDataFormat() {
        this(null);
    }

    public SnakeYAMLDataFormat(Class<?> type) {
        if (type != null) {
            this.unmarshalType = type;
            this.typeFilters = new CopyOnWriteArrayList<TypeFilter>();
            this.typeFilters.add(TypeFilters.types(type));
        }
    }

    public String getDataFormatName() {
        return "yaml-snakeyaml";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        try (OutputStreamWriter osw = new OutputStreamWriter(stream, IOHelper.getCharsetName((Exchange)exchange));){
            this.getYaml(exchange.getContext()).dump(graph, (Writer)osw);
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        try (InputStreamReader isr = new InputStreamReader(stream, IOHelper.getCharsetName((Exchange)exchange));){
            Class unmarshalObjectType = this.unmarshalType != null ? this.unmarshalType : Object.class;
            Object object = this.getYaml(exchange.getContext()).loadAs((Reader)isr, unmarshalObjectType);
            return object;
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    protected Yaml getYaml(CamelContext context) {
        Yaml yaml = null;
        WeakReference<Yaml> ref = this.yamlCache.get();
        if (ref != null) {
            yaml = (Yaml)ref.get();
        }
        if (yaml == null) {
            yaml = new Yaml(this.constructor.apply(context), this.representer.apply(context), this.dumperOptions.apply(context), this.resolver.apply(context));
            this.yamlCache.set(new WeakReference<Yaml>(yaml));
        }
        return yaml;
    }

    public Function<CamelContext, BaseConstructor> getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Function<CamelContext, BaseConstructor> constructor) {
        this.constructor = constructor;
    }

    public Function<CamelContext, Representer> getRepresenter() {
        return this.representer;
    }

    public void setRepresenter(Function<CamelContext, Representer> representer) {
        this.representer = representer;
    }

    public Function<CamelContext, DumperOptions> getDumperOptions() {
        return this.dumperOptions;
    }

    public void setDumperOptions(Function<CamelContext, DumperOptions> dumperOptions) {
        this.dumperOptions = dumperOptions;
    }

    public Function<CamelContext, Resolver> getResolver() {
        return this.resolver;
    }

    public void setResolver(Function<CamelContext, Resolver> resolver) {
        this.resolver = resolver;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
        this.addTypeFilters(TypeFilters.types(unmarshalType));
    }

    public List<TypeDescription> getTypeDescriptions() {
        return this.typeDescriptions;
    }

    public void setTypeDescriptions(List<TypeDescription> typeDescriptions) {
        this.typeDescriptions = new CopyOnWriteArrayList<TypeDescription>(typeDescriptions);
    }

    public void addTypeDescriptions(Collection<TypeDescription> typeDescriptions) {
        if (this.typeDescriptions == null) {
            this.typeDescriptions = new CopyOnWriteArrayList<TypeDescription>();
        }
        this.typeDescriptions.addAll(typeDescriptions);
    }

    public void addTypeDescriptions(TypeDescription ... typeDescriptions) {
        this.addTypeDescriptions(Arrays.asList(typeDescriptions));
    }

    public void addTypeDescription(Class<?> type, Tag tag) {
        if (this.typeDescriptions == null) {
            this.typeDescriptions = new CopyOnWriteArrayList<TypeDescription>();
        }
        this.typeDescriptions.add(new TypeDescription(type, tag));
    }

    public Map<Class<?>, Tag> getClassTags() {
        return this.classTags;
    }

    public void setClassTags(Map<Class<?>, Tag> classTags) {
        this.classTags = new ConcurrentHashMap();
        this.classTags.putAll(classTags);
    }

    public void addClassTags(Class<?> type, Tag tag) {
        if (this.classTags == null) {
            this.classTags = new ConcurrentHashMap();
        }
        this.classTags.put(type, tag);
    }

    public boolean isUseApplicationContextClassLoader() {
        return this.useApplicationContextClassLoader;
    }

    public void setUseApplicationContextClassLoader(boolean useApplicationContextClassLoader) {
        this.useApplicationContextClassLoader = useApplicationContextClassLoader;
    }

    public boolean isPrettyFlow() {
        return this.prettyFlow;
    }

    public void setPrettyFlow(boolean prettyFlow) {
        this.prettyFlow = prettyFlow;
    }

    public void addTag(Class<?> type, Tag tag) {
        this.addClassTags(type, tag);
        this.addTypeDescription(type, tag);
    }

    public List<TypeFilter> getTypeFilters() {
        return this.typeFilters;
    }

    public void setTypeFilters(List<TypeFilter> typeFilters) {
        this.typeFilters = new CopyOnWriteArrayList<TypeFilter>(typeFilters);
    }

    public void setTypeFilterDefinitions(List<String> typeFilterDefinitions) {
        this.typeFilters = new CopyOnWriteArrayList<TypeFilter>();
        for (String definition : typeFilterDefinitions) {
            TypeFilters.valueOf(definition).ifPresent(this.typeFilters::add);
        }
    }

    public void addTypeFilters(Collection<TypeFilter> typeFilters) {
        if (this.typeFilters == null) {
            this.typeFilters = new CopyOnWriteArrayList<TypeFilter>();
        }
        this.typeFilters.addAll(typeFilters);
    }

    public void addTypeFilters(TypeFilter ... typeFilters) {
        this.addTypeFilters(Arrays.asList(typeFilters));
    }

    public boolean isAllowAnyType() {
        return this.allowAnyType;
    }

    public void setAllowAnyType(boolean allowAnyType) {
        this.allowAnyType = allowAnyType;
    }

    private BaseConstructor defaultConstructor(CamelContext context) {
        ClassLoader yamlClassLoader = this.classLoader;
        List<TypeFilter> yamlTypeFilters = this.typeFilters;
        if (yamlClassLoader == null && this.useApplicationContextClassLoader) {
            yamlClassLoader = context.getApplicationContextClassLoader();
        }
        if (this.allowAnyType) {
            yamlTypeFilters = Collections.singletonList(TypeFilters.allowAll());
        }
        Object yamlConstructor = yamlTypeFilters != null ? (yamlClassLoader != null ? SnakeYAMLDataFormat.typeFilterConstructor(yamlClassLoader, yamlTypeFilters) : SnakeYAMLDataFormat.typeFilterConstructor(yamlTypeFilters)) : new SafeConstructor();
        if (this.typeDescriptions != null && yamlConstructor instanceof Constructor) {
            for (TypeDescription typeDescription : this.typeDescriptions) {
                ((Constructor)yamlConstructor).addTypeDescription(typeDescription);
            }
        }
        return yamlConstructor;
    }

    private Representer defaultRepresenter(CamelContext context) {
        Representer yamlRepresenter = new Representer();
        if (this.classTags != null) {
            for (Map.Entry entry : this.classTags.entrySet()) {
                yamlRepresenter.addClassTag((Class)entry.getKey(), (Tag)entry.getValue());
            }
        }
        return yamlRepresenter;
    }

    private DumperOptions defaultDumperOptions(CamelContext context) {
        DumperOptions yamlDumperOptions = new DumperOptions();
        yamlDumperOptions.setPrettyFlow(this.prettyFlow);
        return yamlDumperOptions;
    }

    private Resolver defaultResolver(CamelContext context) {
        return new Resolver();
    }

    private static Constructor typeFilterConstructor(final Collection<TypeFilter> typeFilters) {
        return new Constructor(){

            protected Class<?> getClassForName(String name) throws ClassNotFoundException {
                if (typeFilters.stream().noneMatch(f -> f.test(name))) {
                    throw new IllegalArgumentException("Type " + name + " is not allowed");
                }
                return super.getClassForName(name);
            }
        };
    }

    private static Constructor typeFilterConstructor(ClassLoader classLoader, final Collection<TypeFilter> typeFilters) {
        return new CustomClassLoaderConstructor(classLoader){

            protected Class<?> getClassForName(String name) throws ClassNotFoundException {
                if (typeFilters.stream().noneMatch(f -> f.test(name))) {
                    throw new IllegalArgumentException("Type " + name + " is not allowed");
                }
                return super.getClassForName(name);
            }
        };
    }
}

