/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kinesis;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.aws.kinesis.KinesisEndpoint;
import org.apache.camel.impl.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KinesisConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisConsumer.class);
    private String currentShardIterator;

    public KinesisConsumer(KinesisEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected int poll() throws Exception {
        GetRecordsRequest req = new GetRecordsRequest().withShardIterator(this.getShardItertor()).withLimit(Integer.valueOf(this.getEndpoint().getMaxResultsPerRequest()));
        GetRecordsResult result = this.getClient().getRecords(req);
        Queue<Exchange> exchanges = this.createExchanges(result.getRecords());
        int processedExchangeCount = this.processBatch(CastUtils.cast(exchanges));
        this.currentShardIterator = result.getNextShardIterator();
        return processedExchangeCount;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int processedExchanges = 0;
        while (!exchanges.isEmpty()) {
            final Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            LOG.trace("Processing exchange [{}] started.", (Object)exchange);
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    LOG.trace("Processing exchange [{}] done.", (Object)exchange);
                }
            });
            ++processedExchanges;
        }
        return processedExchanges;
    }

    private AmazonKinesis getClient() {
        return this.getEndpoint().getClient();
    }

    public KinesisEndpoint getEndpoint() {
        return (KinesisEndpoint)super.getEndpoint();
    }

    private String getShardItertor() {
        if (this.currentShardIterator == null) {
            String shardId;
            if (!this.getEndpoint().getShardId().isEmpty()) {
                shardId = this.getEndpoint().getShardId();
            } else {
                DescribeStreamRequest req1 = new DescribeStreamRequest().withStreamName(this.getEndpoint().getStreamName());
                DescribeStreamResult res1 = this.getClient().describeStream(req1);
                shardId = ((Shard)res1.getStreamDescription().getShards().get(0)).getShardId();
            }
            LOG.debug("ShardId is: {}", (Object)shardId);
            GetShardIteratorRequest req = new GetShardIteratorRequest().withStreamName(this.getEndpoint().getStreamName()).withShardId(shardId).withShardIteratorType(this.getEndpoint().getIteratorType());
            if (this.hasSequenceNumber()) {
                req.withStartingSequenceNumber(this.getEndpoint().getSequenceNumber());
            }
            GetShardIteratorResult result = this.getClient().getShardIterator(req);
            this.currentShardIterator = result.getShardIterator();
        }
        LOG.debug("Shard Iterator is: {}", (Object)this.currentShardIterator);
        return this.currentShardIterator;
    }

    private Queue<Exchange> createExchanges(List<Record> records) {
        ArrayDeque<Exchange> exchanges = new ArrayDeque<Exchange>();
        for (Record record : records) {
            exchanges.add(this.getEndpoint().createExchange(record));
        }
        return exchanges;
    }

    private boolean hasSequenceNumber() {
        return !this.getEndpoint().getSequenceNumber().isEmpty() && (this.getEndpoint().getIteratorType().equals((Object)ShardIteratorType.AFTER_SEQUENCE_NUMBER) || this.getEndpoint().getIteratorType().equals((Object)ShardIteratorType.AT_SEQUENCE_NUMBER));
    }
}

