/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.OUncompletedCommit;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.entity.OEntityManagerClassHandler;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.object.db.OObjectNotDetachedException;
import com.orientechnologies.orient.object.dictionary.ODictionaryWrapper;
import com.orientechnologies.orient.object.enhancement.OObjectEntityEnhancer;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.enhancement.OObjectMethodFilter;
import com.orientechnologies.orient.object.enhancement.OObjectProxyMethodHandler;
import com.orientechnologies.orient.object.entity.OObjectEntityClassHandler;
import com.orientechnologies.orient.object.iterator.OObjectIteratorClass;
import com.orientechnologies.orient.object.iterator.OObjectIteratorCluster;
import com.orientechnologies.orient.object.metadata.OMetadataObject;
import com.orientechnologies.orient.object.serialization.OObjectSerializerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyObject;

public class OObjectDatabaseTx
extends ODatabasePojoAbstract<Object>
implements ODatabaseObject,
ODatabaseInternal<Object> {
    public static final String TYPE = "object";
    protected ODictionary<Object> dictionary;
    protected OEntityManager entityManager;
    protected boolean saveOnlyDirty;
    protected boolean lazyLoading;
    protected boolean automaticSchemaGeneration;
    protected OMetadataObject metadata;

    public OObjectDatabaseTx(String iURL) {
        super(new ODatabaseDocumentTx(iURL));
        ((ODatabaseDocumentTx)this.underlying).setDatabaseOwner((ODatabaseInternal)this);
        this.init();
    }

    public OObjectDatabaseTx(ODatabaseDocumentTx iDatabase) {
        super(iDatabase);
        ((ODatabaseDocumentTx)this.underlying).setDatabaseOwner((ODatabaseInternal)this);
        this.init();
    }

    public <T> T newInstance(Class<T> iType) {
        return (T)this.newInstance(iType.getSimpleName(), null, OCommonConst.EMPTY_OBJECT_ARRAY);
    }

    public <T> T newInstance(Class<T> iType, Object ... iArgs) {
        return (T)this.newInstance(iType.getSimpleName(), null, iArgs);
    }

    public <RET> RET newInstance(String iClassName) {
        return this.newInstance(iClassName, null, OCommonConst.EMPTY_OBJECT_ARRAY);
    }

    public <THISDB extends ODatabase> THISDB open(String iUserName, String iUserPassword) {
        super.open(iUserName, iUserPassword);
        this.entityManager.registerEntityClass(OUser.class);
        this.entityManager.registerEntityClass(ORole.class);
        this.metadata = new OMetadataObject((OMetadataInternal)((ODatabaseDocumentTx)this.underlying).getMetadata());
        return (THISDB)((Object)this);
    }

    public <THISDB extends ODatabase> THISDB open(OToken iToken) {
        super.open(iToken);
        this.entityManager.registerEntityClass(OUser.class);
        this.entityManager.registerEntityClass(ORole.class);
        this.metadata = new OMetadataObject((OMetadataInternal)((ODatabaseDocumentTx)this.underlying).getMetadata());
        return (THISDB)((Object)this);
    }

    public OMetadataObject getMetadata() {
        this.checkOpeness();
        if (this.metadata == null) {
            this.metadata = new OMetadataObject((OMetadataInternal)((ODatabaseDocumentTx)this.underlying).getMetadata());
        }
        return this.metadata;
    }

    public Iterable<ODatabaseListener> getListeners() {
        return ((ODatabaseDocumentTx)this.underlying).getListeners();
    }

    public <RET> RET newInstance(String iClassName, Object iEnclosingClass, Object ... iArgs) {
        ((ODatabaseDocumentTx)this.underlying).checkIfActive();
        this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_CREATE, (Object)iClassName);
        try {
            Class entityClass = this.entityManager.getEntityClass(iClassName);
            if (entityClass != null) {
                Object enhanced = OObjectEntityEnhancer.getInstance().getProxiedInstance(this.entityManager.getEntityClass(iClassName), iEnclosingClass, ((ODatabaseDocumentTx)this.underlying).newInstance(iClassName), null, iArgs);
                return (RET)enhanced;
            }
            throw new OSerializationException("Type " + iClassName + " cannot be serialized because is not part of registered entities. To fix this error register this class");
        }
        catch (Exception e) {
            String message = "Error on creating object of class " + iClassName;
            OLogManager.instance().error((Object)this, message, (Throwable)e, new Object[0]);
            throw OException.wrapException((OException)new ODatabaseException(message), (Throwable)e);
        }
    }

    public <RET> RET newInstance(String iClassName, Object iEnclosingClass, ODocument iDocument, Object ... iArgs) {
        this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_CREATE, (Object)iClassName);
        try {
            Class entityClass = this.entityManager.getEntityClass(iClassName);
            if (entityClass != null) {
                Object enhanced = OObjectEntityEnhancer.getInstance().getProxiedInstance(this.entityManager.getEntityClass(iClassName), iEnclosingClass, iDocument, null, iArgs);
                return (RET)enhanced;
            }
            throw new OSerializationException("Type " + iClassName + " cannot be serialized because is not part of registered entities. To fix this error register this class");
        }
        catch (Exception e) {
            String message = "Error on creating object of class " + iClassName;
            OLogManager.instance().error((Object)this, message, (Throwable)e, new Object[0]);
            throw OException.wrapException((OException)new ODatabaseException(message), (Throwable)e);
        }
    }

    public <RET> OObjectIteratorClass<RET> browseClass(Class<RET> iClusterClass) {
        return this.browseClass(iClusterClass, true);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(Class<RET> iClusterClass, boolean iPolymorphic) {
        if (iClusterClass == null) {
            return null;
        }
        return this.browseClass(iClusterClass.getSimpleName(), iPolymorphic);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(String iClassName) {
        return this.browseClass(iClassName, true);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(String iClassName, boolean iPolymorphic) {
        this.checkOpeness();
        this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)iClassName);
        return new OObjectIteratorClass(this, (ODatabaseDocumentInternal)((ODatabaseDocumentTx)this.getUnderlying()), iClassName, iPolymorphic);
    }

    public <RET> OObjectIteratorCluster<RET> browseCluster(String iClusterName) {
        this.checkOpeness();
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        return new OObjectIteratorCluster(this, (ODatabaseDocumentInternal)((ODatabaseDocumentTx)this.getUnderlying()), this.getClusterIdByName(iClusterName));
    }

    public <RET> RET load(Object iPojo) {
        return this.load(iPojo, null);
    }

    public <RET> RET reload(Object iPojo) {
        return this.reload(iPojo, null, true);
    }

    public <RET> RET reload(Object iPojo, boolean iIgnoreCache) {
        return this.reload(iPojo, null, iIgnoreCache);
    }

    public <RET> RET reload(Object iPojo, String iFetchPlan, boolean iIgnoreCache) {
        return this.reload(iPojo, iFetchPlan, iIgnoreCache, true);
    }

    public <RET> RET reload(Object iObject, String iFetchPlan, boolean iIgnoreCache, boolean force) {
        this.checkOpeness();
        if (iObject == null) {
            return null;
        }
        ODocument record = this.getRecordByUserObject(iObject, true);
        ((ODatabaseDocumentTx)this.underlying).reload((ORecord)record, iFetchPlan, iIgnoreCache, force);
        iObject = this.stream2pojo(record, iObject, iFetchPlan, true);
        return (RET)iObject;
    }

    public <RET> RET load(Object iPojo, String iFetchPlan) {
        return this.load(iPojo, iFetchPlan, false);
    }

    @Override
    public void attach(Object iPojo) {
        OObjectEntitySerializer.attach(iPojo, this);
    }

    public <RET> RET attachAndSave(Object iPojo) {
        this.attach(iPojo);
        return this.save(iPojo);
    }

    @Override
    public <RET> RET detach(Object iPojo) {
        return (RET)OObjectEntitySerializer.detach(iPojo, this);
    }

    public <RET> RET detach(Object iPojo, boolean returnNonProxiedInstance) {
        return (RET)OObjectEntitySerializer.detach(iPojo, this, returnNonProxiedInstance);
    }

    public <RET> RET detachAll(Object iPojo, boolean returnNonProxiedInstance) {
        return this.detachAll(iPojo, returnNonProxiedInstance, new HashMap<Object, Object>(), new HashMap<Object, Object>());
    }

    public <RET> RET load(Object iPojo, String iFetchPlan, boolean iIgnoreCache) {
        return this.load(iPojo, iFetchPlan, iIgnoreCache, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Deprecated
    public <RET> RET load(Object iPojo, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        return this.load(iPojo, iFetchPlan, iIgnoreCache, !iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public <RET> RET load(Object iPojo, String iFetchPlan, boolean iIgnoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkOpeness();
        if (iPojo == null) {
            return null;
        }
        ODocument record = this.getRecordByUserObject(iPojo, true);
        try {
            record.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            record = (ODocument)((ODatabaseDocumentTx)this.underlying).load((ORecord)record, iFetchPlan, iIgnoreCache, iUpdateCache, loadTombstone, OStorage.LOCKING_STRATEGY.DEFAULT);
            Object object = this.stream2pojo(record, iPojo, iFetchPlan);
            return (RET)object;
        }
        finally {
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
    }

    public <RET> RET load(ORID recordId) {
        return this.load(recordId, (String)null);
    }

    public <RET> RET load(ORID iRecordId, String iFetchPlan) {
        return this.load(iRecordId, iFetchPlan, false);
    }

    public <RET> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        return this.load(iRecordId, iFetchPlan, iIgnoreCache, !iIgnoreCache, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Deprecated
    public <RET> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        return this.load(iRecordId, iFetchPlan, iIgnoreCache, !iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    @Deprecated
    public <RET> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkOpeness();
        if (iRecordId == null) {
            return null;
        }
        ODocument record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(iRecordId, iFetchPlan, iIgnoreCache, iUpdateCache, loadTombstone, OStorage.LOCKING_STRATEGY.DEFAULT);
        if (record == null) {
            return null;
        }
        return (RET)OObjectEntityEnhancer.getInstance().getProxiedInstance(record.getClassName(), this.entityManager, record, null, new Object[0]);
    }

    public <RET> RET save(Object iContent) {
        return this.save(iContent, null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
    }

    public <RET> RET save(Object iContent, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        return this.save(iContent, null, iMode, false, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    public <RET> RET save(Object iPojo, String iClusterName) {
        return this.save(iPojo, iClusterName, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RET> RET save(Object iPojo, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        this.checkOpeness();
        if (iPojo == null) {
            return (RET)iPojo;
        }
        if (OMultiValue.isMultiValue((Object)iPojo)) {
            for (Object pojo : OMultiValue.getMultiValueIterable((Object)iPojo)) {
                this.save(pojo, iClusterName);
            }
            return (RET)iPojo;
        }
        ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
        Object proxiedObject = OObjectEntitySerializer.serializeObject(iPojo, this);
        ODocument record = this.getRecordByUserObject(proxiedObject, true);
        try {
            record.setInternalStatus(ORecordElement.STATUS.MARSHALLING);
            if (!this.saveOnlyDirty || record.isDirty()) {
                this.deleteOrphans((OObjectProxyMethodHandler)((ProxyObject)proxiedObject).getHandler());
                ODocument savedRecord = (ODocument)((ODatabaseDocumentTx)this.underlying).save((ORecord)record, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
                ((OObjectProxyMethodHandler)((ProxyObject)proxiedObject).getHandler()).setDoc(savedRecord);
                ((OObjectProxyMethodHandler)((ProxyObject)proxiedObject).getHandler()).updateLoadedFieldMap(proxiedObject, false);
                this.registerUserObject(proxiedObject, (ORecord)record);
            }
        }
        finally {
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return (RET)proxiedObject;
    }

    public ODatabaseObject delete(Object iPojo) {
        this.checkOpeness();
        if (iPojo == null) {
            return this;
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            ORecordId rid = OObjectSerializerHelper.getObjectID(this, iPojo);
            if (rid == null) {
                throw new OObjectNotDetachedException("Cannot retrieve the object's ID for '" + iPojo + "' because has not been detached");
            }
            record = (ODocument)((ODatabaseDocumentTx)this.underlying).load((ORID)rid);
        }
        this.deleteCascade(record);
        ((ODatabaseDocumentTx)this.underlying).delete((ORecord)record);
        if (this.getTransaction() instanceof OTransactionNoTx) {
            this.unregisterPojo(iPojo, record);
        }
        return this;
    }

    public ODatabaseObject delete(ORID iRID) {
        this.checkOpeness();
        if (iRID == null) {
            return this;
        }
        ORecord record = iRID.getRecord();
        if (record instanceof ODocument) {
            Object iPojo = this.getUserObjectByRecord((OIdentifiable)record, null);
            this.deleteCascade((ODocument)record);
            ((ODatabaseDocumentTx)this.underlying).delete(record);
            if (this.getTransaction() instanceof OTransactionNoTx) {
                this.unregisterPojo(iPojo, (ODocument)record);
            }
        }
        return this;
    }

    public ODatabaseObject delete(ORID iRID, int iVersion) {
        this.deleteRecord(iRID, iVersion, false);
        return this;
    }

    public boolean hide(ORID rid) {
        throw new UnsupportedOperationException("hide");
    }

    @Override
    public ODatabase<Object> cleanOutRecord(ORID iRID, int iVersion) {
        this.deleteRecord(iRID, iVersion, true);
        return this;
    }

    public long countClass(String iClassName) {
        this.checkOpeness();
        return ((ODatabaseDocumentTx)this.underlying).countClass(iClassName);
    }

    public long countClass(String iClassName, boolean iPolymorphic) {
        this.checkOpeness();
        return ((ODatabaseDocumentTx)this.underlying).countClass(iClassName, iPolymorphic);
    }

    public long countClass(Class<?> iClass) {
        this.checkOpeness();
        return ((ODatabaseDocumentTx)this.underlying).countClass(iClass.getSimpleName());
    }

    public ODictionary<Object> getDictionary() {
        this.checkOpeness();
        if (this.dictionary == null) {
            this.dictionary = new ODictionaryWrapper(this, (OIndex<OIdentifiable>)((ODatabaseDocumentTx)this.underlying).getDictionary().getIndex());
        }
        return this.dictionary;
    }

    @Override
    public ODatabasePojoAbstract<Object> commit() {
        return this.commit(false);
    }

    @Override
    public ODatabasePojoAbstract<Object> commit(boolean force) throws OTransactionException {
        ((ODatabaseDocumentTx)this.underlying).commit(force);
        if (this.getTransaction().isActive()) {
            return this;
        }
        if (this.getTransaction().getAllRecordEntries() != null) {
            Object pojo = null;
            for (ORecordOperation entry : this.getTransaction().getAllRecordEntries()) {
                switch (entry.type) {
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        ORecord rec = entry.getRecord();
                        if (!(rec instanceof ODocument)) break;
                        this.unregisterPojo((Object)pojo, (ODocument)rec);
                    }
                }
            }
        }
        return this;
    }

    public OUncompletedCommit<Void> initiateCommit() {
        return this.initiateCommit(false);
    }

    public OUncompletedCommit<Void> initiateCommit(boolean force) {
        OUncompletedCommit nestedCommit = ((ODatabaseDocumentTx)this.underlying).initiateCommit(force);
        return new UncompletedCommit(this.getTransaction().amountOfNestedTxs() == 0, (OUncompletedCommit<Void>)nestedCommit);
    }

    @Override
    public ODatabasePojoAbstract<Object> rollback() {
        return this.rollback(false);
    }

    @Override
    public ODatabasePojoAbstract<Object> rollback(boolean force) throws OTransactionException {
        ((ODatabaseDocumentTx)this.underlying).rollback(force);
        if (!((ODatabaseDocumentTx)this.underlying).getTransaction().isActive()) {
            if (this.getTransaction().getAllRecordEntries() != null) {
                ArrayList<ORecordOperation> newEntries = new ArrayList<ORecordOperation>();
                for (ORecordOperation entry : this.getTransaction().getAllRecordEntries()) {
                    if (entry.type != 3) continue;
                    newEntries.add(entry);
                }
            } else {
                Object var2_3 = null;
            }
        }
        return this;
    }

    public OEntityManager getEntityManager() {
        return this.entityManager;
    }

    public ODatabaseDocumentInternal getUnderlying() {
        return (ODatabaseDocumentInternal)this.underlying;
    }

    @Override
    public int getVersion(Object iPojo) {
        this.checkOpeness();
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record != null) {
            return record.getVersion();
        }
        return OObjectSerializerHelper.getObjectVersion(iPojo);
    }

    @Override
    public ORID getIdentity(Object iPojo) {
        this.checkOpeness();
        if (iPojo instanceof OIdentifiable) {
            return ((OIdentifiable)iPojo).getIdentity();
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record != null) {
            return record.getIdentity();
        }
        return OObjectSerializerHelper.getObjectID(this, iPojo);
    }

    public boolean isSaveOnlyDirty() {
        return this.saveOnlyDirty;
    }

    public void setSaveOnlyDirty(boolean saveOnlyDirty) {
        this.saveOnlyDirty = saveOnlyDirty;
    }

    public boolean isAutomaticSchemaGeneration() {
        return this.automaticSchemaGeneration;
    }

    public void setAutomaticSchemaGeneration(boolean automaticSchemaGeneration) {
        this.automaticSchemaGeneration = automaticSchemaGeneration;
    }

    public Object newInstance() {
        this.checkOpeness();
        return new ODocument();
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, byte iOperation) {
        return (DBTYPE)((ODatabaseDocumentTx)this.underlying).checkSecurity(resourceGeneric, resourceSpecific, (int)iOperation);
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(ORule.ResourceGeneric iResource, int iOperation, Object iResourceSpecific) {
        return (DBTYPE)((ODatabaseDocumentTx)this.underlying).checkSecurity(iResource, iOperation, iResourceSpecific);
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(ORule.ResourceGeneric iResource, int iOperation, Object ... iResourcesSpecific) {
        return (DBTYPE)((ODatabaseDocumentTx)this.underlying).checkSecurity(iResource, iOperation, iResourcesSpecific);
    }

    @Override
    public ODocument pojo2Stream(Object iPojo, ODocument iRecord) {
        if (iPojo instanceof ProxyObject) {
            return ((OObjectProxyMethodHandler)((ProxyObject)iPojo).getHandler()).getDoc();
        }
        return OObjectSerializerHelper.toStream(iPojo, iRecord, this.getEntityManager(), this.getMetadata().getSchema().getClass(iPojo.getClass().getSimpleName()), (OUserObject2RecordHandler)this, this, this.saveOnlyDirty);
    }

    @Override
    public Object stream2pojo(ODocument iRecord, Object iPojo, String iFetchPlan) {
        return this.stream2pojo(iRecord, iPojo, iFetchPlan, false);
    }

    public Object stream2pojo(ODocument iRecord, Object iPojo, String iFetchPlan, boolean iReload) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            iRecord = (ODocument)iRecord.load();
        }
        if (iReload) {
            if (iPojo != null) {
                if (iPojo instanceof Proxy) {
                    ((OObjectProxyMethodHandler)((ProxyObject)iPojo).getHandler()).setDoc(iRecord);
                    ((OObjectProxyMethodHandler)((ProxyObject)iPojo).getHandler()).updateLoadedFieldMap(iPojo, iReload);
                    return iPojo;
                }
                return OObjectEntityEnhancer.getInstance().getProxiedInstance(iPojo.getClass(), iRecord, new Object[0]);
            }
            return OObjectEntityEnhancer.getInstance().getProxiedInstance(iRecord.getClassName(), this.entityManager, iRecord, null, new Object[0]);
        }
        if (!(iPojo instanceof Proxy)) {
            return OObjectEntityEnhancer.getInstance().getProxiedInstance(iPojo.getClass(), iRecord, new Object[0]);
        }
        return iPojo;
    }

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public void setLazyLoading(boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
    }

    public String getType() {
        return TYPE;
    }

    public ORecordConflictStrategy getConflictStrategy() {
        return ((ODatabaseDocumentTx)this.underlying).getConflictStrategy();
    }

    public OObjectDatabaseTx setConflictStrategy(ORecordConflictStrategy iResolver) {
        ((ODatabaseDocumentTx)this.underlying).setConflictStrategy(iResolver);
        return this;
    }

    public OObjectDatabaseTx setConflictStrategy(String iStrategyName) {
        this.getStorage().setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(iStrategyName));
        return this;
    }

    @Override
    public ODocument getRecordByUserObject(Object iPojo, boolean iCreateIfNotAvailable) {
        if (iPojo instanceof Proxy) {
            return OObjectEntitySerializer.getDocument((Proxy)iPojo);
        }
        return OObjectEntitySerializer.getDocument((Proxy)OObjectEntitySerializer.serializeObject(iPojo, this));
    }

    @Override
    public Object getUserObjectByRecord(OIdentifiable iRecord, String iFetchPlan, boolean iCreate) {
        ODocument document = (ODocument)iRecord.getRecord();
        return OObjectEntityEnhancer.getInstance().getProxiedInstance(document.getClassName(), this.getEntityManager(), document, null, new Object[0]);
    }

    @Override
    public void registerUserObject(Object iObject, ORecord iRecord) {
    }

    public void registerUserObjectAfterLinkSave(ORecord iRecord) {
    }

    @Override
    public void unregisterPojo(Object iObject, ODocument iRecord) {
    }

    public void registerClassMethodFilter(Class<?> iClass, OObjectMethodFilter iMethodFilter) {
        OObjectEntityEnhancer.getInstance().registerClassMethodFilter(iClass, iMethodFilter);
    }

    public void deregisterClassMethodFilter(Class<?> iClass) {
        OObjectEntityEnhancer.getInstance().deregisterClassMethodFilter(iClass);
    }

    public String incrementalBackup(String path) {
        return ((ODatabaseDocumentTx)this.underlying).incrementalBackup(path);
    }

    public void resetInitialization() {
        ((ODatabaseDocumentTx)this.underlying).resetInitialization();
    }

    protected <RET> RET detachAll(Object iPojo, boolean returnNonProxiedInstance, Map<Object, Object> alreadyDetached, Map<Object, Object> lazyObjects) {
        return (RET)OObjectEntitySerializer.detachAll(iPojo, this, returnNonProxiedInstance, alreadyDetached, lazyObjects);
    }

    protected void deleteCascade(ODocument record) {
        if (record == null) {
            return;
        }
        List<String> toDeleteCascade = OObjectEntitySerializer.getCascadeDeleteFields(record.getClassName());
        if (toDeleteCascade != null) {
            for (String field : toDeleteCascade) {
                Object toDelete = record.field(field);
                if (toDelete instanceof OIdentifiable) {
                    if (toDelete == null) continue;
                    this.delete(((OIdentifiable)toDelete).getIdentity());
                    continue;
                }
                if (toDelete instanceof Collection) {
                    for (OIdentifiable cascadeRecord : (Collection)toDelete) {
                        if (cascadeRecord == null) continue;
                        this.delete(cascadeRecord.getIdentity());
                    }
                    continue;
                }
                if (!(toDelete instanceof Map)) continue;
                for (OIdentifiable cascadeRecord : ((Map)toDelete).values()) {
                    if (cascadeRecord == null) continue;
                    this.delete(cascadeRecord.getIdentity());
                }
            }
        }
    }

    protected void init() {
        this.entityManager = OEntityManager.getEntityManagerByDatabaseURL((String)this.getURL());
        this.entityManager.setClassHandler((OEntityManagerClassHandler)OObjectEntityClassHandler.getInstance(this.getURL()));
        this.saveOnlyDirty = OGlobalConfiguration.OBJECT_SAVE_ONLY_DIRTY.getValueAsBoolean();
        OObjectSerializerHelper.register();
        this.lazyLoading = true;
        if (!this.isClosed() && this.entityManager.getEntityClass(OUser.class.getSimpleName()) == null) {
            this.entityManager.registerEntityClass(OUser.class);
            this.entityManager.registerEntityClass(ORole.class);
        }
    }

    protected void deleteOrphans(OObjectProxyMethodHandler handler) {
        for (ORID orphan : handler.getOrphans()) {
            ODocument doc = (ODocument)orphan.getRecord();
            this.deleteCascade(doc);
            if (doc == null) continue;
            ((ODatabaseDocumentTx)this.underlying).delete((ORecord)doc);
        }
        handler.getOrphans().clear();
    }

    private boolean deleteRecord(ORID iRID, int iVersion, boolean prohibitTombstones) {
        this.checkOpeness();
        if (iRID == null) {
            return true;
        }
        ODocument record = (ODocument)iRID.getRecord();
        if (record != null) {
            Object iPojo = this.getUserObjectByRecord((OIdentifiable)record, null);
            this.deleteCascade(record);
            if (prohibitTombstones) {
                ((ODatabaseDocumentTx)this.underlying).cleanOutRecord(iRID, iVersion);
            } else {
                ((ODatabaseDocumentTx)this.underlying).delete(iRID, iVersion);
            }
            if (this.getTransaction() instanceof OTransactionNoTx) {
                this.unregisterPojo(iPojo, record);
            }
        }
        return false;
    }

    public int addBlobCluster(String iClusterName, Object ... iParameters) {
        return this.getUnderlying().addBlobCluster(iClusterName, iParameters);
    }

    public Set<Integer> getBlobClusterIds() {
        return this.getUnderlying().getBlobClusterIds();
    }

    private class UncompletedCommit
    implements OUncompletedCommit<Void> {
        private final boolean topLevel;
        private final OUncompletedCommit<Void> nestedCommit;

        public UncompletedCommit(boolean topLevel, OUncompletedCommit<Void> nestedCommit) {
            this.topLevel = topLevel;
            this.nestedCommit = nestedCommit;
        }

        public Void complete() {
            this.nestedCommit.complete();
            if (!this.topLevel) {
                return null;
            }
            if (OObjectDatabaseTx.this.getTransaction().getAllRecordEntries() != null) {
                Object pojo = null;
                for (ORecordOperation entry : OObjectDatabaseTx.this.getTransaction().getAllRecordEntries()) {
                    switch (entry.type) {
                        case 1: 
                        case 3: {
                            break;
                        }
                        case 2: {
                            ORecord rec = entry.getRecord();
                            if (!(rec instanceof ODocument)) break;
                            OObjectDatabaseTx.this.unregisterPojo((Object)pojo, (ODocument)rec);
                        }
                    }
                }
            }
            return null;
        }

        public void rollback() {
            this.nestedCommit.rollback();
            if (!this.topLevel) {
                return;
            }
            if (OObjectDatabaseTx.this.getTransaction().getAllRecordEntries() != null) {
                ArrayList<ORecordOperation> newEntries = new ArrayList<ORecordOperation>();
                for (ORecordOperation entry : OObjectDatabaseTx.this.getTransaction().getAllRecordEntries()) {
                    if (entry.type != 3) continue;
                    newEntries.add(entry);
                }
            } else {
                Object newEntries = null;
            }
        }
    }
}

