/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.iterator.OIterationException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class OIdentifiableIterator<REC extends OIdentifiable>
implements Iterator<REC>,
Iterable<REC> {
    protected final ODatabaseDocumentInternal database;
    protected final ORecordId current = new ORecordId();
    private final ODatabaseDocumentInternal lowLevelDatabase;
    private final OStorage dbStorage;
    private final boolean iterateThroughTombstones;
    protected boolean liveUpdated = false;
    protected long limit = -1L;
    protected long browsedRecords = 0L;
    protected OStorage.LOCKING_STRATEGY lockingStrategy = OStorage.LOCKING_STRATEGY.NONE;
    protected long totalAvailableRecords;
    protected List<ORecordOperation> txEntries;
    protected int currentTxEntryPosition = -1;
    protected long firstClusterEntry = 0L;
    protected long lastClusterEntry = Long.MAX_VALUE;
    private String fetchPlan;
    private ORecord reusedRecord = null;
    private Boolean directionForward;
    private long currentEntry = -1L;
    private int currentEntryPosition = -1;
    private OPhysicalPosition[] positionsToProcess = null;

    public OIdentifiableIterator(ODatabaseDocumentInternal iDatabase, ODatabaseDocumentInternal iLowLevelDatabase) {
        this(iDatabase, iLowLevelDatabase, false, OStorage.LOCKING_STRATEGY.NONE);
    }

    @Deprecated
    public OIdentifiableIterator(ODatabaseDocumentInternal iDatabase, ODatabaseDocumentInternal iLowLevelDatabase, boolean iterateThroughTombstones, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.database = iDatabase;
        this.lowLevelDatabase = iLowLevelDatabase;
        this.iterateThroughTombstones = iterateThroughTombstones;
        this.lockingStrategy = iLockingStrategy;
        this.dbStorage = this.lowLevelDatabase.getStorage();
        this.current.clusterPosition = -1L;
    }

    public boolean isIterateThroughTombstones() {
        return this.iterateThroughTombstones;
    }

    public abstract boolean hasPrevious();

    public abstract OIdentifiable previous();

    public abstract OIdentifiableIterator<REC> begin();

    public abstract OIdentifiableIterator<REC> last();

    public ORecord current() {
        return this.readCurrentRecord(this.getRecord(), 0);
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean isReuseSameRecord() {
        return this.reusedRecord != null;
    }

    public OIdentifiableIterator<REC> setReuseSameRecord(boolean reuseSameRecord) {
        this.reusedRecord = reuseSameRecord ? this.database.newInstance() : null;
        return this;
    }

    public long getCurrentEntry() {
        return this.currentEntry;
    }

    @Override
    public Iterator<REC> iterator() {
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public OIdentifiableIterator<REC> setLimit(long limit) {
        this.limit = limit;
        return this;
    }

    public boolean isLiveUpdated() {
        return this.liveUpdated;
    }

    public OIdentifiableIterator<REC> setLiveUpdated(boolean liveUpdated) {
        this.liveUpdated = liveUpdated;
        return this;
    }

    protected ORecord getTransactionEntry() {
        boolean noPhysicalRecordToBrowse;
        if (this.current.clusterPosition < -1L) {
            noPhysicalRecordToBrowse = true;
        } else if (this.directionForward.booleanValue()) {
            noPhysicalRecordToBrowse = this.lastClusterEntry <= this.currentEntry;
        } else {
            boolean bl = noPhysicalRecordToBrowse = this.currentEntry <= this.firstClusterEntry;
        }
        if (!noPhysicalRecordToBrowse && this.positionsToProcess.length == 0) {
            noPhysicalRecordToBrowse = true;
        }
        if (noPhysicalRecordToBrowse && this.txEntries != null) {
            ++this.currentTxEntryPosition;
            if (this.currentTxEntryPosition >= this.txEntries.size()) {
                throw new NoSuchElementException();
            }
            return this.txEntries.get(this.currentTxEntryPosition).getRecord();
        }
        return null;
    }

    protected ORecord getRecord() {
        ORecord record;
        if (this.reusedRecord != null) {
            record = this.reusedRecord;
            record.reset();
        } else {
            record = null;
        }
        return record;
    }

    protected void checkDirection(boolean iForward) {
        if (this.directionForward == null) {
            this.directionForward = iForward;
        } else if (this.directionForward != iForward) {
            throw new OIterationException("Iterator cannot change direction while browsing");
        }
    }

    protected ORecord readCurrentRecord(ORecord iRecord, int iMovement) {
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return null;
        }
        do {
            boolean moveResult;
            switch (iMovement) {
                case 1: {
                    moveResult = this.nextPosition();
                    break;
                }
                case -1: {
                    moveResult = this.prevPosition();
                    break;
                }
                case 0: {
                    moveResult = this.checkCurrentPosition();
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid movement value : " + iMovement);
                }
            }
            if (!moveResult) {
                return null;
            }
            try {
                if (iRecord != null) {
                    ORecordInternal.setIdentity(iRecord, new ORecordId(this.current.clusterId, this.current.clusterPosition));
                    iRecord = (ORecord)this.lowLevelDatabase.load(iRecord, this.fetchPlan, false, true, this.iterateThroughTombstones, this.lockingStrategy);
                } else {
                    iRecord = (ORecord)this.lowLevelDatabase.load(this.current, this.fetchPlan, false, true, this.iterateThroughTombstones, this.lockingStrategy);
                }
            }
            catch (ODatabaseException e) {
                if (Thread.interrupted() || this.lowLevelDatabase.isClosed()) {
                    throw e;
                }
                if (e.getCause() instanceof OSecurityException) {
                    throw e;
                }
                OLogManager.instance().error((Object)this, "Error on fetching record during browsing. The record has been skipped", e, new Object[0]);
            }
            if (iRecord == null) continue;
            ++this.browsedRecords;
            return iRecord;
        } while (iMovement != 0);
        return null;
    }

    protected boolean nextPosition() {
        if (this.positionsToProcess == null) {
            this.positionsToProcess = this.dbStorage.ceilingPhysicalPositions(this.current.clusterId, new OPhysicalPosition(this.firstClusterEntry));
            if (this.positionsToProcess == null) {
                return false;
            }
        } else if (this.currentEntry >= this.lastClusterEntry) {
            return false;
        }
        this.incrementEntreePosition();
        while (this.positionsToProcess.length > 0 && this.currentEntryPosition >= this.positionsToProcess.length) {
            this.positionsToProcess = this.dbStorage.higherPhysicalPositions(this.current.clusterId, this.positionsToProcess[this.positionsToProcess.length - 1]);
            this.currentEntryPosition = -1;
            this.incrementEntreePosition();
        }
        if (this.positionsToProcess.length == 0) {
            return false;
        }
        this.currentEntry = this.positionsToProcess[this.currentEntryPosition].clusterPosition;
        if (this.currentEntry > this.lastClusterEntry || this.currentEntry == -1L) {
            return false;
        }
        this.current.clusterPosition = this.currentEntry;
        return true;
    }

    protected boolean checkCurrentPosition() {
        if (this.currentEntry == -1L || this.firstClusterEntry > this.currentEntry || this.lastClusterEntry < this.currentEntry) {
            return false;
        }
        this.current.clusterPosition = this.currentEntry;
        return true;
    }

    protected boolean prevPosition() {
        if (this.positionsToProcess == null) {
            this.positionsToProcess = this.dbStorage.floorPhysicalPositions(this.current.clusterId, new OPhysicalPosition(this.lastClusterEntry));
            if (this.positionsToProcess == null) {
                return false;
            }
            if (this.positionsToProcess.length == 0) {
                return false;
            }
            this.currentEntryPosition = this.positionsToProcess.length;
        } else if (this.currentEntry < this.firstClusterEntry) {
            return false;
        }
        this.decrementEntreePosition();
        while (this.positionsToProcess.length > 0 && this.currentEntryPosition < 0) {
            this.positionsToProcess = this.dbStorage.lowerPhysicalPositions(this.current.clusterId, this.positionsToProcess[0]);
            this.currentEntryPosition = this.positionsToProcess.length;
            this.decrementEntreePosition();
        }
        if (this.positionsToProcess.length == 0) {
            return false;
        }
        this.currentEntry = this.positionsToProcess[this.currentEntryPosition].clusterPosition;
        if (this.currentEntry < this.firstClusterEntry) {
            return false;
        }
        this.current.clusterPosition = this.currentEntry;
        return true;
    }

    protected void resetCurrentPosition() {
        this.currentEntry = -1L;
        this.positionsToProcess = null;
        this.currentEntryPosition = -1;
    }

    protected long currentPosition() {
        return this.currentEntry;
    }

    protected void checkForSystemClusters(ODatabaseDocumentInternal iDatabase, int[] iClusterIds) {
        for (int clId : iClusterIds) {
            OSecurityUser dbUser;
            OCluster cl = iDatabase.getStorage().getClusterById(clId);
            if (cl != null && cl.isSystemCluster() && ((dbUser = iDatabase.getUser()) == null || dbUser.allow(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_READ) != null)) break;
        }
    }

    private void decrementEntreePosition() {
        if (this.positionsToProcess.length > 0) {
            if (this.iterateThroughTombstones) {
                --this.currentEntryPosition;
            } else {
                do {
                    --this.currentEntryPosition;
                } while (this.currentEntryPosition >= 0 && ORecordVersionHelper.isTombstone(this.positionsToProcess[this.currentEntryPosition].recordVersion));
            }
        }
    }

    private void incrementEntreePosition() {
        if (this.positionsToProcess.length > 0) {
            if (this.iterateThroughTombstones) {
                ++this.currentEntryPosition;
            } else {
                do {
                    ++this.currentEntryPosition;
                } while (this.currentEntryPosition < this.positionsToProcess.length && ORecordVersionHelper.isTombstone(this.positionsToProcess[this.currentEntryPosition].recordVersion));
            }
        }
    }
}

