/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.engine;

import java.io.Closeable;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.component.reactive.streams.ReactiveStreamsBackpressureStrategy;
import org.apache.camel.component.reactive.streams.ReactiveStreamsConsumer;
import org.apache.camel.component.reactive.streams.engine.CamelSubscription;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelSubscriber
implements Subscriber<Exchange>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CamelSubscriber.class);
    private static final long MAX_INFLIGHT_UNBOUNDED = 0x3FFFFFFFFFFFFFFFL;
    private ReactiveStreamsConsumer consumer;
    private Subscription subscription;
    private String name;
    private long requested;
    private long inflightCount;

    public CamelSubscriber(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachConsumer(ReactiveStreamsConsumer consumer) {
        CamelSubscriber camelSubscriber = this;
        synchronized (camelSubscriber) {
            if (this.consumer != null) {
                throw new IllegalStateException("A consumer is already attached to the stream '" + this.name + "'");
            }
            this.consumer = consumer;
        }
        this.refill();
    }

    public synchronized ReactiveStreamsConsumer getConsumer() {
        return this.consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachConsumer() {
        CamelSubscriber camelSubscriber = this;
        synchronized (camelSubscriber) {
            this.consumer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(Subscription subscription) {
        if (subscription == null) {
            throw new NullPointerException("subscription is null for stream '" + this.name + "'");
        }
        boolean allowed = true;
        CamelSubscriber camelSubscriber = this;
        synchronized (camelSubscriber) {
            if (this.subscription != null) {
                allowed = false;
            } else {
                this.subscription = subscription;
            }
        }
        if (!allowed) {
            LOG.warn("There is another active subscription: cancelled");
            subscription.cancel();
        } else {
            this.refill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(Exchange exchange) {
        ReactiveStreamsConsumer target;
        if (exchange == null) {
            throw new NullPointerException("exchange is null");
        }
        CamelSubscriber camelSubscriber = this;
        synchronized (camelSubscriber) {
            --this.requested;
            target = this.consumer;
            if (target != null) {
                ++this.inflightCount;
            }
        }
        if (target != null) {
            target.process(exchange, doneSync -> {
                CamelSubscriber camelSubscriber = this;
                synchronized (camelSubscriber) {
                    --this.inflightCount;
                }
                this.refill();
            });
        } else {
            LOG.warn("Message received in stream '{}', but no consumers were attached. Discarding {}.", (Object)this.name, (Object)exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refill() {
        Long toBeRequested = null;
        Subscription subs = null;
        CamelSubscriber camelSubscriber = this;
        synchronized (camelSubscriber) {
            Integer consMax;
            long max;
            long newRequest;
            if (this.consumer != null && this.subscription != null && (newRequest = (max = (consMax = this.consumer.getEndpoint().getMaxInflightExchanges()) != null && consMax > 0 ? consMax.longValue() : 0x3FFFFFFFFFFFFFFFL) - this.requested - this.inflightCount) > 0L) {
                toBeRequested = newRequest;
                this.requested += toBeRequested.longValue();
                subs = this.subscription;
            }
        }
        if (toBeRequested != null) {
            subs.request(toBeRequested.longValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable throwable) {
        ReactiveStreamsConsumer consumer;
        if (throwable == null) {
            throw new NullPointerException("throwable is null");
        }
        LOG.error("Error in reactive stream '" + this.name + "'", throwable);
        CamelSubscriber camelSubscriber = this;
        synchronized (camelSubscriber) {
            consumer = this.consumer;
            this.subscription = null;
        }
        if (consumer != null) {
            consumer.onError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        ReactiveStreamsConsumer consumer;
        LOG.info("Reactive stream '{}' completed", (Object)this.name);
        CamelSubscriber camelSubscriber = this;
        synchronized (camelSubscriber) {
            consumer = this.consumer;
            this.subscription = null;
        }
        if (consumer != null) {
            consumer.onComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Subscription subscription;
        CamelSubscriber camelSubscriber = this;
        synchronized (camelSubscriber) {
            subscription = this.subscription;
        }
        if (subscription != null) {
            subscription.cancel();
        }
    }

    public long getRequested() {
        return this.requested;
    }

    public long getInflightCount() {
        return this.inflightCount;
    }

    public long getBufferSize() {
        if (this.subscription != null && this.subscription instanceof CamelSubscription) {
            return ((CamelSubscription)this.subscription).getBufferSize();
        }
        return 0L;
    }

    public ReactiveStreamsBackpressureStrategy getBackpressureStrategy() {
        if (this.subscription != null && this.subscription instanceof CamelSubscription) {
            return ((CamelSubscription)this.subscription).getBackpressureStrategy();
        }
        return null;
    }
}

