/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.util.Map;
import org.apache.camel.component.netty4.NettyServerBootstrapFactory;
import org.apache.camel.component.netty4.ServerInitializerFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.jsse.SSLContextParameters;

@UriParams
public class NettyServerBootstrapConfiguration
implements Cloneable {
    public static final String DEFAULT_ENABLED_PROTOCOLS = "TLSv1,TLSv1.1,TLSv1.2";
    @UriPath(enums="tcp,udp")
    @Metadata(required="true")
    protected String protocol;
    @UriPath
    @Metadata(required="true")
    protected String host;
    @UriPath
    @Metadata(required="true")
    protected int port;
    @UriParam(label="consumer")
    protected boolean broadcast;
    @UriParam(label="advanced", defaultValue="65536")
    protected int sendBufferSize = 65536;
    @UriParam(label="advanced", defaultValue="65536")
    protected int receiveBufferSize = 65536;
    @UriParam(label="advanced")
    protected int receiveBufferSizePredictor;
    @UriParam(label="consumer,advanced", defaultValue="1")
    protected int bossCount = 1;
    @UriParam(label="advanced")
    protected int workerCount;
    @UriParam(defaultValue="true")
    protected boolean keepAlive = true;
    @UriParam(defaultValue="true")
    protected boolean tcpNoDelay = true;
    @UriParam(defaultValue="true")
    protected boolean reuseAddress = true;
    @UriParam(label="producer", defaultValue="10000")
    protected int connectTimeout = 10000;
    @UriParam(label="consumer,advanced")
    protected int backlog;
    @UriParam(label="consumer,advanced")
    protected ServerInitializerFactory serverInitializerFactory;
    @UriParam(label="consumer,advanced")
    protected NettyServerBootstrapFactory nettyServerBootstrapFactory;
    @UriParam(label="advanced", prefix="option.", multiValue=true)
    protected Map<String, Object> options;
    @UriParam(label="security")
    protected boolean ssl;
    @UriParam(label="security")
    protected boolean sslClientCertHeaders;
    @UriParam(label="security")
    protected SslHandler sslHandler;
    @UriParam(label="security")
    protected SSLContextParameters sslContextParameters;
    @UriParam(label="consumer,security")
    protected boolean needClientAuth;
    @UriParam(label="security")
    protected File keyStoreFile;
    @UriParam(label="security")
    protected File trustStoreFile;
    @UriParam(label="security")
    protected String keyStoreResource;
    @UriParam(label="security")
    protected String trustStoreResource;
    @UriParam(label="security")
    protected String keyStoreFormat;
    @UriParam(label="security")
    protected String securityProvider;
    @UriParam(defaultValue="TLSv1,TLSv1.1,TLSv1.2", label="security")
    protected String enabledProtocols = "TLSv1,TLSv1.1,TLSv1.2";
    @UriParam(label="security", secret=true)
    protected String passphrase;
    @UriParam(label="advanced")
    protected boolean nativeTransport;
    @UriParam(label="consumer,advanced")
    protected EventLoopGroup bossGroup;
    @UriParam(label="advanced")
    protected EventLoopGroup workerGroup;
    @UriParam(label="advanced")
    protected ChannelGroup channelGroup;
    @UriParam(label="consumer,advanced")
    protected String networkInterface;
    @UriParam(label="consumer", defaultValue="true")
    private boolean reconnect = true;
    @UriParam(label="consumer", defaultValue="10000")
    private int reconnectInterval = 10000;

    public String getAddress() {
        return this.host + ":" + this.port;
    }

    public boolean isTcp() {
        return this.protocol.equalsIgnoreCase("tcp");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getReceiveBufferSizePredictor() {
        return this.receiveBufferSizePredictor;
    }

    public void setReceiveBufferSizePredictor(int receiveBufferSizePredictor) {
        this.receiveBufferSizePredictor = receiveBufferSizePredictor;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public void setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
    }

    public int getBossCount() {
        return this.bossCount;
    }

    public void setBossCount(int bossCount) {
        this.bossCount = bossCount;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isSslClientCertHeaders() {
        return this.sslClientCertHeaders;
    }

    public void setSslClientCertHeaders(boolean sslClientCertHeaders) {
        this.sslClientCertHeaders = sslClientCertHeaders;
    }

    public SslHandler getSslHandler() {
        return this.sslHandler;
    }

    public void setSslHandler(SslHandler sslHandler) {
        this.sslHandler = sslHandler;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    @Deprecated
    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    @Deprecated
    public void setKeyStoreFile(File keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    @Deprecated
    public File getTrustStoreFile() {
        return this.trustStoreFile;
    }

    @Deprecated
    public void setTrustStoreFile(File trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getKeyStoreResource() {
        return this.keyStoreResource;
    }

    public void setKeyStoreResource(String keyStoreResource) {
        this.keyStoreResource = keyStoreResource;
    }

    public String getTrustStoreResource() {
        return this.trustStoreResource;
    }

    public void setTrustStoreResource(String trustStoreResource) {
        this.trustStoreResource = trustStoreResource;
    }

    public String getKeyStoreFormat() {
        return this.keyStoreFormat;
    }

    public void setKeyStoreFormat(String keyStoreFormat) {
        this.keyStoreFormat = keyStoreFormat;
    }

    public String getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(String securityProvider) {
        this.securityProvider = securityProvider;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    @Deprecated
    public ServerInitializerFactory getServerPipelineFactory() {
        return this.serverInitializerFactory;
    }

    @Deprecated
    public void setServerPipelineFactory(ServerInitializerFactory serverPipelineFactory) {
        this.serverInitializerFactory = serverPipelineFactory;
    }

    public ServerInitializerFactory getServerInitializerFactory() {
        return this.serverInitializerFactory;
    }

    public void setServerInitializerFactory(ServerInitializerFactory serverInitializerFactory) {
        this.serverInitializerFactory = serverInitializerFactory;
    }

    public NettyServerBootstrapFactory getNettyServerBootstrapFactory() {
        return this.nettyServerBootstrapFactory;
    }

    public void setNettyServerBootstrapFactory(NettyServerBootstrapFactory nettyServerBootstrapFactory) {
        this.nettyServerBootstrapFactory = nettyServerBootstrapFactory;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public boolean isNativeTransport() {
        return this.nativeTransport;
    }

    public void setNativeTransport(boolean nativeTransport) {
        this.nativeTransport = nativeTransport;
    }

    public EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    public void setBossGroup(EventLoopGroup bossGroup) {
        this.bossGroup = bossGroup;
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(EventLoopGroup workerGroup) {
        this.workerGroup = workerGroup;
    }

    public ChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    public void setChannelGroup(ChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
    }

    public String getNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
    }

    public String getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(int reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public boolean compatible(NettyServerBootstrapConfiguration other) {
        boolean isCompatible = true;
        if (!this.protocol.equals(other.protocol)) {
            isCompatible = false;
        } else if (!this.host.equals(other.host)) {
            isCompatible = false;
        } else if (this.port != other.port) {
            isCompatible = false;
        } else if (this.broadcast != other.broadcast) {
            isCompatible = false;
        } else {
            if (this.sendBufferSize != other.sendBufferSize) {
                return false;
            }
            if (this.receiveBufferSize != other.receiveBufferSize) {
                isCompatible = false;
            } else if (this.receiveBufferSizePredictor != other.receiveBufferSizePredictor) {
                isCompatible = false;
            } else if (this.workerCount != other.workerCount) {
                isCompatible = false;
            } else if (this.bossCount != other.bossCount) {
                isCompatible = false;
            } else if (this.keepAlive != other.keepAlive) {
                isCompatible = false;
            } else if (this.tcpNoDelay != other.tcpNoDelay) {
                isCompatible = false;
            } else if (this.reuseAddress != other.reuseAddress) {
                isCompatible = false;
            } else if (this.connectTimeout != other.connectTimeout) {
                isCompatible = false;
            } else if (this.backlog != other.backlog) {
                isCompatible = false;
            } else if (this.serverInitializerFactory != other.serverInitializerFactory) {
                isCompatible = false;
            } else if (this.nettyServerBootstrapFactory != other.nettyServerBootstrapFactory) {
                isCompatible = false;
            } else if (this.options == null && other.options != null) {
                isCompatible = false;
            } else if (this.options != null && other.options == null) {
                isCompatible = false;
            } else if (this.options != null && other.options != null && this.options.size() != other.options.size()) {
                isCompatible = false;
            } else if (this.options != null && other.options != null && !this.options.keySet().containsAll(other.options.keySet())) {
                isCompatible = false;
            } else if (this.options != null && other.options != null && !this.options.values().containsAll(other.options.values())) {
                isCompatible = false;
            } else if (this.ssl != other.ssl) {
                isCompatible = false;
            } else if (this.sslHandler != other.sslHandler) {
                isCompatible = false;
            } else if (this.sslContextParameters != other.sslContextParameters) {
                isCompatible = false;
            } else if (this.needClientAuth != other.needClientAuth) {
                isCompatible = false;
            } else if (this.keyStoreFile != other.keyStoreFile) {
                isCompatible = false;
            } else if (this.trustStoreFile != other.trustStoreFile) {
                isCompatible = false;
            } else if (this.keyStoreResource != null && !this.keyStoreResource.equals(other.keyStoreResource)) {
                isCompatible = false;
            } else if (this.trustStoreResource != null && !this.trustStoreResource.equals(other.trustStoreResource)) {
                isCompatible = false;
            } else if (this.keyStoreFormat != null && !this.keyStoreFormat.equals(other.keyStoreFormat)) {
                isCompatible = false;
            } else if (this.securityProvider != null && !this.securityProvider.equals(other.securityProvider)) {
                isCompatible = false;
            } else if (this.passphrase != null && !this.passphrase.equals(other.passphrase)) {
                isCompatible = false;
            } else if (this.bossGroup != other.bossGroup) {
                isCompatible = false;
            } else if (this.workerGroup != other.workerGroup) {
                isCompatible = false;
            } else if (this.networkInterface != null && !this.networkInterface.equals(other.networkInterface)) {
                isCompatible = false;
            } else if (this.reconnect != other.reconnect) {
                isCompatible = false;
            } else if (this.reconnectInterval != other.reconnectInterval) {
                isCompatible = false;
            }
        }
        return isCompatible;
    }

    public String toStringBootstrapConfiguration() {
        return "NettyServerBootstrapConfiguration{protocol='" + this.protocol + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", broadcast=" + this.broadcast + ", sendBufferSize=" + this.sendBufferSize + ", receiveBufferSize=" + this.receiveBufferSize + ", receiveBufferSizePredictor=" + this.receiveBufferSizePredictor + ", workerCount=" + this.workerCount + ", bossCount=" + this.bossCount + ", keepAlive=" + this.keepAlive + ", tcpNoDelay=" + this.tcpNoDelay + ", reuseAddress=" + this.reuseAddress + ", connectTimeout=" + this.connectTimeout + ", backlog=" + this.backlog + ", serverInitializerFactory=" + (Object)((Object)this.serverInitializerFactory) + ", nettyServerBootstrapFactory=" + this.nettyServerBootstrapFactory + ", options=" + this.options + ", ssl=" + this.ssl + ", sslHandler=" + this.sslHandler + ", sslContextParameters='" + this.sslContextParameters + '\'' + ", needClientAuth=" + this.needClientAuth + ", enabledProtocols='" + this.enabledProtocols + ", keyStoreFile=" + this.keyStoreFile + ", trustStoreFile=" + this.trustStoreFile + ", keyStoreResource='" + this.keyStoreResource + '\'' + ", trustStoreResource='" + this.trustStoreResource + '\'' + ", keyStoreFormat='" + this.keyStoreFormat + '\'' + ", securityProvider='" + this.securityProvider + '\'' + ", passphrase='" + this.passphrase + '\'' + ", bossGroup=" + this.bossGroup + ", workerGroup=" + this.workerGroup + ", networkInterface='" + this.networkInterface + '\'' + ", reconnect='" + this.reconnect + '\'' + ", reconnectInterval='" + this.reconnectInterval + '\'' + '}';
    }
}

