/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.web.servlet.filter;

import io.opentracing.BaseSpan;
import io.opentracing.tag.Tags;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface ServletFilterSpanDecorator {
    public static final ServletFilterSpanDecorator STANDARD_TAGS = new ServletFilterSpanDecorator(){

        @Override
        public void onRequest(HttpServletRequest httpServletRequest, BaseSpan<?> span) {
            Tags.COMPONENT.set(span, "java-web-servlet");
            Tags.HTTP_METHOD.set(span, httpServletRequest.getMethod());
            Tags.HTTP_URL.set(span, httpServletRequest.getRequestURL().toString());
        }

        @Override
        public void onResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BaseSpan<?> span) {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(httpServletResponse.getStatus()));
        }

        @Override
        public void onError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Throwable exception, BaseSpan<?> span) {
            Tags.ERROR.set(span, Boolean.TRUE);
            span.log(this.logsForException(exception));
            if (httpServletResponse.getStatus() == 200) {
                Tags.HTTP_STATUS.set(span, Integer.valueOf(500));
            }
        }

        @Override
        public void onTimeout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long timeout, BaseSpan<?> span) {
            Tags.ERROR.set(span, Boolean.TRUE);
            HashMap<String, Object> timeoutLogs = new HashMap<String, Object>();
            timeoutLogs.put("event", Tags.ERROR.getKey());
            timeoutLogs.put("message", "timeout");
            timeoutLogs.put("timeout", timeout);
        }

        private Map<String, String> logsForException(Throwable throwable) {
            String message;
            HashMap<String, String> errorLog = new HashMap<String, String>(3);
            errorLog.put("event", Tags.ERROR.getKey());
            String string = message = throwable.getCause() != null ? throwable.getCause().getMessage() : throwable.getMessage();
            if (message != null) {
                errorLog.put("message", message);
            }
            StringWriter sw = new StringWriter();
            throwable.printStackTrace(new PrintWriter(sw));
            errorLog.put("stack", sw.toString());
            return errorLog;
        }
    };

    public void onRequest(HttpServletRequest var1, BaseSpan<?> var2);

    public void onResponse(HttpServletRequest var1, HttpServletResponse var2, BaseSpan<?> var3);

    public void onError(HttpServletRequest var1, HttpServletResponse var2, Throwable var3, BaseSpan<?> var4);

    public void onTimeout(HttpServletRequest var1, HttpServletResponse var2, long var3, BaseSpan<?> var5);
}

