/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CursorType;
import com.mongodb.DBObject;
import com.mongodb.MongoCursorNotFoundException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.Exchange;
import org.apache.camel.component.mongodb.CamelMongoDbException;
import org.apache.camel.component.mongodb.MongoDbEndpoint;
import org.apache.camel.component.mongodb.MongoDbTailTrackingManager;
import org.apache.camel.component.mongodb.MongoDbTailableCursorConsumer;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbTailingProcess
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbTailingProcess.class);
    private static final String CAPPED_KEY = "capped";
    public volatile boolean keepRunning = true;
    public volatile boolean stopped;
    private volatile CountDownLatch stoppedLatch;
    private final MongoCollection<BasicDBObject> dbCol;
    private final MongoDbEndpoint endpoint;
    private final MongoDbTailableCursorConsumer consumer;
    private final long cursorRegenerationDelay;
    private final boolean cursorRegenerationDelayEnabled;
    private MongoCursor<BasicDBObject> cursor;
    private MongoDbTailTrackingManager tailTracking;

    public MongoDbTailingProcess(MongoDbEndpoint endpoint, MongoDbTailableCursorConsumer consumer, MongoDbTailTrackingManager tailTrack) {
        this.endpoint = endpoint;
        this.consumer = consumer;
        this.dbCol = endpoint.getMongoCollection();
        this.tailTracking = tailTrack;
        this.cursorRegenerationDelay = endpoint.getCursorRegenerationDelay();
        this.cursorRegenerationDelayEnabled = this.cursorRegenerationDelay != 0L;
    }

    public MongoCursor<BasicDBObject> getCursor() {
        return this.cursor;
    }

    public void initializeProcess() throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info("Starting MongoDB Tailable Cursor consumer, binding to collection: {}", (Object)("db: " + this.endpoint.getMongoDatabase() + ", col: " + this.endpoint.getCollection()));
        }
        if (!this.isCollectionCapped().booleanValue()) {
            throw new CamelMongoDbException("Tailable cursors are only compatible with capped collections, and collection " + this.endpoint.getCollection() + " is not capped");
        }
        try {
            this.tailTracking.recoverFromStore();
            this.cursor = this.initializeCursor();
        }
        catch (Exception e) {
            throw new CamelMongoDbException("Exception occurred while initializing tailable cursor", e);
        }
        if (this.cursor == null) {
            throw new CamelMongoDbException("Tailable cursor was not initialized, or cursor returned is dead on arrival");
        }
    }

    private Boolean isCollectionCapped() {
        return this.endpoint.getMongoDatabase().runCommand((Bson)this.createCollStatsCommand()).getBoolean((Object)CAPPED_KEY);
    }

    private BasicDBObject createCollStatsCommand() {
        return new BasicDBObject("collStats", (Object)this.endpoint.getCollection());
    }

    @Override
    public void run() {
        this.stoppedLatch = new CountDownLatch(1);
        while (this.keepRunning) {
            this.doRun();
            if (!this.keepRunning) continue;
            this.cursor.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Regenerating cursor with lastVal: {}, waiting {}ms first", this.tailTracking.lastVal, (Object)this.cursorRegenerationDelay);
            }
            if (this.cursorRegenerationDelayEnabled) {
                try {
                    Thread.sleep(this.cursorRegenerationDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.cursor = this.initializeCursor();
        }
        this.stopped = true;
        this.stoppedLatch.countDown();
    }

    protected void stop() throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info("Stopping MongoDB Tailable Cursor consumer, bound to collection: {}", (Object)("db: " + this.endpoint.getDatabase() + ", col: " + this.endpoint.getCollection()));
        }
        this.keepRunning = false;
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.awaitStopped();
        if (LOG.isInfoEnabled()) {
            LOG.info("Stopped MongoDB Tailable Cursor consumer, bound to collection: {}", (Object)("db: " + this.endpoint.getDatabase() + ", col: " + this.endpoint.getCollection()));
        }
    }

    private void doRun() {
        block6: {
            int counter = 0;
            int persistRecords = this.endpoint.getPersistRecords();
            boolean persistRegularly = persistRecords > 0;
            try {
                while (this.cursor.hasNext() && this.keepRunning) {
                    DBObject dbObj = (DBObject)this.cursor.next();
                    Exchange exchange = this.endpoint.createMongoDbExchange(dbObj);
                    try {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Sending exchange: {}, ObjectId: {}", (Object)exchange, dbObj.get("_id"));
                        }
                        this.consumer.getProcessor().process(exchange);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.tailTracking.setLastVal(dbObj);
                    if (!persistRegularly || counter++ % persistRecords != 0) continue;
                    this.tailTracking.persistToStore();
                }
            }
            catch (MongoCursorNotFoundException e) {
                if (!this.keepRunning) break block6;
                LOG.debug("Cursor not found exception from MongoDB, will regenerate cursor. This is normal behaviour with tailable cursors.", (Throwable)e);
            }
        }
        this.tailTracking.persistToStore();
    }

    private MongoCursor<BasicDBObject> initializeCursor() {
        MongoCursor answer;
        Object lastVal = this.tailTracking.lastVal;
        if (lastVal == null) {
            answer = this.dbCol.find().cursorType(CursorType.TailableAwait).iterator();
        } else {
            String increasingFieldName = this.tailTracking.getIncreasingFieldName();
            BasicDBObject queryObj = this.endpoint.getTailTrackingStrategy().createQuery(lastVal, increasingFieldName);
            answer = this.dbCol.find((Bson)queryObj).cursorType(CursorType.TailableAwait).iterator();
        }
        return answer;
    }

    private void awaitStopped() throws InterruptedException {
        if (!this.stopped) {
            LOG.info("Going to wait for stopping");
            this.stoppedLatch.await();
        }
    }
}

