/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.messaging.activemq.JMSBridge;
import org.wildfly.swarm.config.messaging.activemq.JMSBridgeConsumer;
import org.wildfly.swarm.config.messaging.activemq.JMSBridgeSupplier;
import org.wildfly.swarm.config.messaging.activemq.Server;
import org.wildfly.swarm.config.messaging.activemq.ServerConsumer;
import org.wildfly.swarm.config.messaging.activemq.ServerSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=messaging-activemq")
@ResourceType(value="subsystem")
@Implicit
public class MessagingActiveMQ<T extends MessagingActiveMQ<T>>
extends HashMap
implements Keyed {
    private String key = "messaging-activemq";
    private PropertyChangeSupport pcs;
    private MessagingActiveMQResources subresources = new MessagingActiveMQResources();

    public MessagingActiveMQ() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public MessagingActiveMQResources subresources() {
        return this.subresources;
    }

    public T servers(List<Server> value) {
        this.subresources.servers = value;
        return (T)this;
    }

    public T server(Server value) {
        this.subresources.servers.add(value);
        return (T)this;
    }

    public T server(String childKey, ServerConsumer consumer) {
        Server child = new Server(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.server(child);
        return (T)this;
    }

    public T server(String childKey) {
        this.server(childKey, null);
        return (T)this;
    }

    public T server(ServerSupplier supplier) {
        this.server(supplier.get());
        return (T)this;
    }

    public T jmsBridges(List<JMSBridge> value) {
        this.subresources.jmsBridges = value;
        return (T)this;
    }

    public T jmsBridge(JMSBridge value) {
        this.subresources.jmsBridges.add(value);
        return (T)this;
    }

    public T jmsBridge(String childKey, JMSBridgeConsumer consumer) {
        JMSBridge child = new JMSBridge(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.jmsBridge(child);
        return (T)this;
    }

    public T jmsBridge(String childKey) {
        this.jmsBridge(childKey, null);
        return (T)this;
    }

    public T jmsBridge(JMSBridgeSupplier supplier) {
        this.jmsBridge(supplier.get());
        return (T)this;
    }

    public static class MessagingActiveMQResources {
        @ResourceDocumentation(value="An ActiveMQ server instance.")
        @SubresourceInfo(value="server")
        private List<Server> servers = new ArrayList<Server>();
        @ResourceDocumentation(value="A JMS bridge instance.")
        @SubresourceInfo(value="jmsBridge")
        private List<JMSBridge> jmsBridges = new ArrayList<JMSBridge>();

        @Subresource
        public List<Server> servers() {
            return this.servers;
        }

        public Server server(String key) {
            return this.servers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<JMSBridge> jmsBridges() {
            return this.jmsBridges;
        }

        public JMSBridge jmsBridge(String key) {
            return this.jmsBridges.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

