/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.management.access.ApplicationClassificationConstraint;
import org.wildfly.swarm.config.management.access.ApplicationClassificationConstraintConsumer;
import org.wildfly.swarm.config.management.access.ApplicationClassificationConstraintSupplier;
import org.wildfly.swarm.config.management.access.RoleMapping;
import org.wildfly.swarm.config.management.access.RoleMappingConsumer;
import org.wildfly.swarm.config.management.access.RoleMappingSupplier;
import org.wildfly.swarm.config.management.access.SensitivityClassificationConstraint;
import org.wildfly.swarm.config.management.access.SensitivityClassificationConstraintConsumer;
import org.wildfly.swarm.config.management.access.SensitivityClassificationConstraintSupplier;
import org.wildfly.swarm.config.management.access.VaultExpressionConstraint;
import org.wildfly.swarm.config.management.access.VaultExpressionConstraintConsumer;
import org.wildfly.swarm.config.management.access.VaultExpressionConstraintSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/core-service=management/access=authorization")
@ResourceType(value="access")
@Implicit
public class AuthorizationAccess<T extends AuthorizationAccess<T>>
extends HashMap
implements Keyed {
    private String key = "authorization";
    private PropertyChangeSupport pcs;
    private AuthorizationAccessResources subresources = new AuthorizationAccessResources();
    @AttributeDocumentation(value="The official names of all roles supported by the current management access control provider. This includes any standard roles as well as any user-defined roles.")
    private List<String> allRoleNames;
    @AttributeDocumentation(value="The policy for combining access control permissions when the authorization policy grants the user more than one type of permission for a given action. In the standard role based authorization policy, this would occur when a user maps to multiple roles. The 'permissive' policy means if any of the permissions allow the action, the action is allowed. The 'rejecting' policy means the existence of multiple permissions should result in an error.")
    private PermissionCombinationPolicy permissionCombinationPolicy;
    @AttributeDocumentation(value="The provider to use for management access control decisions.")
    private Provider provider;
    @AttributeDocumentation(value="The official names of the standard roles supported by the current management access control provider.")
    private List<String> standardRoleNames;

    public AuthorizationAccess() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public AuthorizationAccessResources subresources() {
        return this.subresources;
    }

    public T roleMappings(List<RoleMapping> value) {
        this.subresources.roleMappings = value;
        return (T)this;
    }

    public T roleMapping(RoleMapping value) {
        this.subresources.roleMappings.add(value);
        return (T)this;
    }

    public T roleMapping(String childKey, RoleMappingConsumer consumer) {
        RoleMapping child = new RoleMapping(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.roleMapping(child);
        return (T)this;
    }

    public T roleMapping(String childKey) {
        this.roleMapping(childKey, null);
        return (T)this;
    }

    public T roleMapping(RoleMappingSupplier supplier) {
        this.roleMapping(supplier.get());
        return (T)this;
    }

    public T vaultExpressionConstraint(VaultExpressionConstraint value) {
        this.subresources.vaultExpressionConstraint = value;
        return (T)this;
    }

    public T vaultExpressionConstraint(VaultExpressionConstraintConsumer consumer) {
        VaultExpressionConstraint child = new VaultExpressionConstraint();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.vaultExpressionConstraint = child;
        return (T)this;
    }

    public T vaultExpressionConstraint() {
        VaultExpressionConstraint child = new VaultExpressionConstraint();
        this.subresources.vaultExpressionConstraint = child;
        return (T)this;
    }

    public T vaultExpressionConstraint(VaultExpressionConstraintSupplier supplier) {
        this.subresources.vaultExpressionConstraint = supplier.get();
        return (T)this;
    }

    public T applicationClassificationConstraint(ApplicationClassificationConstraint value) {
        this.subresources.applicationClassificationConstraint = value;
        return (T)this;
    }

    public T applicationClassificationConstraint(ApplicationClassificationConstraintConsumer consumer) {
        ApplicationClassificationConstraint child = new ApplicationClassificationConstraint();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.applicationClassificationConstraint = child;
        return (T)this;
    }

    public T applicationClassificationConstraint() {
        ApplicationClassificationConstraint child = new ApplicationClassificationConstraint();
        this.subresources.applicationClassificationConstraint = child;
        return (T)this;
    }

    public T applicationClassificationConstraint(ApplicationClassificationConstraintSupplier supplier) {
        this.subresources.applicationClassificationConstraint = supplier.get();
        return (T)this;
    }

    public T sensitivityClassificationConstraint(SensitivityClassificationConstraint value) {
        this.subresources.sensitivityClassificationConstraint = value;
        return (T)this;
    }

    public T sensitivityClassificationConstraint(SensitivityClassificationConstraintConsumer consumer) {
        SensitivityClassificationConstraint child = new SensitivityClassificationConstraint();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.sensitivityClassificationConstraint = child;
        return (T)this;
    }

    public T sensitivityClassificationConstraint() {
        SensitivityClassificationConstraint child = new SensitivityClassificationConstraint();
        this.subresources.sensitivityClassificationConstraint = child;
        return (T)this;
    }

    public T sensitivityClassificationConstraint(SensitivityClassificationConstraintSupplier supplier) {
        this.subresources.sensitivityClassificationConstraint = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="all-role-names")
    public List<String> allRoleNames() {
        return this.allRoleNames;
    }

    public T allRoleNames(List<String> value) {
        List<String> oldValue = this.allRoleNames;
        this.allRoleNames = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allRoleNames", oldValue, value);
        }
        return (T)this;
    }

    public T allRoleName(String value) {
        if (this.allRoleNames == null) {
            this.allRoleNames = new ArrayList<String>();
        }
        this.allRoleNames.add(value);
        return (T)this;
    }

    public T allRoleNames(String ... args) {
        this.allRoleNames(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="permission-combination-policy")
    public PermissionCombinationPolicy permissionCombinationPolicy() {
        return this.permissionCombinationPolicy;
    }

    public T permissionCombinationPolicy(PermissionCombinationPolicy value) {
        PermissionCombinationPolicy oldValue = this.permissionCombinationPolicy;
        this.permissionCombinationPolicy = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("permissionCombinationPolicy", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="provider")
    public Provider provider() {
        return this.provider;
    }

    public T provider(Provider value) {
        Provider oldValue = this.provider;
        this.provider = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("provider", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="standard-role-names")
    public List<String> standardRoleNames() {
        return this.standardRoleNames;
    }

    public T standardRoleNames(List<String> value) {
        List<String> oldValue = this.standardRoleNames;
        this.standardRoleNames = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("standardRoleNames", oldValue, value);
        }
        return (T)this;
    }

    public T standardRoleName(String value) {
        if (this.standardRoleNames == null) {
            this.standardRoleNames = new ArrayList<String>();
        }
        this.standardRoleNames.add(value);
        return (T)this;
    }

    public T standardRoleNames(String ... args) {
        this.standardRoleNames(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    public static enum Provider {
        SIMPLE("simple"),
        RBAC("rbac");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Provider(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum PermissionCombinationPolicy {
        PERMISSIVE("permissive"),
        REJECTING("rejecting");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private PermissionCombinationPolicy(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class AuthorizationAccessResources {
        @ResourceDocumentation(value="A mapping of users and groups to a specific role.")
        @SubresourceInfo(value="roleMapping")
        private List<RoleMapping> roleMappings = new ArrayList<RoleMapping>();
        @SingletonResource
        @ResourceDocumentation(value="Configuration of whether vault expressions should be considered sensitive.")
        private VaultExpressionConstraint vaultExpressionConstraint;
        @SingletonResource
        @ResourceDocumentation(value="Configuration of the application classification constraints.")
        private ApplicationClassificationConstraint applicationClassificationConstraint;
        @SingletonResource
        @ResourceDocumentation(value="The sensitivity classification constraints.")
        private SensitivityClassificationConstraint sensitivityClassificationConstraint;

        @Subresource
        public List<RoleMapping> roleMappings() {
            return this.roleMappings;
        }

        public RoleMapping roleMapping(String key) {
            return this.roleMappings.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public VaultExpressionConstraint vaultExpressionConstraint() {
            return this.vaultExpressionConstraint;
        }

        @Subresource
        public ApplicationClassificationConstraint applicationClassificationConstraint() {
            return this.applicationClassificationConstraint;
        }

        @Subresource
        public SensitivityClassificationConstraint sensitivityClassificationConstraint() {
            return this.sensitivityClassificationConstraint;
        }
    }
}

