/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/server=*/ha-policy=live-only")
@ResourceType(value="ha-policy")
@Implicit
public class LiveOnlyHAPolicy<T extends LiveOnlyHAPolicy<T>>
extends HashMap
implements Keyed {
    private String key = "live-only";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="Configure whether this server send its messages to another live server in the scale-down cluster when it is shutdown cleanly.")
    private Boolean scaleDown;
    @AttributeDocumentation(value="Name of the cluster used to scale down.")
    private String scaleDownClusterName;
    @AttributeDocumentation(value="List of connectors used to form the scale-down cluster.")
    private List<String> scaleDownConnectors;
    @AttributeDocumentation(value="Name of the discovery group used to build the scale-down cluster")
    private String scaleDownDiscoveryGroup;
    @AttributeDocumentation(value="Name of the group used to scale down.")
    private String scaleDownGroupName;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="scale-down")
    public Boolean scaleDown() {
        return this.scaleDown;
    }

    public T scaleDown(Boolean value) {
        Boolean oldValue = this.scaleDown;
        this.scaleDown = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scaleDown", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scale-down-cluster-name")
    public String scaleDownClusterName() {
        return this.scaleDownClusterName;
    }

    public T scaleDownClusterName(String value) {
        String oldValue = this.scaleDownClusterName;
        this.scaleDownClusterName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scaleDownClusterName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scale-down-connectors")
    public List<String> scaleDownConnectors() {
        return this.scaleDownConnectors;
    }

    public T scaleDownConnectors(List<String> value) {
        List<String> oldValue = this.scaleDownConnectors;
        this.scaleDownConnectors = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scaleDownConnectors", oldValue, value);
        }
        return (T)this;
    }

    public T scaleDownConnector(String value) {
        if (this.scaleDownConnectors == null) {
            this.scaleDownConnectors = new ArrayList<String>();
        }
        this.scaleDownConnectors.add(value);
        return (T)this;
    }

    public T scaleDownConnectors(String ... args) {
        this.scaleDownConnectors(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scale-down-discovery-group")
    public String scaleDownDiscoveryGroup() {
        return this.scaleDownDiscoveryGroup;
    }

    public T scaleDownDiscoveryGroup(String value) {
        String oldValue = this.scaleDownDiscoveryGroup;
        this.scaleDownDiscoveryGroup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scaleDownDiscoveryGroup", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scale-down-group-name")
    public String scaleDownGroupName() {
        return this.scaleDownGroupName;
    }

    public T scaleDownGroupName(String value) {
        String oldValue = this.scaleDownGroupName;
        this.scaleDownGroupName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scaleDownGroupName", oldValue, value);
        }
        return (T)this;
    }
}

