package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import java.util.HashMap;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * Configuration of the SSL identity of a server or host controller.
 */
@Address("/core-service=management/security-realm=*/server-identity=ssl")
@ResourceType("server-identity")
@Implicit
public class SslServerIdentity<T extends SslServerIdentity<T>> extends HashMap
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The alias of the entry to use from the keystore.")
	private String alias;
	@AttributeDocumentation("The cipher suites that can be enabled on the underlying SSLEngine.")
	private List<String> enabledCipherSuites;
	@AttributeDocumentation("The protocols that can be enabled on the underlying SSLEngine.")
	private List<String> enabledProtocols;
	@AttributeDocumentation("If the keystore does not exist and this attribute is set then a self signed certificate will be generated for the specified host name. This is not intended for production use.")
	private String generateSelfSignedCertificateHost;
	@AttributeDocumentation("The password to obtain the key from the keystore.")
	private String keyPassword;
	@AttributeDocumentation("The password to open the keystore.")
	private String keystorePassword;
	@AttributeDocumentation("The path of the keystore, will be ignored if the keystore-provider is anything other than JKS.")
	private String keystorePath;
	@AttributeDocumentation("The provider for loading the keystore, defaults to JKS.")
	private String keystoreProvider;
	@AttributeDocumentation("The name of another previously named path, or of one of the standard paths provided by the system. If 'relative-to' is provided, the value of the 'path' attribute is treated as relative to the path specified by this attribute.")
	private String keystoreRelativeTo;
	@AttributeDocumentation("The protocol to use when creating the SSLContext.")
	private String protocol;

	public SslServerIdentity() {
		super();
		this.key = "ssl";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The alias of the entry to use from the keystore.
	 */
	@ModelNodeBinding(detypedName = "alias")
	public String alias() {
		return this.alias;
	}

	/**
	 * The alias of the entry to use from the keystore.
	 */
	@SuppressWarnings("unchecked")
	public T alias(java.lang.String value) {
		Object oldValue = this.alias;
		this.alias = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("alias", oldValue, value);
		return (T) this;
	}

	/**
	 * The cipher suites that can be enabled on the underlying SSLEngine.
	 */
	@ModelNodeBinding(detypedName = "enabled-cipher-suites")
	public List<String> enabledCipherSuites() {
		return this.enabledCipherSuites;
	}

	/**
	 * The cipher suites that can be enabled on the underlying SSLEngine.
	 */
	@SuppressWarnings("unchecked")
	public T enabledCipherSuites(java.util.List<String> value) {
		Object oldValue = this.enabledCipherSuites;
		this.enabledCipherSuites = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enabledCipherSuites", oldValue, value);
		return (T) this;
	}

	/**
	 * The cipher suites that can be enabled on the underlying SSLEngine.
	 */
	@SuppressWarnings("unchecked")
	public T enabledCipherSuite(String value) {
		if (this.enabledCipherSuites == null) {
			this.enabledCipherSuites = new java.util.ArrayList<>();
		}
		this.enabledCipherSuites.add(value);
		return (T) this;
	}

	/**
	 * The cipher suites that can be enabled on the underlying SSLEngine.
	 */
	@SuppressWarnings("unchecked")
	public T enabledCipherSuites(String... args) {
		enabledCipherSuites(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The protocols that can be enabled on the underlying SSLEngine.
	 */
	@ModelNodeBinding(detypedName = "enabled-protocols")
	public List<String> enabledProtocols() {
		return this.enabledProtocols;
	}

	/**
	 * The protocols that can be enabled on the underlying SSLEngine.
	 */
	@SuppressWarnings("unchecked")
	public T enabledProtocols(java.util.List<String> value) {
		Object oldValue = this.enabledProtocols;
		this.enabledProtocols = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enabledProtocols", oldValue, value);
		return (T) this;
	}

	/**
	 * The protocols that can be enabled on the underlying SSLEngine.
	 */
	@SuppressWarnings("unchecked")
	public T enabledProtocol(String value) {
		if (this.enabledProtocols == null) {
			this.enabledProtocols = new java.util.ArrayList<>();
		}
		this.enabledProtocols.add(value);
		return (T) this;
	}

	/**
	 * The protocols that can be enabled on the underlying SSLEngine.
	 */
	@SuppressWarnings("unchecked")
	public T enabledProtocols(String... args) {
		enabledProtocols(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * If the keystore does not exist and this attribute is set then a self
	 * signed certificate will be generated for the specified host name. This is
	 * not intended for production use.
	 */
	@ModelNodeBinding(detypedName = "generate-self-signed-certificate-host")
	public String generateSelfSignedCertificateHost() {
		return this.generateSelfSignedCertificateHost;
	}

	/**
	 * If the keystore does not exist and this attribute is set then a self
	 * signed certificate will be generated for the specified host name. This is
	 * not intended for production use.
	 */
	@SuppressWarnings("unchecked")
	public T generateSelfSignedCertificateHost(java.lang.String value) {
		Object oldValue = this.generateSelfSignedCertificateHost;
		this.generateSelfSignedCertificateHost = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("generateSelfSignedCertificateHost",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The password to obtain the key from the keystore.
	 */
	@ModelNodeBinding(detypedName = "key-password")
	public String keyPassword() {
		return this.keyPassword;
	}

	/**
	 * The password to obtain the key from the keystore.
	 */
	@SuppressWarnings("unchecked")
	public T keyPassword(java.lang.String value) {
		Object oldValue = this.keyPassword;
		this.keyPassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyPassword", oldValue, value);
		return (T) this;
	}

	/**
	 * The password to open the keystore.
	 */
	@ModelNodeBinding(detypedName = "keystore-password")
	public String keystorePassword() {
		return this.keystorePassword;
	}

	/**
	 * The password to open the keystore.
	 */
	@SuppressWarnings("unchecked")
	public T keystorePassword(java.lang.String value) {
		Object oldValue = this.keystorePassword;
		this.keystorePassword = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystorePassword", oldValue, value);
		return (T) this;
	}

	/**
	 * The path of the keystore, will be ignored if the keystore-provider is
	 * anything other than JKS.
	 */
	@ModelNodeBinding(detypedName = "keystore-path")
	public String keystorePath() {
		return this.keystorePath;
	}

	/**
	 * The path of the keystore, will be ignored if the keystore-provider is
	 * anything other than JKS.
	 */
	@SuppressWarnings("unchecked")
	public T keystorePath(java.lang.String value) {
		Object oldValue = this.keystorePath;
		this.keystorePath = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystorePath", oldValue, value);
		return (T) this;
	}

	/**
	 * The provider for loading the keystore, defaults to JKS.
	 */
	@ModelNodeBinding(detypedName = "keystore-provider")
	public String keystoreProvider() {
		return this.keystoreProvider;
	}

	/**
	 * The provider for loading the keystore, defaults to JKS.
	 */
	@SuppressWarnings("unchecked")
	public T keystoreProvider(java.lang.String value) {
		Object oldValue = this.keystoreProvider;
		this.keystoreProvider = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystoreProvider", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of another previously named path, or of one of the standard
	 * paths provided by the system. If 'relative-to' is provided, the value of
	 * the 'path' attribute is treated as relative to the path specified by this
	 * attribute.
	 */
	@ModelNodeBinding(detypedName = "keystore-relative-to")
	public String keystoreRelativeTo() {
		return this.keystoreRelativeTo;
	}

	/**
	 * The name of another previously named path, or of one of the standard
	 * paths provided by the system. If 'relative-to' is provided, the value of
	 * the 'path' attribute is treated as relative to the path specified by this
	 * attribute.
	 */
	@SuppressWarnings("unchecked")
	public T keystoreRelativeTo(java.lang.String value) {
		Object oldValue = this.keystoreRelativeTo;
		this.keystoreRelativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keystoreRelativeTo", oldValue, value);
		return (T) this;
	}

	/**
	 * The protocol to use when creating the SSLContext.
	 */
	@ModelNodeBinding(detypedName = "protocol")
	public String protocol() {
		return this.protocol;
	}

	/**
	 * The protocol to use when creating the SSLContext.
	 */
	@SuppressWarnings("unchecked")
	public T protocol(java.lang.String value) {
		Object oldValue = this.protocol;
		this.protocol = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("protocol", oldValue, value);
		return (T) this;
	}
}