package org.jboss.as.controller.client.logging;

import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.as.controller.client.helpers.domain.RollbackCancelledException;
import java.net.URL;
import org.jboss.as.controller.client.logging.ControllerClientLogger.LeakDescription;
import org.jboss.as.controller.client.helpers.domain.DeploymentAction.Type;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-03-21T16:36:23-0500")
public class ControllerClientLogger_$logger extends DelegatingBasicLogger implements ControllerClientLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ControllerClientLogger_$logger.class.getName();
    public ControllerClientLogger_$logger(final Logger log) {
        super(log);
    }
    private static final String cannotAddDeploymentAction = "WFLYCC0001: Cannot add deployment actions after starting creation of a rollout plan";
    protected String cannotAddDeploymentAction$str() {
        return cannotAddDeploymentAction;
    }
    @Override
    public final IllegalStateException cannotAddDeploymentAction() {
        final IllegalStateException result = new IllegalStateException(String.format(cannotAddDeploymentAction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddDeploymentActionsAfterStart = "WFLYCC0002: Cannot add deployment actions after starting creation of a rollout plan";
    protected String cannotAddDeploymentActionsAfterStart$str() {
        return cannotAddDeploymentActionsAfterStart;
    }
    @Override
    public final IllegalStateException cannotAddDeploymentActionsAfterStart() {
        final IllegalStateException result = new IllegalStateException(String.format(cannotAddDeploymentActionsAfterStart$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConvert = "WFLYCC0003: Cannot convert %s to %s";
    protected String cannotConvert$str() {
        return cannotConvert;
    }
    @Override
    public final String cannotConvert(final String first, final String second) {
        return String.format(cannotConvert$str(), first, second);
    }
    private static final String cannotDeriveDeploymentName = "WFLYCC0004: Cannot derive a deployment name from %s -- use an overloaded method variant that takes a 'name' parameter";
    protected String cannotDeriveDeploymentName$str() {
        return cannotDeriveDeploymentName;
    }
    @Override
    public final IllegalArgumentException cannotDeriveDeploymentName(final URL url) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotDeriveDeploymentName$str(), url));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotUseDeploymentPlan = "WFLYCC0005: Cannot use a DeploymentPlan not created by this manager";
    protected String cannotUseDeploymentPlan$str() {
        return cannotUseDeploymentPlan;
    }
    @Override
    public final IllegalArgumentException cannotUseDeploymentPlan() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(cannotUseDeploymentPlan$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String channelClosed = "WFLYCC0006: Channel closed";
    protected String channelClosed$str() {
        return channelClosed;
    }
    @Override
    public final IOException channelClosed(final IOException cause) {
        final IOException result = new IOException(String.format(channelClosed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String domainDeploymentAlreadyExists = "WFLYCC0007: Deployment with name %s already present in the domain";
    protected String domainDeploymentAlreadyExists$str() {
        return domainDeploymentAlreadyExists;
    }
    @Override
    public final String domainDeploymentAlreadyExists(final String name) {
        return String.format(domainDeploymentAlreadyExists$str(), name);
    }
    private static final String failed = "WFLYCC0008: failed";
    protected String failed$str() {
        return failed;
    }
    @Override
    public final String failed() {
        return String.format(failed$str());
    }
    private static final String globalRollbackNotCompatible = "WFLYCC0009: Global rollback is not compatible with a server restart";
    protected String globalRollbackNotCompatible$str() {
        return globalRollbackNotCompatible;
    }
    @Override
    public final IllegalStateException globalRollbackNotCompatible() {
        final IllegalStateException result = new IllegalStateException(String.format(globalRollbackNotCompatible$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String gracefulShutdownAlreadyConfigured = "WFLYCC0010: Graceful shutdown already configured with a timeout of %d ms";
    protected String gracefulShutdownAlreadyConfigured$str() {
        return gracefulShutdownAlreadyConfigured;
    }
    @Override
    public final IllegalStateException gracefulShutdownAlreadyConfigured(final long timeout) {
        final IllegalStateException result = new IllegalStateException(String.format(gracefulShutdownAlreadyConfigured$str(), timeout));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompleteDeploymentReplace = "WFLYCC0011: Only one version of deployment with a given unique name can exist in the domain. The deployment plan specified that a new version of deployment %s replace an existing deployment with the same unique name, but did not apply the replacement to all server groups. Missing server groups were: %s";
    protected String incompleteDeploymentReplace$str() {
        return incompleteDeploymentReplace;
    }
    @Override
    public final String incompleteDeploymentReplace(final String deploymentName, final String missingGroups) {
        return String.format(incompleteDeploymentReplace$str(), deploymentName, missingGroups);
    }
    private static final String invalidActionType = "WFLYCC0012: Invalid action type %s";
    protected String invalidActionType$str() {
        return invalidActionType;
    }
    @Override
    public final IllegalStateException invalidActionType(final Type type) {
        final IllegalStateException result = new IllegalStateException(String.format(invalidActionType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPrecedingAction = "WFLYCC0013: Preceding action was not a %s";
    protected String invalidPrecedingAction$str() {
        return invalidPrecedingAction;
    }
    @Override
    public final IllegalStateException invalidPrecedingAction(final Object type) {
        final IllegalStateException result = new IllegalStateException(String.format(invalidPrecedingAction$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidUri = "WFLYCC0014: %s is not a valid URI";
    protected String invalidUri$str() {
        return invalidUri;
    }
    @Override
    public final IllegalArgumentException invalidUri(final Throwable cause, final URL url) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidUri$str(), url), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidValue3 = "WFLYCC0015: Illegal %s value %d -- must be greater than %d";
    protected String invalidValue3$str() {
        return invalidValue3;
    }
    @Override
    public final IllegalArgumentException invalidValue(final String name, final int value, final int minValue) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidValue3$str(), name, value, minValue));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidValue4 = "WFLYCC0016: Illegal %s value %d -- must be greater than %d and less than %d";
    protected String invalidValue4$str() {
        return invalidValue4;
    }
    @Override
    public final IllegalArgumentException invalidValue(final String name, final int value, final int minValue, final int maxValue) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidValue4$str(), name, value, minValue, maxValue));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String maxDisplayUnitLength = "WFLYCC0017: Screen real estate is expensive; displayUnits must be 5 characters or less";
    protected String maxDisplayUnitLength$str() {
        return maxDisplayUnitLength;
    }
    @Override
    public final RuntimeException maxDisplayUnitLength() {
        final RuntimeException result = new RuntimeException(String.format(maxDisplayUnitLength$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noActiveRequest = "WFLYCC0018: No active request found for %d";
    protected String noActiveRequest$str() {
        return noActiveRequest;
    }
    @Override
    public final IOException noActiveRequest(final int batchId) {
        final IOException result = new IOException(String.format(noActiveRequest$str(), batchId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noFailureDetails = "WFLYCC0019: No failure details provided";
    protected String noFailureDetails$str() {
        return noFailureDetails;
    }
    @Override
    public final String noFailureDetails() {
        return String.format(noFailureDetails$str());
    }
    private static final String notConfigured = "WFLYCC0020: No %s is configured";
    protected String notConfigured$str() {
        return notConfigured;
    }
    @Override
    public final IllegalStateException notConfigured(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(notConfigured$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullVar = "WFLYCC0021: %s is null";
    protected String nullVar$str() {
        return nullVar;
    }
    @Override
    public final IllegalArgumentException nullVar(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(nullVar$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String objectIsClosed = "WFLYCC0022: %s is closed";
    protected String objectIsClosed$str() {
        return objectIsClosed;
    }
    @Override
    public final IllegalStateException objectIsClosed(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(objectIsClosed$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationOutcome = "WFLYCC0023: Operation outcome is %s";
    protected String operationOutcome$str() {
        return operationOutcome;
    }
    @Override
    public final RuntimeException operationOutcome(final String outcome) {
        final RuntimeException result = new RuntimeException(String.format(operationOutcome$str(), outcome));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationsNotAllowed = "WFLYCC0024: %s operations are not allowed after content and deployment modifications";
    protected String operationsNotAllowed$str() {
        return operationsNotAllowed;
    }
    @Override
    public final IllegalStateException operationsNotAllowed(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(operationsNotAllowed$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackCancelled = "WFLYCC0025: Rollback was cancelled";
    protected String rollbackCancelled$str() {
        return rollbackCancelled;
    }
    @Override
    public final RollbackCancelledException rollbackCancelled() {
        final RollbackCancelledException result = new RollbackCancelledException(String.format(rollbackCancelled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackRolledBack = "WFLYCC0026: Rollback was itself rolled back";
    protected String rollbackRolledBack$str() {
        return rollbackRolledBack;
    }
    @Override
    public final RollbackCancelledException rollbackRolledBack() {
        final RollbackCancelledException result = new RollbackCancelledException(String.format(rollbackRolledBack$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackTimedOut = "WFLYCC0027: Rollback timed out";
    protected String rollbackTimedOut$str() {
        return rollbackTimedOut;
    }
    @Override
    public final RollbackCancelledException rollbackTimedOut() {
        final RollbackCancelledException result = new RollbackCancelledException(String.format(rollbackTimedOut$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverDeploymentAlreadyExists = "WFLYCC0028: Deployment with name %s already present in the server";
    protected String serverDeploymentAlreadyExists$str() {
        return serverDeploymentAlreadyExists;
    }
    @Override
    public final String serverDeploymentAlreadyExists(final String name) {
        return String.format(serverDeploymentAlreadyExists$str(), name);
    }
    private static final String unknownActionType = "WFLYCC0029: Unknown action type %s";
    protected String unknownActionType$str() {
        return unknownActionType;
    }
    @Override
    public final IllegalStateException unknownActionType(final Object type) {
        final IllegalStateException result = new IllegalStateException(String.format(unknownActionType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String controllerClientNotClosed = "WFLYCC0030: Allocation stack trace:";
    protected String controllerClientNotClosed$str() {
        return controllerClientNotClosed;
    }
    @Override
    public final LeakDescription controllerClientNotClosed() {
        final LeakDescription result = new LeakDescription(String.format(controllerClientNotClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noFailureDescription = "WFLYCC0031: No failure description as the operation was successful.";
    protected String noFailureDescription$str() {
        return noFailureDescription;
    }
    @Override
    public final IllegalArgumentException noFailureDescription() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noFailureDescription$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationNameNotFound = "WFLYCC0032: The operation name was not defined.";
    protected String operationNameNotFound$str() {
        return operationNameNotFound;
    }
    @Override
    public final IllegalArgumentException operationNameNotFound() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(operationNameNotFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAddressType = "WFLYCC0033: The address must be of type ModelType.LIST.";
    protected String invalidAddressType$str() {
        return invalidAddressType;
    }
    @Override
    public final IllegalArgumentException invalidAddressType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidAddressType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void leakedControllerClient(final Throwable allocationStackTrace) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, allocationStackTrace, leakedControllerClient$str());
    }
    private static final String leakedControllerClient = "WFLYCC0034: Closing leaked controller client";
    protected String leakedControllerClient$str() {
        return leakedControllerClient;
    }
    @Override
    public final void cannotDeleteTempFile(final String name) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, cannotDeleteTempFile$str(), name);
    }
    private static final String cannotDeleteTempFile = "WFLYCC0035: Cannot delete temp file %s, will be deleted on exit";
    protected String cannotDeleteTempFile$str() {
        return cannotDeleteTempFile;
    }
    private static final String streamWasClosed = "WFLYCC0036: Stream was closed";
    protected String streamWasClosed$str() {
        return streamWasClosed;
    }
    @Override
    public final IOException streamWasClosed() {
        final IOException result = new IOException(String.format(streamWasClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
