package org.jboss.as.domain.management.logging;

import java.lang.IllegalStateException;
import java.io.Serializable;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import org.jboss.as.controller.PathElement;
import java.time.ZonedDateTime;
import org.jboss.logging.BasicLogger;
import javax.naming.NamingException;
import org.jboss.msc.service.StartException;
import javax.security.auth.callback.UnsupportedCallbackException;
import java.lang.IllegalArgumentException;
import javax.annotation.Generated;
import java.security.GeneralSecurityException;
import org.jboss.as.controller.OperationFailedException;
import java.io.IOException;
import java.lang.Exception;
import javax.security.auth.callback.Callback;
import org.jboss.as.domain.management.security.password.PasswordValidationException;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.PathAddress;
import java.lang.Throwable;
import javax.security.auth.login.LoginException;
import java.util.Collection;
import java.util.Arrays;
import javax.xml.stream.Location;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-03-21T14:55:25-0500")
public class DomainManagementLogger_$logger extends DelegatingBasicLogger implements DomainManagementLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = DomainManagementLogger_$logger.class.getName();
    public DomainManagementLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void userAndPasswordWarning() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, userAndPasswordWarning$str());
    }
    private static final String userAndPasswordWarning = "WFLYDM0001: Properties file defined with default user and password, this will be easy to guess.";
    protected String userAndPasswordWarning$str() {
        return userAndPasswordWarning;
    }
    @Override
    public final void whitespaceTrimmed() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, whitespaceTrimmed$str());
    }
    private static final String whitespaceTrimmed = "WFLYDM0002: Whitespace has been trimmed from the Base64 representation of the secret identity.";
    protected String whitespaceTrimmed$str() {
        return whitespaceTrimmed;
    }
    @Override
    public final void passwordAttributeDeprecated() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, passwordAttributeDeprecated$str());
    }
    private static final String passwordAttributeDeprecated = "WFLYDM0003: The attribute 'password' is deprecated, 'keystore-password' should be used instead.";
    protected String passwordAttributeDeprecated$str() {
        return passwordAttributeDeprecated;
    }
    @Override
    public final void realmMisMatch(final String realmRealmName, final String fileRealmName) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, realmMisMatch$str(), realmRealmName, fileRealmName);
    }
    private static final String realmMisMatch = "WFLYDM0004: The realm name of the defined security realm '%s' does not match the realm name within the properties file '%s'.";
    protected String realmMisMatch$str() {
        return realmMisMatch;
    }
    @Override
    public final void failedRetrieveLdapGroups(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, failedRetrieveLdapGroups$str());
    }
    private static final String failedRetrieveLdapGroups = "WFLYDM0005: Failed to retrieving groups from the LDAP provider.";
    protected String failedRetrieveLdapGroups$str() {
        return failedRetrieveLdapGroups;
    }
    @Override
    public final void failedRetrieveMatchingLdapGroups(final Throwable cause) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, cause, failedRetrieveMatchingLdapGroups$str());
    }
    private static final String failedRetrieveMatchingLdapGroups = "WFLYDM0006: Failed to retrieving matching groups from the pattern, check the regular expression for pattern attribute.";
    protected String failedRetrieveMatchingLdapGroups$str() {
        return failedRetrieveMatchingLdapGroups;
    }
    @Override
    public final void failedRetrieveMatchingGroups() {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, failedRetrieveMatchingGroups$str());
    }
    private static final String failedRetrieveMatchingGroups = "WFLYDM0007: Failed to retrieve matching groups from the groups, check the regular expression for groups attribute.";
    protected String failedRetrieveMatchingGroups$str() {
        return failedRetrieveMatchingGroups;
    }
    @Override
    public final void failedRetrieveLdapAttribute(final String attribute) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, failedRetrieveLdapAttribute$str(), attribute);
    }
    private static final String failedRetrieveLdapAttribute = "WFLYDM0008: Failed to retrieve attribute %s from search result.";
    protected String failedRetrieveLdapAttribute$str() {
        return failedRetrieveLdapAttribute;
    }
    private static final String cannotPerformVerification = "WFLYDM0009: Unable to perform verification";
    protected String cannotPerformVerification$str() {
        return cannotPerformVerification;
    }
    @Override
    public final IOException cannotPerformVerification(final Throwable cause) {
        final IOException result = new IOException(String.format(cannotPerformVerification$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRealm = "WFLYDM0010: Invalid Realm '%s' expected '%s'";
    protected String invalidRealm$str() {
        return invalidRealm;
    }
    @Override
    public final IllegalStateException invalidRealm(final String realm, final String expectedRealm) {
        final IllegalStateException result = new IllegalStateException(String.format(invalidRealm$str(), realm, expectedRealm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nameNotFound = "WFLYDM0011: Can't follow referral for authentication: %s";
    protected String nameNotFound$str() {
        return nameNotFound;
    }
    @Override
    public final NamingException nameNotFound(final String name) {
        final NamingException result = new NamingException(String.format(nameNotFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noUsername = "WFLYDM0013: No username provided.";
    protected String noUsername$str() {
        return noUsername;
    }
    @Override
    public final IOException noUsername() {
        final IOException result = new IOException(String.format(noUsername$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPassword = "WFLYDM0014: No password to verify.";
    protected String noPassword$str() {
        return noPassword;
    }
    @Override
    public final IOException noPassword() {
        final IOException result = new IOException(String.format(noPassword$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String oneOfRequired = "WFLYDM0015: One of '%s' or '%s' required.";
    protected String oneOfRequired$str() {
        return oneOfRequired;
    }
    @Override
    public final IllegalArgumentException oneOfRequired(final String attr1, final String attr2) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(oneOfRequired$str(), attr1, attr2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String realmNotSupported = "WFLYDM0016: Realm choice not currently supported.";
    protected String realmNotSupported$str() {
        return realmNotSupported;
    }
    @Override
    public final UnsupportedCallbackException realmNotSupported(final Callback callback) {
        final UnsupportedCallbackException result = new UnsupportedCallbackException(callback, String.format(realmNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadProperties = "WFLYDM0017: Unable to load properties";
    protected String unableToLoadProperties$str() {
        return unableToLoadProperties;
    }
    @Override
    public final StartException unableToLoadProperties(final Throwable cause) {
        final StartException result = new StartException(String.format(unableToLoadProperties$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToStart = "WFLYDM0018: Unable to start service";
    protected String unableToStart$str() {
        return unableToStart;
    }
    @Override
    public final StartException unableToStart(final Throwable cause) {
        final StartException result = new StartException(String.format(unableToStart$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String userNotFound = "WFLYDM0019: User '%s' not found.";
    protected String userNotFound$str() {
        return userNotFound;
    }
    @Override
    public final String userNotFound(final String username) {
        return String.format(userNotFound$str(), username);
    }
    private static final String userNotFoundInDirectory = "WFLYDM0020: User '%s' not found in directory.";
    protected String userNotFoundInDirectory$str() {
        return userNotFoundInDirectory;
    }
    @Override
    public final NamingException userNotFoundInDirectory(final String username) {
        final NamingException result = new NamingException(String.format(userNotFoundInDirectory$str(), username));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noConsoleAvailable = "WFLYDM0021: No java.io.Console available to interact with user.";
    protected String noConsoleAvailable$str() {
        return noConsoleAvailable;
    }
    @Override
    public final IllegalStateException noConsoleAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(noConsoleAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String propertiesFileNotFound = "WFLYDM0023: No %s files found.";
    protected String propertiesFileNotFound$str() {
        return propertiesFileNotFound;
    }
    @Override
    public final String propertiesFileNotFound(final String file) {
        return String.format(propertiesFileNotFound$str(), file);
    }
    private static final String enterNewUserDetails = "Enter the details of the new user to add.";
    protected String enterNewUserDetails$str() {
        return enterNewUserDetails;
    }
    @Override
    public final String enterNewUserDetails() {
        return String.format(enterNewUserDetails$str());
    }
    private static final String realmPrompt = "Realm (%s)";
    protected String realmPrompt$str() {
        return realmPrompt;
    }
    @Override
    public final String realmPrompt(final String realm) {
        return String.format(realmPrompt$str(), realm);
    }
    private static final String usernamePrompt0 = "Username";
    protected String usernamePrompt0$str() {
        return usernamePrompt0;
    }
    @Override
    public final String usernamePrompt() {
        return String.format(usernamePrompt0$str());
    }
    private static final String usernamePrompt1 = "Username (%s)";
    protected String usernamePrompt1$str() {
        return usernamePrompt1;
    }
    @Override
    public final String usernamePrompt(final String defaultUsername) {
        return String.format(usernamePrompt1$str(), defaultUsername);
    }
    private static final String noUsernameExiting = "WFLYDM0024: No Username entered, exiting.";
    protected String noUsernameExiting$str() {
        return noUsernameExiting;
    }
    @Override
    public final String noUsernameExiting() {
        return String.format(noUsernameExiting$str());
    }
    private static final String passwordPrompt = "Password";
    protected String passwordPrompt$str() {
        return passwordPrompt;
    }
    @Override
    public final String passwordPrompt() {
        return String.format(passwordPrompt$str());
    }
    private static final String noPasswordExiting = "WFLYDM0025: No Password entered, exiting.";
    protected String noPasswordExiting$str() {
        return noPasswordExiting;
    }
    @Override
    public final String noPasswordExiting() {
        return String.format(noPasswordExiting$str());
    }
    private static final String passwordConfirmationPrompt = "Re-enter Password";
    protected String passwordConfirmationPrompt$str() {
        return passwordConfirmationPrompt;
    }
    @Override
    public final String passwordConfirmationPrompt() {
        return String.format(passwordConfirmationPrompt$str());
    }
    private static final String passwordMisMatch = "WFLYDM0026: The passwords do not match.";
    protected String passwordMisMatch$str() {
        return passwordMisMatch;
    }
    @Override
    public final String passwordMisMatch() {
        return String.format(passwordMisMatch$str());
    }
    private static final String usernameNotAlphaNumeric = "WFLYDM0028: Username must be alphanumeric with the exception of the following accepted symbols (%s)";
    protected String usernameNotAlphaNumeric$str() {
        return usernameNotAlphaNumeric;
    }
    @Override
    public final String usernameNotAlphaNumeric(final String symbols) {
        return String.format(usernameNotAlphaNumeric$str(), symbols);
    }
    private static final String aboutToAddUser = "About to add user '%s' for realm '%s'";
    protected String aboutToAddUser$str() {
        return aboutToAddUser;
    }
    @Override
    public final String aboutToAddUser(final String username, final String realm) {
        return String.format(aboutToAddUser$str(), username, realm);
    }
    private static final String isCorrectPrompt = "Is this correct";
    protected String isCorrectPrompt$str() {
        return isCorrectPrompt;
    }
    @Override
    public final String isCorrectPrompt() {
        return String.format(isCorrectPrompt$str());
    }
    private static final String usernameEasyToGuess = "The username '%s' is easy to guess";
    protected String usernameEasyToGuess$str() {
        return usernameEasyToGuess;
    }
    @Override
    public final String usernameEasyToGuess(final String username) {
        return String.format(usernameEasyToGuess$str(), username);
    }
    private static final String sureToAddUser = "Are you sure you want to add user '%s' yes/no?";
    protected String sureToAddUser$str() {
        return sureToAddUser;
    }
    @Override
    public final String sureToAddUser(final String username) {
        return String.format(sureToAddUser$str(), username);
    }
    private static final String invalidConfirmationResponse = "WFLYDM0029: Invalid response. (Valid responses are %s and %s)";
    protected String invalidConfirmationResponse$str() {
        return invalidConfirmationResponse;
    }
    @Override
    public final String invalidConfirmationResponse(final String firstValues, final String secondValues) {
        return String.format(invalidConfirmationResponse$str(), firstValues, secondValues);
    }
    private static final String addedUser = "Added user '%s' to file '%s'";
    protected String addedUser$str() {
        return addedUser;
    }
    @Override
    public final String addedUser(final String username, final String fileName) {
        return String.format(addedUser$str(), username, fileName);
    }
    private static final String unableToAddUser = "WFLYDM0030: Unable to add user to %s due to error %s";
    protected String unableToAddUser$str() {
        return unableToAddUser;
    }
    @Override
    public final String unableToAddUser(final String file, final String error) {
        return String.format(unableToAddUser$str(), file, error);
    }
    private static final String unableToLoadUsers = "WFLYDM0031: Unable to add load users from %s due to error %s";
    protected String unableToLoadUsers$str() {
        return unableToLoadUsers;
    }
    @Override
    public final String unableToLoadUsers(final String file, final String error) {
        return String.format(unableToLoadUsers$str(), file, error);
    }
    private static final String errorHeader = "Error";
    protected String errorHeader$str() {
        return errorHeader;
    }
    @Override
    public final String errorHeader() {
        return String.format(errorHeader$str());
    }
    private static final String serverUser = "Is this new user going to be used for one AS process to connect to another AS process? %ne.g. for a slave host controller connecting to the master or for a Remoting connection for server to server EJB calls.";
    protected String serverUser$str() {
        return serverUser;
    }
    @Override
    public final String serverUser() {
        return String.format(serverUser$str());
    }
    private static final String yesNo = "yes/no?";
    protected String yesNo$str() {
        return yesNo;
    }
    @Override
    public final String yesNo() {
        return String.format(yesNo$str());
    }
    private static final String secretElement = "To represent the user add the following to the server-identities definition <secret value=\"%s\" />";
    protected String secretElement$str() {
        return secretElement;
    }
    @Override
    public final String secretElement(final String base64) {
        return String.format(secretElement$str(), base64);
    }
    private static final String multipleAuthenticationMechanismsDefined = "WFLYDM0033: Configuration for security realm '%s' includes multiple username/password based authentication mechanisms (%s). Only one is allowed";
    protected String multipleAuthenticationMechanismsDefined$str() {
        return multipleAuthenticationMechanismsDefined;
    }
    @Override
    public final OperationFailedException multipleAuthenticationMechanismsDefined(final String realmName, final Set<String> mechanisms) {
        final OperationFailedException result = new OperationFailedException(String.format(multipleAuthenticationMechanismsDefined$str(), realmName, mechanisms));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationFailedOneOfRequired = "WFLYDM0034: One of '%s' or '%s' required.";
    protected String operationFailedOneOfRequired$str() {
        return operationFailedOneOfRequired;
    }
    @Override
    public final OperationFailedException operationFailedOneOfRequired(final String attr1, final String attr2) {
        final OperationFailedException result = new OperationFailedException(String.format(operationFailedOneOfRequired$str(), attr1, attr2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationFailedOnlyOneOfRequired = "WFLYDM0035: Only one of '%s' or '%s' is required.";
    protected String operationFailedOnlyOneOfRequired$str() {
        return operationFailedOnlyOneOfRequired;
    }
    @Override
    public final OperationFailedException operationFailedOnlyOneOfRequired(final String attr1, final String attr2) {
        final OperationFailedException result = new OperationFailedException(String.format(operationFailedOnlyOneOfRequired$str(), attr1, attr2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String canNotBeNull = "WFLYDM0036: '%s' can not be null.";
    protected String canNotBeNull$str() {
        return canNotBeNull;
    }
    @Override
    public final IllegalArgumentException canNotBeNull(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(canNotBeNull$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSecurityContextEstablished = "WFLYDM0037: No security context has been established.";
    protected String noSecurityContextEstablished$str() {
        return noSecurityContextEstablished;
    }
    @Override
    public final String noSecurityContextEstablished() {
        return String.format(noSecurityContextEstablished$str());
    }
    private static final String filePrompt = "What type of user do you wish to add? %n a) Management User (mgmt-users.properties) %n b) Application User (application-users.properties)";
    protected String filePrompt$str() {
        return filePrompt;
    }
    @Override
    public final String filePrompt() {
        return String.format(filePrompt$str());
    }
    private static final String groupsPrompt = "What groups do you want this user to belong to? (Please enter a comma separated list, or leave blank for none)";
    protected String groupsPrompt$str() {
        return groupsPrompt;
    }
    @Override
    public final String groupsPrompt() {
        return String.format(groupsPrompt$str());
    }
    private static final String addedGroups = "Added user '%s' with groups %s to file '%s'";
    protected String addedGroups$str() {
        return addedGroups;
    }
    @Override
    public final String addedGroups(final String username, final String groups, final String fileName) {
        return String.format(addedGroups$str(), username, groups, fileName);
    }
    private static final String invalidChoiceResponse = "WFLYDM0039: Invalid response. (Valid responses are A, a, B, or b)";
    protected String invalidChoiceResponse$str() {
        return invalidChoiceResponse;
    }
    @Override
    public final String invalidChoiceResponse() {
        return String.format(invalidChoiceResponse$str());
    }
    private static final String aboutToUpdateEnabledUser = "User '%s' already exists and is enabled, would you like to... %n a) Update the existing user password and roles %n b) Disable the existing user %n c) Type a new username";
    protected String aboutToUpdateEnabledUser$str() {
        return aboutToUpdateEnabledUser;
    }
    @Override
    public final String aboutToUpdateEnabledUser(final String user) {
        return String.format(aboutToUpdateEnabledUser$str(), user);
    }
    private static final String aboutToUpdateDisabledUser = "User '%s' already exists and is disabled, would you like to... %n a) Update the existing user password and roles %n b) Enable the existing user %n c) Type a new username";
    protected String aboutToUpdateDisabledUser$str() {
        return aboutToUpdateDisabledUser;
    }
    @Override
    public final String aboutToUpdateDisabledUser(final String user) {
        return String.format(aboutToUpdateDisabledUser$str(), user);
    }
    private static final String updateUser = "Updated user '%s' to file '%s'";
    protected String updateUser$str() {
        return updateUser;
    }
    @Override
    public final String updateUser(final String userName, final String canonicalPath) {
        return String.format(updateUser$str(), userName, canonicalPath);
    }
    private static final String unableToUpdateUser = "WFLYDM0040: Unable to update user to %s due to error %s";
    protected String unableToUpdateUser$str() {
        return unableToUpdateUser;
    }
    @Override
    public final String unableToUpdateUser(final String absolutePath, final String message) {
        return String.format(unableToUpdateUser$str(), absolutePath, message);
    }
    private static final String updatedGroups = "Updated user '%s' with groups %s to file '%s'";
    protected String updatedGroups$str() {
        return updatedGroups;
    }
    @Override
    public final String updatedGroups(final String username, final String groups, final String fileName) {
        return String.format(updatedGroups$str(), username, groups, fileName);
    }
    private static final String invalidLocalUser = "WFLYDM0041: The user '%s' is not allowed in a local authentication.";
    protected String invalidLocalUser$str() {
        return invalidLocalUser;
    }
    @Override
    public final IOException invalidLocalUser(final String userName) {
        final IOException result = new IOException(String.format(invalidLocalUser$str(), userName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleCallbackHandlerForMechanism = "WFLYDM0042: Multiple CallbackHandlerServices for the same mechanism (%s)";
    protected String multipleCallbackHandlerForMechanism$str() {
        return multipleCallbackHandlerForMechanism;
    }
    @Override
    public final StartException multipleCallbackHandlerForMechanism(final String mechanismName) {
        final StartException result = new StartException(String.format(multipleCallbackHandlerForMechanism$str(), mechanismName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noCallbackHandlerForMechanism = "WFLYDM0043: No CallbackHandler available for mechanism %s in realm %s";
    protected String noCallbackHandlerForMechanism$str() {
        return noCallbackHandlerForMechanism;
    }
    @Override
    public final IllegalStateException noCallbackHandlerForMechanism(final String mechanism, final String realmName) {
        final IllegalStateException result = new IllegalStateException(String.format(noCallbackHandlerForMechanism$str(), mechanism, realmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPlugInProvidersLoaded = "WFLYDM0044: No plug in providers found for module name %s";
    protected String noPlugInProvidersLoaded$str() {
        return noPlugInProvidersLoaded;
    }
    @Override
    public final IllegalArgumentException noPlugInProvidersLoaded(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noPlugInProvidersLoaded$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadPlugInProviders = "WFLYDM0045: Unable to load plug-in for module %s due to error (%s)";
    protected String unableToLoadPlugInProviders$str() {
        return unableToLoadPlugInProviders;
    }
    @Override
    public final IllegalArgumentException unableToLoadPlugInProviders(final String name, final String error) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unableToLoadPlugInProviders$str(), name, error));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAuthenticationPlugInFound = "WFLYDM0046: No authentication plug-in found for name %s";
    protected String noAuthenticationPlugInFound$str() {
        return noAuthenticationPlugInFound;
    }
    @Override
    public final IllegalArgumentException noAuthenticationPlugInFound(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noAuthenticationPlugInFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInitialisePlugIn = "WFLYDM0047: Unable to initialise plug-in %s due to error %s";
    protected String unableToInitialisePlugIn$str() {
        return unableToInitialisePlugIn;
    }
    @Override
    public final IllegalStateException unableToInitialisePlugIn(final String name, final String message) {
        final IllegalStateException result = new IllegalStateException(String.format(unableToInitialisePlugIn$str(), name, message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passwordNotStrongEnough = "WFLYDM0048: Password is not strong enough, it is '%s'. It should be at least '%s'.";
    protected String passwordNotStrongEnough$str() {
        return passwordNotStrongEnough;
    }
    @Override
    public final String passwordNotStrongEnough(final String currentStrength, final String desiredStrength) {
        return String.format(passwordNotStrongEnough$str(), currentStrength, desiredStrength);
    }
    private static final String passwordMustNotBeEqual = "WFLYDM0049: Password must not be equal to '%s', this value is restricted.";
    protected String passwordMustNotBeEqual$str() {
        return passwordMustNotBeEqual;
    }
    @Override
    public final PasswordValidationException passwordMustNotBeEqual(final String password) {
        final PasswordValidationException result = new PasswordValidationException(String.format(passwordMustNotBeEqual$str(), password));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passwordMustHaveDigit = "WFLYDM0050: Password must have at least %d digit.";
    protected String passwordMustHaveDigit$str() {
        return passwordMustHaveDigit;
    }
    @Override
    public final String passwordMustHaveDigit(final int minDigit) {
        return String.format(passwordMustHaveDigit$str(), minDigit);
    }
    private static final String passwordMustHaveSymbol = "WFLYDM0051: Password must have at least %s non-alphanumeric symbol.";
    protected String passwordMustHaveSymbol$str() {
        return passwordMustHaveSymbol;
    }
    @Override
    public final String passwordMustHaveSymbol(final int minSymbol) {
        return String.format(passwordMustHaveSymbol$str(), minSymbol);
    }
    private static final String passwordMustHaveAlpha = "WFLYDM0052: Password must have at least %d alphanumeric character.";
    protected String passwordMustHaveAlpha$str() {
        return passwordMustHaveAlpha;
    }
    @Override
    public final String passwordMustHaveAlpha(final int minAlpha) {
        return String.format(passwordMustHaveAlpha$str(), minAlpha);
    }
    private static final String passwordNotLongEnough = "WFLYDM0053: Password must have at least %s characters!";
    protected String passwordNotLongEnough$str() {
        return passwordNotLongEnough;
    }
    @Override
    public final PasswordValidationException passwordNotLongEnough(final int desiredLength) {
        final PasswordValidationException result = new PasswordValidationException(String.format(passwordNotLongEnough$str(), desiredLength));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadKeyTrustFile = "WFLYDM0054: Unable to load key trust file.";
    protected String unableToLoadKeyTrustFile$str() {
        return unableToLoadKeyTrustFile;
    }
    @Override
    public final IllegalStateException unableToLoadKeyTrustFile(final Throwable t) {
        final IllegalStateException result = new IllegalStateException(String.format(unableToLoadKeyTrustFile$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToOperateOnTrustStore = "WFLYDM0055: Unable to operate on trust store.";
    protected String unableToOperateOnTrustStore$str() {
        return unableToOperateOnTrustStore;
    }
    @Override
    public final IllegalStateException unableToOperateOnTrustStore(final GeneralSecurityException gse) {
        final IllegalStateException result = new IllegalStateException(String.format(unableToOperateOnTrustStore$str()), gse);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateDelegateTrustManager = "WFLYDM0056: Unable to create delegate trust manager.";
    protected String unableToCreateDelegateTrustManager$str() {
        return unableToCreateDelegateTrustManager;
    }
    @Override
    public final IllegalStateException unableToCreateDelegateTrustManager() {
        final IllegalStateException result = new IllegalStateException(String.format(unableToCreateDelegateTrustManager$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onlyOneSyslogHandlerProtocol = "WFLYDM0057: The syslog-handler can only contain one protocol %s";
    protected String onlyOneSyslogHandlerProtocol$str() {
        return onlyOneSyslogHandlerProtocol;
    }
    @Override
    public final XMLStreamException onlyOneSyslogHandlerProtocol(final Location location) {
        final XMLStreamException result = new XMLStreamException(String.format(onlyOneSyslogHandlerProtocol$str(), location));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noHandlerCalled = "WFLYDM0058: There is no handler called '%s'";
    protected String noHandlerCalled$str() {
        return noHandlerCalled;
    }
    @Override
    public final IllegalStateException noHandlerCalled(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(noHandlerCalled$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sysLogProtocolAlreadyConfigured = "WFLYDM0059: There is already a protocol configured for the syslog handler at %s";
    protected String sysLogProtocolAlreadyConfigured$str() {
        return sysLogProtocolAlreadyConfigured;
    }
    @Override
    public final OperationFailedException sysLogProtocolAlreadyConfigured(final PathAddress append) {
        final OperationFailedException result = new OperationFailedException(String.format(sysLogProtocolAlreadyConfigured$str(), append));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSyslogProtocol = "WFLYDM0060: No syslog protocol was given";
    protected String noSyslogProtocol$str() {
        return noSyslogProtocol;
    }
    @Override
    public final OperationFailedException noSyslogProtocol() {
        final OperationFailedException result = new OperationFailedException(String.format(noSyslogProtocol$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noFormatterCalled = "WFLYDM0061: There is no formatter called '%s'";
    protected String noFormatterCalled$str() {
        return noFormatterCalled;
    }
    @Override
    public final OperationFailedException noFormatterCalled(final String formatterName) {
        final OperationFailedException result = new OperationFailedException(String.format(noFormatterCalled$str(), formatterName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRemoveReferencedFormatter = "WFLYDM0062: Can not remove formatter, it is still referenced by the handler '%s'";
    protected String cannotRemoveReferencedFormatter$str() {
        return cannotRemoveReferencedFormatter;
    }
    @Override
    public final OperationFailedException cannotRemoveReferencedFormatter(final PathElement pathElement) {
        final OperationFailedException result = new OperationFailedException(String.format(cannotRemoveReferencedFormatter$str(), pathElement));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String handlerAlreadyExists = "WFLYDM0063: Handler names must be unique. There is already a handler called '%s' at %s";
    protected String handlerAlreadyExists$str() {
        return handlerAlreadyExists;
    }
    @Override
    public final OperationFailedException handlerAlreadyExists(final String name, final PathAddress append) {
        final OperationFailedException result = new OperationFailedException(String.format(handlerAlreadyExists$str(), name, append));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleRealmsDetected = "WFLYDM0064: Different realm names detected '%s', '%s' reading user property files, all realms must be equal.";
    protected String multipleRealmsDetected$str() {
        return multipleRealmsDetected;
    }
    @Override
    public final String multipleRealmsDetected(final String realmOne, final String realmTwo) {
        return String.format(multipleRealmsDetected$str(), realmOne, realmTwo);
    }
    private static final String userRealmNotMatchDiscovered = "WFLYDM0065: The user supplied realm name '%s' does not match the realm name discovered from the property file(s) '%s'.";
    protected String userRealmNotMatchDiscovered$str() {
        return userRealmNotMatchDiscovered;
    }
    @Override
    public final String userRealmNotMatchDiscovered(final String supplied, final String discovered) {
        return String.format(userRealmNotMatchDiscovered$str(), supplied, discovered);
    }
    private static final String groupPropertiesButNoUserProperties = "WFLYDM0066: A group properties file '%s' has been specified, however no user properties has been specified.";
    protected String groupPropertiesButNoUserProperties$str() {
        return groupPropertiesButNoUserProperties;
    }
    @Override
    public final String groupPropertiesButNoUserProperties(final String groupProperties) {
        return String.format(groupPropertiesButNoUserProperties$str(), groupProperties);
    }
    private static final String realmMustBeSpecified = "WFLYDM0067: A realm name must be specified.";
    protected String realmMustBeSpecified$str() {
        return realmMustBeSpecified;
    }
    @Override
    public final String realmMustBeSpecified() {
        return String.format(realmMustBeSpecified$str());
    }
    private static final String inconsistentRbacConfiguration = "WFLYDM0068: The current operation(s) would result in role based access control being enabled but leave it impossible for authenticated users to be assigned roles.";
    protected String inconsistentRbacConfiguration$str() {
        return inconsistentRbacConfiguration;
    }
    @Override
    public final OperationFailedException inconsistentRbacConfiguration() {
        final OperationFailedException result = new OperationFailedException(String.format(inconsistentRbacConfiguration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String inconsistentRbacRuntimeState = "WFLYDM0069: The runtime role mapping configuration is inconsistent, the server must be restarted.";
    protected String inconsistentRbacRuntimeState$str() {
        return inconsistentRbacRuntimeState;
    }
    @Override
    public final OperationFailedException inconsistentRbacRuntimeState() {
        final OperationFailedException result = new OperationFailedException(String.format(inconsistentRbacRuntimeState$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidChoiceUpdateUserResponse = "WFLYDM0070: Invalid response. (Valid responses are A, a, B, b, C or c)";
    protected String invalidChoiceUpdateUserResponse$str() {
        return invalidChoiceUpdateUserResponse;
    }
    @Override
    public final String invalidChoiceUpdateUserResponse() {
        return String.format(invalidChoiceUpdateUserResponse$str());
    }
    private static final String duplicateIncludeExclude = "WFLYDM0071: Role '%s' already contains an %s for type=%s, name=%s, realm=%s.";
    protected String duplicateIncludeExclude$str() {
        return duplicateIncludeExclude;
    }
    @Override
    public final OperationFailedException duplicateIncludeExclude(final String roleName, final String incExcl, final String type, final String name, final String realm) {
        final OperationFailedException result = new OperationFailedException(String.format(duplicateIncludeExclude$str(), roleName, incExcl, type, name, realm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleAuthorizationConfigurationsDefined = "WFLYDM0072: Configuration for security realm '%s' includes multiple authorization configurations (%s). Only one is allowed";
    protected String multipleAuthorizationConfigurationsDefined$str() {
        return multipleAuthorizationConfigurationsDefined;
    }
    @Override
    public final OperationFailedException multipleAuthorizationConfigurationsDefined(final String realmName, final Set<String> configurations) {
        final OperationFailedException result = new OperationFailedException(String.format(multipleAuthorizationConfigurationsDefined$str(), realmName, configurations));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleUsernameToDnConfigurationsDefined = "WFLYDM0073: Configuration for security realm '%s' includes multiple username-to-dn resources within the authorization=ldap resource (%s). Only one is allowed";
    protected String multipleUsernameToDnConfigurationsDefined$str() {
        return multipleUsernameToDnConfigurationsDefined;
    }
    @Override
    public final OperationFailedException multipleUsernameToDnConfigurationsDefined(final String realmName, final Set<String> configurations) {
        final OperationFailedException result = new OperationFailedException(String.format(multipleUsernameToDnConfigurationsDefined$str(), realmName, configurations));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noGroupSearchDefined = "WFLYDM0074: Configuration for security realm '%s' does not contain any group-search resource within the authorization=ldap resource.";
    protected String noGroupSearchDefined$str() {
        return noGroupSearchDefined;
    }
    @Override
    public final OperationFailedException noGroupSearchDefined(final String realmName) {
        final OperationFailedException result = new OperationFailedException(String.format(noGroupSearchDefined$str(), realmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleGroupSearchConfigurationsDefined = "WFLYDM0075: Configuration for security realm '%s' includes multiple group-search resources within the authorization=ldap resource (%s). Only one is allowed";
    protected String multipleGroupSearchConfigurationsDefined$str() {
        return multipleGroupSearchConfigurationsDefined;
    }
    @Override
    public final OperationFailedException multipleGroupSearchConfigurationsDefined(final String realmName, final Set<String> configurations) {
        final OperationFailedException result = new OperationFailedException(String.format(multipleGroupSearchConfigurationsDefined$str(), realmName, configurations));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRoleName = "WFLYDM0076: The role name '%s' is not a valid standard role.";
    protected String invalidRoleName$str() {
        return invalidRoleName;
    }
    @Override
    public final OperationFailedException invalidRoleName(final String roleName) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidRoleName$str(), roleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRoleNameDomain = "WFLYDM0077: The role name '%s' is not a valid standard role and is not a host scoped role or a server group scoped role.";
    protected String invalidRoleNameDomain$str() {
        return invalidRoleNameDomain;
    }
    @Override
    public final OperationFailedException invalidRoleNameDomain(final String roleName) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidRoleNameDomain$str(), roleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String roleMappingRemaining = "WFLYDM0078: The scoped role '%s' can not be removed as a role mapping still exists.";
    protected String roleMappingRemaining$str() {
        return roleMappingRemaining;
    }
    @Override
    public final OperationFailedException roleMappingRemaining(final String roleName) {
        final OperationFailedException result = new OperationFailedException(String.format(roleMappingRemaining$str(), roleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateScopedRole = "WFLYDM0079: A %s already exists with name '%s'";
    protected String duplicateScopedRole$str() {
        return duplicateScopedRole;
    }
    @Override
    public final OperationFailedException duplicateScopedRole(final String scopeType, final String roleName) {
        final OperationFailedException result = new OperationFailedException(String.format(duplicateScopedRole$str(), scopeType, roleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String scopedRoleStandardName = "WFLYDM0080: The name '%s' conflicts with the standard role name of '%s' - comparison is case insensitive.";
    protected String scopedRoleStandardName$str() {
        return scopedRoleStandardName;
    }
    @Override
    public final OperationFailedException scopedRoleStandardName(final String scopedRole, final String standardRole) {
        final OperationFailedException result = new OperationFailedException(String.format(scopedRoleStandardName$str(), scopedRole, standardRole));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String badBaseRole = "WFLYDM0081: The base-role '%s' is not one of the standard roles for the current authorization provider.";
    protected String badBaseRole$str() {
        return badBaseRole;
    }
    @Override
    public final OperationFailedException badBaseRole(final String baseRole) {
        final OperationFailedException result = new OperationFailedException(String.format(badBaseRole$str(), baseRole));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passwordUsernameMatchError = "WFLYDM0082: The password must be different from the username";
    protected String passwordUsernameMatchError$str() {
        return passwordUsernameMatchError;
    }
    @Override
    public final PasswordValidationException passwordUsernameMatchError() {
        final PasswordValidationException result = new PasswordValidationException(String.format(passwordUsernameMatchError$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noKey = "WFLYDM0083: The KeyStore %s does not contain any keys.";
    protected String noKey$str() {
        return noKey;
    }
    @Override
    public final StartException noKey(final String path) {
        final StartException result = new StartException(String.format(noKey$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String aliasNotKey = "WFLYDM0084: The alias specified '%s' is not a Key, valid aliases are %s";
    protected String aliasNotKey$str() {
        return aliasNotKey;
    }
    @Override
    public final StartException aliasNotKey(final String alias, final String validList) {
        final StartException result = new StartException(String.format(aliasNotKey$str(), alias, validList));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String aliasNotFound = "WFLYDM0085: The alias specified '%s' does not exist in the KeyStore, valid aliases are %s";
    protected String aliasNotFound$str() {
        return aliasNotFound;
    }
    @Override
    public final StartException aliasNotFound(final String alias, final String validList) {
        final StartException result = new StartException(String.format(aliasNotFound$str(), alias, validList));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreNotFound = "WFLYDM0086: The KeyStore can not be found at %s";
    protected String keyStoreNotFound$str() {
        return keyStoreNotFound;
    }
    @Override
    public final StartException keyStoreNotFound(final String path) {
        final StartException result = new StartException(String.format(keyStoreNotFound$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleCacheConfigurationsDefined = "WFLYDM0087: Configuration for security realm '%s' includes multiple cache definitions at the same position in the hierarchy. Only one is allowed";
    protected String multipleCacheConfigurationsDefined$str() {
        return multipleCacheConfigurationsDefined;
    }
    @Override
    public final OperationFailedException multipleCacheConfigurationsDefined(final String realmName) {
        final OperationFailedException result = new OperationFailedException(String.format(multipleCacheConfigurationsDefined$str(), realmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String usernameNotLoaded = "WFLYDM0088: Unable to load username for supplied username '%s'";
    protected String usernameNotLoaded$str() {
        return usernameNotLoaded;
    }
    @Override
    public final NamingException usernameNotLoaded(final String name) {
        final NamingException result = new NamingException(String.format(usernameNotLoaded$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noNonProgressingOperationFound = "WFLYDM0089: No operation was found that has been holding the operation execution write lock for long than [%d] seconds";
    protected String noNonProgressingOperationFound$str() {
        return noNonProgressingOperationFound;
    }
    @Override
    public final OperationFailedException noNonProgressingOperationFound(final long timeout) {
        final OperationFailedException result = new OperationFailedException(String.format(noNonProgressingOperationFound$str(), timeout));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeytab = "WFLYDM0090: Invalid Keytab path";
    protected String invalidKeytab$str() {
        return invalidKeytab;
    }
    @Override
    public final StartException invalidKeytab(final Exception cause) {
        final StartException result = new StartException(String.format(invalidKeytab$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String subjectIdentityLoggedOut = "WFLYDM0091: logout has already been called on this SubjectIdentity.";
    protected String subjectIdentityLoggedOut$str() {
        return subjectIdentityLoggedOut;
    }
    @Override
    public final IllegalStateException subjectIdentityLoggedOut() {
        final IllegalStateException result = new IllegalStateException(String.format(subjectIdentityLoggedOut$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainTGT = "WFLYDM0092: Unable to obtain Kerberos TGT";
    protected String unableToObtainTGT$str() {
        return unableToObtainTGT;
    }
    @Override
    public final OperationFailedException unableToObtainTGT(final Exception cause) {
        final OperationFailedException result = new OperationFailedException(String.format(unableToObtainTGT$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void keytabLoginFailed(final String principal, final String host, final LoginException e) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.ERROR, e, keytabLoginFailed$str(), principal, host);
    }
    private static final String keytabLoginFailed = "WFLYDM0093: Login failed using Keytab for principal '%s' to handle request for host '%s'";
    protected String keytabLoginFailed$str() {
        return keytabLoginFailed;
    }
    private static final String kerberosWithoutKeytab = "WFLYDM0094: Kerberos is enabled for authentication on security realm '%s' but no Keytab has been added to the server-identity.";
    protected String kerberosWithoutKeytab$str() {
        return kerberosWithoutKeytab;
    }
    @Override
    public final OperationFailedException kerberosWithoutKeytab(final String realm) {
        final OperationFailedException result = new OperationFailedException(String.format(kerberosWithoutKeytab$str(), realm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noCipherSuitesInCommon = "WFLYDM0095: No cipher suites in common, supported=(%s), requested=(%s)";
    protected String noCipherSuitesInCommon$str() {
        return noCipherSuitesInCommon;
    }
    @Override
    public final StartException noCipherSuitesInCommon(final String supported, final String requested) {
        final StartException result = new StartException(String.format(noCipherSuitesInCommon$str(), supported, requested));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noProtocolsInCommon = "WFLYDM0096: No protocols in common, supported=(%s), requested=(%s)";
    protected String noProtocolsInCommon$str() {
        return noProtocolsInCommon;
    }
    @Override
    public final StartException noProtocolsInCommon(final String supported, final String requested) {
        final StartException result = new StartException(String.format(noProtocolsInCommon$str(), supported, requested));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passwordShouldNotBeEqual = "WFLYDM0097: Password should not be equal to '%s', this value is restricted.";
    protected String passwordShouldNotBeEqual$str() {
        return passwordShouldNotBeEqual;
    }
    @Override
    public final PasswordValidationException passwordShouldNotBeEqual(final String password) {
        final PasswordValidationException result = new PasswordValidationException(String.format(passwordShouldNotBeEqual$str(), password));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passwordUsernameShouldNotMatch = "WFLYDM0098: The password should be different from the username";
    protected String passwordUsernameShouldNotMatch$str() {
        return passwordUsernameShouldNotMatch;
    }
    @Override
    public final PasswordValidationException passwordUsernameShouldNotMatch() {
        final PasswordValidationException result = new PasswordValidationException(String.format(passwordUsernameShouldNotMatch$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passwordShouldHaveXCharacters = "WFLYDM0099: Password should have at least %s characters!";
    protected String passwordShouldHaveXCharacters$str() {
        return passwordShouldHaveXCharacters;
    }
    @Override
    public final PasswordValidationException passwordShouldHaveXCharacters(final int desiredLength) {
        final PasswordValidationException result = new PasswordValidationException(String.format(passwordShouldHaveXCharacters$str(), desiredLength));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passwordShouldHaveAlpha = "WFLYDM0100: Password should have at least %d alphanumeric character.";
    protected String passwordShouldHaveAlpha$str() {
        return passwordShouldHaveAlpha;
    }
    @Override
    public final String passwordShouldHaveAlpha(final int minAlpha) {
        return String.format(passwordShouldHaveAlpha$str(), minAlpha);
    }
    private static final String passwordShouldHaveDigit = "WFLYDM0101: Password should have at least %d digit.";
    protected String passwordShouldHaveDigit$str() {
        return passwordShouldHaveDigit;
    }
    @Override
    public final String passwordShouldHaveDigit(final int minDigit) {
        return String.format(passwordShouldHaveDigit$str(), minDigit);
    }
    private static final String passwordShouldHaveSymbol = "WFLYDM0102: Password should have at least %s non-alphanumeric symbol.";
    protected String passwordShouldHaveSymbol$str() {
        return passwordShouldHaveSymbol;
    }
    @Override
    public final String passwordShouldHaveSymbol(final int minSymbol) {
        return String.format(passwordShouldHaveSymbol$str(), minSymbol);
    }
    private static final String invalidSize = "WFLYDM0103: Invalid size %s";
    protected String invalidSize$str() {
        return invalidSize;
    }
    @Override
    public final OperationFailedException invalidSize(final String size) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidSize$str(), size));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String suffixContainsMillis = "WFLYDM0104: The suffix (%s) can not contain seconds or milliseconds.";
    protected String suffixContainsMillis$str() {
        return suffixContainsMillis;
    }
    @Override
    public final OperationFailedException suffixContainsMillis(final String suffix) {
        final OperationFailedException result = new OperationFailedException(String.format(suffixContainsMillis$str(), suffix));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidSuffix = "WFLYDM0105: The suffix (%s) is invalid. A suffix must be a valid date format.";
    protected String invalidSuffix$str() {
        return invalidSuffix;
    }
    @Override
    public final OperationFailedException invalidSuffix(final String suffix) {
        final OperationFailedException result = new OperationFailedException(String.format(invalidSuffix$str(), suffix));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String filePermissionsProblemsFound = "WFLYDM0106: File permissions problems found while attempting to update %s file.";
    protected String filePermissionsProblemsFound$str() {
        return filePermissionsProblemsFound;
    }
    @Override
    public final String filePermissionsProblemsFound(final String file) {
        return String.format(filePermissionsProblemsFound$str(), file);
    }
    private static final String domainRolloutNotProgressing = "WFLYDM0107: Operation '%s' has been holding the operation execution write lock for longer than [%d] seconds, but it is part of the rollout of a domain-wide operation with domain-uuid '%s' that has other operations that are alsonot progressing. Their ids are: %s. Cancellation of the operation on the master host controller is recommended.";
    protected String domainRolloutNotProgressing$str() {
        return domainRolloutNotProgressing;
    }
    @Override
    public final OperationFailedException domainRolloutNotProgressing(final String exclusiveLock, final long timeout, final String domainUUID, final Collection relatedOps) {
        final OperationFailedException result = new OperationFailedException(String.format(domainRolloutNotProgressing$str(), exclusiveLock, timeout, domainUUID, relatedOps));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedResource = "WFLYDM0108: Unsupported resource '%s'";
    protected String unsupportedResource$str() {
        return unsupportedResource;
    }
    @Override
    public final IllegalStateException unsupportedResource(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(unsupportedResource$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyTabFileNotFound = "WFLYDM0109: The Keytab file '%s' does not exist.";
    protected String keyTabFileNotFound$str() {
        return keyTabFileNotFound;
    }
    @Override
    public final StartException keyTabFileNotFound(final String fileName) {
        final StartException result = new StartException(String.format(keyTabFileNotFound$str(), fileName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadSimpleNameForGroup = "WFLYDM0110: Unable to load a simple name for group '%s'";
    protected String unableToLoadSimpleNameForGroup$str() {
        return unableToLoadSimpleNameForGroup;
    }
    @Override
    public final NamingException unableToLoadSimpleNameForGroup(final String distinguishedName) {
        final NamingException result = new NamingException(String.format(unableToLoadSimpleNameForGroup$str(), distinguishedName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void keystoreWillBeCreated(final String file, final String host) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, keystoreWillBeCreated$str(), file, host);
    }
    private static final String keystoreWillBeCreated = "WFLYDM0111: Keystore %s not found, it will be auto generated on first use with a self signed certificate for host %s";
    protected String keystoreWillBeCreated$str() {
        return keystoreWillBeCreated;
    }
    private static final String failedToGenerateSelfSignedCertificate = "WFLYDM0112: Failed to generate self signed certificate";
    protected String failedToGenerateSelfSignedCertificate$str() {
        return failedToGenerateSelfSignedCertificate;
    }
    @Override
    public final RuntimeException failedToGenerateSelfSignedCertificate(final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(failedToGenerateSelfSignedCertificate$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void keystoreHasBeenCreated(final String file, final String sha1, final String sha256) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.WARN, null, keystoreHasBeenCreated$str(), file, sha1, sha256);
    }
    private static final String keystoreHasBeenCreated = "WFLYDM0113: Generated self signed certificate at %s. Please note that self signed certificates are not secure, and should only be used for testing purposes. Do not use this self signed certificate in production.\nSHA-1 fingerprint of the generated key is %s\nSHA-256 fingerprint of the generated key is %s";
    protected String keystoreHasBeenCreated$str() {
        return keystoreHasBeenCreated;
    }
    private static final String failedToCreateLazyInitSSLContext = "WFLYDM0114: Failed to lazily initialize SSL context";
    protected String failedToCreateLazyInitSSLContext$str() {
        return failedToCreateLazyInitSSLContext;
    }
    @Override
    public final RuntimeException failedToCreateLazyInitSSLContext(final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(failedToCreateLazyInitSSLContext$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSignatureAlgorithmNameGiven = "WFLYDM0115: No signature algorithm name given";
    protected String noSignatureAlgorithmNameGiven$str() {
        return noSignatureAlgorithmNameGiven;
    }
    @Override
    public final IllegalArgumentException noSignatureAlgorithmNameGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noSignatureAlgorithmNameGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownSignatureAlgorithmName = "WFLYDM0116: Signature algorithm name \"%s\" is not recognized";
    protected String unknownSignatureAlgorithmName$str() {
        return unknownSignatureAlgorithmName;
    }
    @Override
    public final IllegalArgumentException unknownSignatureAlgorithmName(final String signatureAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unknownSignatureAlgorithmName$str(), signatureAlgorithmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSigningKeyGiven = "WFLYDM0117: No signing key given";
    protected String noSigningKeyGiven$str() {
        return noSigningKeyGiven;
    }
    @Override
    public final IllegalArgumentException noSigningKeyGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noSigningKeyGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String signingKeyNotCompatWithSig = "WFLYDM0118: Signing key algorithm name \"%s\" is not compatible with signature algorithm name \"%s\"";
    protected String signingKeyNotCompatWithSig$str() {
        return signingKeyNotCompatWithSig;
    }
    @Override
    public final IllegalArgumentException signingKeyNotCompatWithSig(final String signingKeyAlgorithm, final String signatureAlgorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(signingKeyNotCompatWithSig$str(), signingKeyAlgorithm, signatureAlgorithmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String validAfterBeforeValidBefore = "WFLYDM0119: Not-valid-before date of %s is after not-valid-after date of %s";
    protected String validAfterBeforeValidBefore$str() {
        return validAfterBeforeValidBefore;
    }
    @Override
    public final IllegalArgumentException validAfterBeforeValidBefore(final ZonedDateTime notValidBefore, final ZonedDateTime notValidAfter) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(validAfterBeforeValidBefore$str(), notValidBefore, notValidAfter));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noIssuerDnGiven = "WFLYDM0120: No issuer DN given";
    protected String noIssuerDnGiven$str() {
        return noIssuerDnGiven;
    }
    @Override
    public final IllegalArgumentException noIssuerDnGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noIssuerDnGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPublicKeyGiven = "WFLYDM0121: No public key given";
    protected String noPublicKeyGiven$str() {
        return noPublicKeyGiven;
    }
    @Override
    public final IllegalArgumentException noPublicKeyGiven() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noPublicKeyGiven$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String uniqueIdNotAllowed = "WFLYDM0122: Issuer and subject unique ID are only allowed in certificates with version 2 or higher";
    protected String uniqueIdNotAllowed$str() {
        return uniqueIdNotAllowed;
    }
    @Override
    public final IllegalArgumentException uniqueIdNotAllowed() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(uniqueIdNotAllowed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidKeyForCert = "WFLYDM0123: X.509 encoding of public key with algorithm \"%s\" failed";
    protected String invalidKeyForCert$str() {
        return invalidKeyForCert;
    }
    @Override
    public final IllegalArgumentException invalidKeyForCert(final String publicKeyAlgorithm, final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidKeyForCert$str(), publicKeyAlgorithm), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String certSigningFailed = "WFLYDM0124: Failed to sign certificate";
    protected String certSigningFailed$str() {
        return certSigningFailed;
    }
    @Override
    public final IllegalArgumentException certSigningFailed(final Exception cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(certSigningFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serialNumberTooSmall = "WFLYDM0125: Certificate serial number must be positive";
    protected String serialNumberTooSmall$str() {
        return serialNumberTooSmall;
    }
    @Override
    public final IllegalArgumentException serialNumberTooSmall() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(serialNumberTooSmall$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serialNumberTooLarge = "WFLYDM0126: Certificate serial number too large (cannot exceed 20 octets)";
    protected String serialNumberTooLarge$str() {
        return serialNumberTooLarge;
    }
    @Override
    public final IllegalArgumentException serialNumberTooLarge() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(serialNumberTooLarge$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSequenceToEnd = "WFLYDM0127: No sequence to end";
    protected String noSequenceToEnd$str() {
        return noSequenceToEnd;
    }
    @Override
    public final IllegalStateException noSequenceToEnd() {
        final IllegalStateException result = new IllegalStateException(String.format(noSequenceToEnd$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSetToEnd = "WFLYDM0128: No set to end";
    protected String noSetToEnd$str() {
        return noSetToEnd;
    }
    @Override
    public final IllegalStateException noSetToEnd() {
        final IllegalStateException result = new IllegalStateException(String.format(noSetToEnd$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noExplicitlyTaggedElementToEnd = "WFLYDM0129: No explicitly tagged element to end";
    protected String noExplicitlyTaggedElementToEnd$str() {
        return noExplicitlyTaggedElementToEnd;
    }
    @Override
    public final IllegalStateException noExplicitlyTaggedElementToEnd() {
        final IllegalStateException result = new IllegalStateException(String.format(noExplicitlyTaggedElementToEnd$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidOidCharacter = "WFLYDM0130: Invalid OID character";
    protected String asnInvalidOidCharacter$str() {
        return asnInvalidOidCharacter;
    }
    @Override
    public final IllegalArgumentException asnInvalidOidCharacter() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(asnInvalidOidCharacter$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnOidMustHaveAtLeast2Components = "WFLYDM0131: OID must have at least 2 components";
    protected String asnOidMustHaveAtLeast2Components$str() {
        return asnOidMustHaveAtLeast2Components;
    }
    @Override
    public final IllegalArgumentException asnOidMustHaveAtLeast2Components() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(asnOidMustHaveAtLeast2Components$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidValueForFirstOidComponent = "WFLYDM0132: Invalid value for first OID component; expected 0, 1, or 2";
    protected String asnInvalidValueForFirstOidComponent$str() {
        return asnInvalidValueForFirstOidComponent;
    }
    @Override
    public final IllegalArgumentException asnInvalidValueForFirstOidComponent() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(asnInvalidValueForFirstOidComponent$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidValueForSecondOidComponent = "WFLYDM0133: Invalid value for second OID component; expected a value between 0 and 39 (inclusive)";
    protected String asnInvalidValueForSecondOidComponent$str() {
        return asnInvalidValueForSecondOidComponent;
    }
    @Override
    public final IllegalArgumentException asnInvalidValueForSecondOidComponent() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(asnInvalidValueForSecondOidComponent$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String asnInvalidLength = "WFLYDM0134: Invalid length";
    protected String asnInvalidLength$str() {
        return asnInvalidLength;
    }
    @Override
    public final IllegalArgumentException asnInvalidLength() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(asnInvalidLength$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passwordUsernameMustMatchInfo = "The password must be different from the username";
    protected String passwordUsernameMustMatchInfo$str() {
        return passwordUsernameMustMatchInfo;
    }
    @Override
    public final String passwordUsernameMustMatchInfo() {
        return String.format(passwordUsernameMustMatchInfo$str());
    }
    private static final String passwordUsernameShouldMatchInfo = "The password should be different from the username";
    protected String passwordUsernameShouldMatchInfo$str() {
        return passwordUsernameShouldMatchInfo;
    }
    @Override
    public final String passwordUsernameShouldMatchInfo() {
        return String.format(passwordUsernameShouldMatchInfo$str());
    }
    private static final String passwordMustNotEqualInfo = "The password must not be one of the following restricted values {%s}";
    protected String passwordMustNotEqualInfo$str() {
        return passwordMustNotEqualInfo;
    }
    @Override
    public final String passwordMustNotEqualInfo(final String restricted) {
        return String.format(passwordMustNotEqualInfo$str(), restricted);
    }
    private static final String passwordShouldNotEqualInfo = "The password should not be one of the following restricted values {%s}";
    protected String passwordShouldNotEqualInfo$str() {
        return passwordShouldNotEqualInfo;
    }
    @Override
    public final String passwordShouldNotEqualInfo(final String restricted) {
        return String.format(passwordShouldNotEqualInfo$str(), restricted);
    }
    private static final String passwordLengthInfo = "%s characters";
    protected String passwordLengthInfo$str() {
        return passwordLengthInfo;
    }
    @Override
    public final String passwordLengthInfo(final int desiredLength) {
        return String.format(passwordLengthInfo$str(), desiredLength);
    }
    private static final String passwordMustHaveAlphaInfo = "%d alphabetic character(s)";
    protected String passwordMustHaveAlphaInfo$str() {
        return passwordMustHaveAlphaInfo;
    }
    @Override
    public final String passwordMustHaveAlphaInfo(final int minAlpha) {
        return String.format(passwordMustHaveAlphaInfo$str(), minAlpha);
    }
    private static final String passwordMustHaveDigitInfo = "%d digit(s)";
    protected String passwordMustHaveDigitInfo$str() {
        return passwordMustHaveDigitInfo;
    }
    @Override
    public final String passwordMustHaveDigitInfo(final int minDigit) {
        return String.format(passwordMustHaveDigitInfo$str(), minDigit);
    }
    private static final String passwordMustHaveSymbolInfo = "%s non-alphanumeric symbol(s)";
    protected String passwordMustHaveSymbolInfo$str() {
        return passwordMustHaveSymbolInfo;
    }
    @Override
    public final String passwordMustHaveSymbolInfo(final int minSymbol) {
        return String.format(passwordMustHaveSymbolInfo$str(), minSymbol);
    }
    private static final String passwordMustContainInfo = "The password must contain at least %s";
    protected String passwordMustContainInfo$str() {
        return passwordMustContainInfo;
    }
    @Override
    public final String passwordMustContainInfo(final String requirements) {
        return String.format(passwordMustContainInfo$str(), requirements);
    }
    private static final String passwordShouldContainInfo = "The password should contain at least %s";
    protected String passwordShouldContainInfo$str() {
        return passwordShouldContainInfo;
    }
    @Override
    public final String passwordShouldContainInfo(final String requirements) {
        return String.format(passwordShouldContainInfo$str(), requirements);
    }
    private static final String sureToSetPassword = "Are you sure you want to use the password entered yes/no?";
    protected String sureToSetPassword$str() {
        return sureToSetPassword;
    }
    @Override
    public final String sureToSetPassword() {
        return String.format(sureToSetPassword$str());
    }
    private static final String argUsage = "Usage: ./add-user.sh [args...]%nwhere args include:";
    protected String argUsage$str() {
        return argUsage;
    }
    @Override
    public final String argUsage() {
        return String.format(argUsage$str());
    }
    private static final String argApplicationUsers = "If set add an application user instead of a management user";
    protected String argApplicationUsers$str() {
        return argApplicationUsers;
    }
    @Override
    public final String argApplicationUsers() {
        return String.format(argApplicationUsers$str());
    }
    private static final String argDomainConfigDirUsers = "Define the location of the domain config directory.";
    protected String argDomainConfigDirUsers$str() {
        return argDomainConfigDirUsers;
    }
    @Override
    public final String argDomainConfigDirUsers() {
        return String.format(argDomainConfigDirUsers$str());
    }
    private static final String argServerConfigDirUsers = "Define the location of the server config directory.";
    protected String argServerConfigDirUsers$str() {
        return argServerConfigDirUsers;
    }
    @Override
    public final String argServerConfigDirUsers() {
        return String.format(argServerConfigDirUsers$str());
    }
    private static final String argUserProperties = "The file name of the user properties file which can be an absolute path.";
    protected String argUserProperties$str() {
        return argUserProperties;
    }
    @Override
    public final String argUserProperties() {
        return String.format(argUserProperties$str());
    }
    private static final String argGroupProperties = "The file name of the group properties file which can be an absolute path. (If group properties is specified then user properties MUST also be specified).";
    protected String argGroupProperties$str() {
        return argGroupProperties;
    }
    @Override
    public final String argGroupProperties() {
        return String.format(argGroupProperties$str());
    }
    private static final String argPassword = "Password of the user, this will be checked against the password requirements defined within the add-user.properties configuration";
    protected String argPassword$str() {
        return argPassword;
    }
    @Override
    public final String argPassword() {
        return String.format(argPassword$str());
    }
    private static final String argUser = "Name of the user";
    protected String argUser$str() {
        return argUser;
    }
    @Override
    public final String argUser() {
        return String.format(argUser$str());
    }
    private static final String argRealm = "Name of the realm used to secure the management interfaces (default is \"ManagementRealm\")";
    protected String argRealm$str() {
        return argRealm;
    }
    @Override
    public final String argRealm() {
        return String.format(argRealm$str());
    }
    private static final String argSilent = "Activate the silent mode (no output to the console)";
    protected String argSilent$str() {
        return argSilent;
    }
    @Override
    public final String argSilent() {
        return String.format(argSilent$str());
    }
    private static final String argRole = "Comma-separated list of roles for the user.";
    protected String argRole$str() {
        return argRole;
    }
    @Override
    public final String argRole() {
        return String.format(argRole$str());
    }
    private static final String argGroup = "Comma-separated list of groups for the user.";
    protected String argGroup$str() {
        return argGroup;
    }
    @Override
    public final String argGroup() {
        return String.format(argGroup$str());
    }
    private static final String argEnable = "Enable the user";
    protected String argEnable$str() {
        return argEnable;
    }
    @Override
    public final String argEnable() {
        return String.format(argEnable$str());
    }
    private static final String argDisable = "Disable the user";
    protected String argDisable$str() {
        return argDisable;
    }
    @Override
    public final String argDisable() {
        return String.format(argDisable$str());
    }
    private static final String argConfirmWarning = "Automatically confirm warning in interactive mode";
    protected String argConfirmWarning$str() {
        return argConfirmWarning;
    }
    @Override
    public final String argConfirmWarning() {
        return String.format(argConfirmWarning$str());
    }
    private static final String argHelp = "Display this message and exit";
    protected String argHelp$str() {
        return argHelp;
    }
    @Override
    public final String argHelp() {
        return String.format(argHelp$str());
    }
    private static final String yes = "yes";
    protected String yes$str() {
        return yes;
    }
    @Override
    public final String yes() {
        return String.format(yes$str());
    }
    private static final String shortYes = "y";
    protected String shortYes$str() {
        return shortYes;
    }
    @Override
    public final String shortYes() {
        return String.format(shortYes$str());
    }
    private static final String no = "no";
    protected String no$str() {
        return no;
    }
    @Override
    public final String no() {
        return String.format(no$str());
    }
    private static final String shortNo = "n";
    protected String shortNo$str() {
        return shortNo;
    }
    @Override
    public final String shortNo() {
        return String.format(shortNo$str());
    }
    private static final String alternativeRealm = "The realm name supplied must match the name used by the server configuration which by default would be '%s'";
    protected String alternativeRealm$str() {
        return alternativeRealm;
    }
    @Override
    public final String alternativeRealm(final String defaultRealm) {
        return String.format(alternativeRealm$str(), defaultRealm);
    }
    private static final String realmConfirmation = "Are you sure you want to set the realm to '%s'";
    protected String realmConfirmation$str() {
        return realmConfirmation;
    }
    @Override
    public final String realmConfirmation(final String chosenRealm) {
        return String.format(realmConfirmation$str(), chosenRealm);
    }
    private static final String passwordRequirements = "Password requirements are listed below. To modify these restrictions edit the add-user.properties configuration file.";
    protected String passwordRequirements$str() {
        return passwordRequirements;
    }
    @Override
    public final String passwordRequirements() {
        return String.format(passwordRequirements$str());
    }
    private static final String passwordRecommendations = "Password recommendations are listed below. To modify these restrictions edit the add-user.properties configuration file.";
    protected String passwordRecommendations$str() {
        return passwordRecommendations;
    }
    @Override
    public final String passwordRecommendations() {
        return String.format(passwordRecommendations$str());
    }
    private static final String userSuppliedRealm = "Using realm '%s' as specified on the command line.";
    protected String userSuppliedRealm$str() {
        return userSuppliedRealm;
    }
    @Override
    public final String userSuppliedRealm(final String realmName) {
        return String.format(userSuppliedRealm$str(), realmName);
    }
    private static final String discoveredRealm = "Using realm '%s' as discovered from the existing property files.";
    protected String discoveredRealm$str() {
        return discoveredRealm;
    }
    @Override
    public final String discoveredRealm(final String realmName) {
        return String.format(discoveredRealm$str(), realmName);
    }
}
