package org.jboss.shrinkwrap.descriptor.impl.orm10; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.orm10.UniqueConstraint;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;

/**
 * This class implements the <code> unique-constraint </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 * @author <a href="mailto:ggastald@redhat.com">George Gastaldi</a>
 */
public class UniqueConstraintImpl<T> implements Child<T>, UniqueConstraint<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public UniqueConstraintImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public UniqueConstraintImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: UniqueConstraint ElementName: xsd:string ElementType : column-name
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>column-name</code> elements, 
    * a new <code>column-name</code> element 
    * @param values list of <code>column-name</code> objects 
    * @return the current instance of <code>UniqueConstraint<T></code> 
    */
   public UniqueConstraint<T> columnName(String ... values)
   {
      if (values != null)
      {
         for(String name: values)
         {
            childNode.createChild("column-name").text(name);
         }
      }
      return this;
   }

   /**
    * Returns all <code>column-name</code> elements
    * @return list of <code>column-name</code> 
    */
public List<String> getAllColumnName()
   {
      List<String> result = new ArrayList<String>();
      List<Node> nodes = childNode.get("column-name");
      for (Node node : nodes)
      {
         result.add(node.getText());
      }
      return result;
   }

   /**
    * Removes the <code>column-name</code> element 
    * @return the current instance of <code>UniqueConstraint<T></code> 
    */
   public UniqueConstraint<T> removeAllColumnName()
   {
      childNode.removeChildren("column-name");
      return this;
   }
}
