package org.wildfly.swarm.config.keycloak;

import org.wildfly.swarm.config.keycloak.SecureDeployment;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SecureDeploymentConsumer<T extends SecureDeployment<T>> {

	/**
	 * Configure a pre-constructed instance of SecureDeployment resource
	 * 
	 * @parameter Instance of SecureDeployment to configure
	 * @return nothing
	 */
	void accept(T value);

	default SecureDeploymentConsumer<T> andThen(
			SecureDeploymentConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}