package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> port-componentType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface PortComponentType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentType ElementName: xsd:string ElementType : port-component-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>port-component-name</code> element
    * @param portComponentName the value for the element <code>port-component-name</code> 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> portComponentName(String portComponentName);

   /**
    * Returns the <code>port-component-name</code> element
    * @return the node defined for the element <code>port-component-name</code> 
    */
   public String getPortComponentName();

   /**
    * Removes the <code>port-component-name</code> element 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> removePortComponentName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentType ElementName: xsd:string ElementType : port-component-uri
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>port-component-uri</code> element
    * @param portComponentUri the value for the element <code>port-component-uri</code> 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> portComponentUri(String portComponentUri);

   /**
    * Returns the <code>port-component-uri</code> element
    * @return the node defined for the element <code>port-component-uri</code> 
    */
   public String getPortComponentUri();

   /**
    * Removes the <code>port-component-uri</code> element 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> removePortComponentUri();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentType ElementName: xsd:string ElementType : auth-method
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>auth-method</code> element
    * @param authMethod the value for the element <code>auth-method</code> 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> authMethod(String authMethod);

   /**
    * Returns the <code>auth-method</code> element
    * @return the node defined for the element <code>auth-method</code> 
    */
   public String getAuthMethod();

   /**
    * Removes the <code>auth-method</code> element 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> removeAuthMethod();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentType ElementName: xsd:string ElementType : transport-guarantee
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>transport-guarantee</code> element
    * @param transportGuarantee the value for the element <code>transport-guarantee</code> 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> transportGuarantee(String transportGuarantee);

   /**
    * Returns the <code>transport-guarantee</code> element
    * @return the node defined for the element <code>transport-guarantee</code> 
    */
   public String getTransportGuarantee();

   /**
    * Removes the <code>transport-guarantee</code> element 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> removeTransportGuarantee();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentType ElementName: xsd:boolean ElementType : secure-wsdl-access
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>secure-wsdl-access</code> element
    * @param secureWsdlAccess the value for the element <code>secure-wsdl-access</code> 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> secureWsdlAccess(Boolean secureWsdlAccess);

   /**
    * Returns the <code>secure-wsdl-access</code> element
    * @return the node defined for the element <code>secure-wsdl-access</code> 
    */
   public Boolean isSecureWsdlAccess();

   /**
    * Removes the <code>secure-wsdl-access</code> element 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> removeSecureWsdlAccess();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PortComponentType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>PortComponentType<T></code> 
    */
   public PortComponentType<T> removeId();
}
