package org.jboss.shrinkwrap.descriptor.api.jbosscommon51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> stub-propertyType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface StubPropertyType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: StubPropertyType ElementName: xsd:string ElementType : prop-name
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>prop-name</code> element
    * @param propName the value for the element <code>prop-name</code> 
    * @return the current instance of <code>StubPropertyType<T></code> 
    */
   public StubPropertyType<T> propName(String propName);

   /**
    * Returns the <code>prop-name</code> element
    * @return the node defined for the element <code>prop-name</code> 
    */
   public String getPropName();

   /**
    * Removes the <code>prop-name</code> element 
    * @return the current instance of <code>StubPropertyType<T></code> 
    */
   public StubPropertyType<T> removePropName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: StubPropertyType ElementName: xsd:string ElementType : prop-value
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>prop-value</code> element
    * @param propValue the value for the element <code>prop-value</code> 
    * @return the current instance of <code>StubPropertyType<T></code> 
    */
   public StubPropertyType<T> propValue(String propValue);

   /**
    * Returns the <code>prop-value</code> element
    * @return the node defined for the element <code>prop-value</code> 
    */
   public String getPropValue();

   /**
    * Removes the <code>prop-value</code> element 
    * @return the current instance of <code>StubPropertyType<T></code> 
    */
   public StubPropertyType<T> removePropValue();
}
