package org.jboss.shrinkwrap.descriptor.api.jbossmodule13; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ResourceType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ArtifactType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ArtifactType;
/**
 * This interface defines the contract for the <code> resourcesType </code> xsd type 
 * @author <a href="mailto:tcrawley@redhat.com">Toby Crawley</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ResourcesType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourcesType ElementName: jboss:resourceType ElementType : resource-root
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-root</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-root</code> element will be returned.
    * @return the instance defined for the element <code>resource-root</code> 
    */
   public ResourceType<ResourcesType<T>> getOrCreateResourceRoot();

   /**
    * Creates a new <code>resource-root</code> element 
    * @return the new created instance of <code>ResourceType<ResourcesType<T>></code> 
    */
   public ResourceType<ResourcesType<T>> createResourceRoot();

   /**
    * Returns all <code>resource-root</code> elements
    * @return list of <code>resource-root</code> 
    */
   public List<ResourceType<ResourcesType<T>>> getAllResourceRoot();

   /**
    * Removes all <code>resource-root</code> elements 
    * @return the current instance of <code>ResourceType<ResourcesType<T>></code> 
    */
   public ResourcesType<T> removeAllResourceRoot();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourcesType ElementName: jboss:artifactType ElementType : artifact
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>artifact</code> element will be created and returned.
    * Otherwise, the first existing <code>artifact</code> element will be returned.
    * @return the instance defined for the element <code>artifact</code> 
    */
   public ArtifactType<ResourcesType<T>> getOrCreateArtifact();

   /**
    * Creates a new <code>artifact</code> element 
    * @return the new created instance of <code>ArtifactType<ResourcesType<T>></code> 
    */
   public ArtifactType<ResourcesType<T>> createArtifact();

   /**
    * Returns all <code>artifact</code> elements
    * @return list of <code>artifact</code> 
    */
   public List<ArtifactType<ResourcesType<T>>> getAllArtifact();

   /**
    * Removes all <code>artifact</code> elements 
    * @return the current instance of <code>ArtifactType<ResourcesType<T>></code> 
    */
   public ResourcesType<T> removeAllArtifact();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ResourcesType ElementName: jboss:artifactType ElementType : native-artifact
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>native-artifact</code> element will be created and returned.
    * Otherwise, the first existing <code>native-artifact</code> element will be returned.
    * @return the instance defined for the element <code>native-artifact</code> 
    */
   public ArtifactType<ResourcesType<T>> getOrCreateNativeArtifact();

   /**
    * Creates a new <code>native-artifact</code> element 
    * @return the new created instance of <code>ArtifactType<ResourcesType<T>></code> 
    */
   public ArtifactType<ResourcesType<T>> createNativeArtifact();

   /**
    * Returns all <code>native-artifact</code> elements
    * @return list of <code>native-artifact</code> 
    */
   public List<ArtifactType<ResourcesType<T>>> getAllNativeArtifact();

   /**
    * Removes all <code>native-artifact</code> elements 
    * @return the current instance of <code>ArtifactType<ResourcesType<T>></code> 
    */
   public ResourcesType<T> removeAllNativeArtifact();
}
