package org.jboss.shrinkwrap.descriptor.api.jbossweb60; 

/**
 * This class implements the <code> replication-triggerType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public enum ReplicationTriggerType
{
   _ACCESS("ACCESS"),
   _SET_AND_GET("SET_AND_GET"),
   _SET_AND_NON_PRIMITIVE_GET("SET_AND_NON_PRIMITIVE_GET"),
   _SET("SET");

   private String value;

   ReplicationTriggerType (String value) { this.value = value; }

   public String toString() {return value;}

   public static ReplicationTriggerType getFromStringValue(String value)
   {
      for(ReplicationTriggerType type: ReplicationTriggerType.values())
      {
         if(value != null && type.toString().equals(value))
        { return type;}
      }
      return null;
   }

}

