package org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.CopyArtifactType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.FilterType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.FilterTypeImpl;

/**
 * This class implements the <code> copy-artifact-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class CopyArtifactTypeImpl<T> implements Child<T>, CopyArtifactType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public CopyArtifactTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public CopyArtifactTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CopyArtifactType ElementName: wildfly:filter-type ElementType : filter
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>filter</code> element will be created and returned.
    * Otherwise, the first existing <code>filter</code> element will be returned.
    * @return the instance defined for the element <code>filter</code> 
    */
   public FilterType<CopyArtifactType<T>> getOrCreateFilter()
   {
      List<Node> nodeList = childNode.get("filter");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new FilterTypeImpl<CopyArtifactType<T>>(this, "filter", childNode, nodeList.get(0));
      }
      return createFilter();
   }

   /**
    * Creates a new <code>filter</code> element 
    * @return the new created instance of <code>FilterType<CopyArtifactType<T>></code> 
    */
   public FilterType<CopyArtifactType<T>> createFilter()
   {
      return new FilterTypeImpl<CopyArtifactType<T>>(this, "filter", childNode);
   }

   /**
    * Returns all <code>filter</code> elements
    * @return list of <code>filter</code> 
    */
   public List<FilterType<CopyArtifactType<T>>> getAllFilter()
   {
      List<FilterType<CopyArtifactType<T>>> list = new ArrayList<FilterType<CopyArtifactType<T>>>();
      List<Node> nodeList = childNode.get("filter");
      for(Node node: nodeList)
      {
         FilterType<CopyArtifactType<T>>  type = new FilterTypeImpl<CopyArtifactType<T>>(this, "filter", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>filter</code> elements 
    * @return the current instance of <code>FilterType<CopyArtifactType<T>></code> 
    */
   public CopyArtifactType<T> removeAllFilter()
   {
      childNode.removeChildren("filter");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CopyArtifactType ElementName: xsd:string ElementType : artifact
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>artifact</code> attribute
    * @param artifact the value for the attribute <code>artifact</code> 
    * @return the current instance of <code>CopyArtifactType<T></code> 
    */
   public CopyArtifactType<T> artifact(String artifact)
   {
      childNode.attribute("artifact", artifact);
      return this;
   }

   /**
    * Returns the <code>artifact</code> attribute
    * @return the value defined for the attribute <code>artifact</code> 
    */
      public String getArtifact()
   {
      return childNode.getAttribute("artifact");
   }

   /**
    * Removes the <code>artifact</code> attribute 
    * @return the current instance of <code>CopyArtifactType<T></code> 
    */
   public CopyArtifactType<T> removeArtifact()
   {
      childNode.removeAttribute("artifact");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CopyArtifactType ElementName: xsd:string ElementType : to-location
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>to-location</code> attribute
    * @param toLocation the value for the attribute <code>to-location</code> 
    * @return the current instance of <code>CopyArtifactType<T></code> 
    */
   public CopyArtifactType<T> toLocation(String toLocation)
   {
      childNode.attribute("to-location", toLocation);
      return this;
   }

   /**
    * Returns the <code>to-location</code> attribute
    * @return the value defined for the attribute <code>to-location</code> 
    */
      public String getToLocation()
   {
      return childNode.getAttribute("to-location");
   }

   /**
    * Removes the <code>to-location</code> attribute 
    * @return the current instance of <code>CopyArtifactType<T></code> 
    */
   public CopyArtifactType<T> removeToLocation()
   {
      childNode.removeAttribute("to-location");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: CopyArtifactType ElementName: xsd:boolean ElementType : extract
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>extract</code> attribute
    * @param extract the value for the attribute <code>extract</code> 
    * @return the current instance of <code>CopyArtifactType<T></code> 
    */
   public CopyArtifactType<T> extract(Boolean extract)
   {
      childNode.attribute("extract", extract);
      return this;
   }

   /**
    * Returns the <code>extract</code> attribute
    * @return the value defined for the attribute <code>extract</code> 
    */
   public Boolean isExtract()
   {
      return Strings.isTrue(childNode.getAttribute("extract"));
   }

   /**
    * Removes the <code>extract</code> attribute 
    * @return the current instance of <code>CopyArtifactType<T></code> 
    */
   public CopyArtifactType<T> removeExtract()
   {
      childNode.removeAttribute("extract");
      return this;
   }
}
