/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.persistence.EntityManager;
import javax.persistence.SynchronizationType;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.container.ExtendedEntityManagerKey;
import org.jboss.as.jpa.container.SynchronizationTypeAccess;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.transaction.TransactionUtil;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.txn.service.TransactionManagerService;
import org.jboss.as.txn.service.TransactionSynchronizationRegistryService;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ExtendedEntityManager
extends AbstractEntityManager
implements Serializable,
SynchronizationTypeAccess {
    private static final long serialVersionUID = 432438L;
    private EntityManager underlyingEntityManager;
    private String puScopedName;
    private transient boolean isInTx;
    private int referenceCount = 1;
    private final ExtendedEntityManagerKey ID = ExtendedEntityManagerKey.extendedEntityManagerID();
    private final transient boolean isTraceEnabled = JpaLogger.ROOT_LOGGER.isTraceEnabled();
    private final SynchronizationType synchronizationType;
    private transient TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private transient TransactionManager transactionManager;

    public ExtendedEntityManager(String puScopedName, EntityManager underlyingEntityManager, SynchronizationType synchronizationType, TransactionSynchronizationRegistry transactionSynchronizationRegistry, TransactionManager transactionManager) {
        this.underlyingEntityManager = underlyingEntityManager;
        this.puScopedName = puScopedName;
        this.synchronizationType = synchronizationType;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.transactionManager = transactionManager;
    }

    @Override
    protected EntityManager getEntityManager() {
        this.internalAssociateWithJtaTx();
        return this.underlyingEntityManager;
    }

    public void internalAssociateWithJtaTx() {
        this.isInTx = TransactionUtil.isInTx(this.transactionManager);
        if (this.isInTx) {
            EntityManager existing = TransactionUtil.getTransactionScopedEntityManager(this.puScopedName, this.transactionSynchronizationRegistry);
            if (existing != null && existing != this) {
                throw JpaLogger.ROOT_LOGGER.cannotUseExtendedPersistenceTransaction(this.puScopedName, existing, this);
            }
            if (existing == null) {
                if (SynchronizationType.SYNCHRONIZED.equals((Object)this.synchronizationType)) {
                    this.underlyingEntityManager.joinTransaction();
                }
                TransactionUtil.putEntityManagerInTransactionRegistry(this.puScopedName, this, this.transactionSynchronizationRegistry);
            }
        }
    }

    @Override
    protected boolean isExtendedPersistenceContext() {
        return true;
    }

    @Override
    protected boolean isInTx() {
        return this.isInTx;
    }

    @Override
    public void close() {
        throw JpaLogger.ROOT_LOGGER.cannotCloseContainerManagedEntityManager();
    }

    public synchronized void increaseReferenceCount() {
        ++this.referenceCount;
    }

    public synchronized int getReferenceCount() {
        return this.referenceCount;
    }

    public synchronized void refCountedClose() {
        --this.referenceCount;
        if (this.referenceCount == 0) {
            if (this.underlyingEntityManager.isOpen()) {
                this.underlyingEntityManager.close();
                if (this.isTraceEnabled) {
                    JpaLogger.ROOT_LOGGER.tracef("closed extended persistence context (%s)", this.puScopedName);
                }
            }
        } else if (this.isTraceEnabled) {
            JpaLogger.ROOT_LOGGER.tracef("decremented extended persistence context (%s) owner count to %d", this.puScopedName, this.referenceCount);
        }
        if (this.referenceCount < 0) {
            throw JpaLogger.ROOT_LOGGER.referenceCountedEntityManagerNegativeCount(this.referenceCount, this.getScopedPuName());
        }
    }

    public String toString() {
        return "ExtendedEntityManager [" + this.puScopedName + "]";
    }

    public String getScopedPuName() {
        return this.puScopedName;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null || this.getClass() != otherObject.getClass()) {
            return false;
        }
        ExtendedEntityManager that = (ExtendedEntityManager)otherObject;
        return this.ID.equals(that.ID);
    }

    public int hashCode() {
        return this.ID != null ? this.ID.hashCode() : 0;
    }

    @Override
    public SynchronizationType getSynchronizationType() {
        return SynchronizationType.SYNCHRONIZED;
    }

    @Override
    protected boolean deferEntityDetachUntilClose() {
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (WildFlySecurityManager.isChecking()) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ExtendedEntityManager.this.transactionManager = (TransactionManager)CurrentServiceContainer.getServiceContainer().getService(TransactionManagerService.SERVICE_NAME).getValue();
                    ExtendedEntityManager.this.transactionSynchronizationRegistry = (TransactionSynchronizationRegistry)CurrentServiceContainer.getServiceContainer().getService(TransactionSynchronizationRegistryService.SERVICE_NAME).getValue();
                    return null;
                }
            });
        } else {
            this.transactionManager = (TransactionManager)CurrentServiceContainer.getServiceContainer().getService(TransactionManagerService.SERVICE_NAME).getValue();
            this.transactionSynchronizationRegistry = (TransactionSynchronizationRegistry)CurrentServiceContainer.getServiceContainer().getService(TransactionSynchronizationRegistryService.SERVICE_NAME).getValue();
        }
    }
}

