/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.camel.CamelContext;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelLogger;

public class CamelContextActivationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        for (CamelContext camelctx : depUnit.getAttachmentList(CamelConstants.CAMEL_CONTEXT_KEY)) {
            try {
                camelctx.start();
            }
            catch (Exception ex) {
                CamelLogger.LOGGER.error("Cannot start camel context: " + camelctx.getName(), (Throwable)ex);
            }
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        ArrayList ctxlist = new ArrayList(depUnit.getAttachmentList(CamelConstants.CAMEL_CONTEXT_KEY));
        Collections.reverse(ctxlist);
        for (CamelContext camelctx : ctxlist) {
            try {
                camelctx.stop();
            }
            catch (Exception ex) {
                CamelLogger.LOGGER.warn("Cannot stop camel context: " + camelctx.getName(), (Throwable)ex);
            }
        }
    }
}

