/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import org.apache.camel.CamelContext;
import org.jboss.as.naming.ImmediateManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.camel.CamelLogger;

public final class CamelContextBindingService
extends AbstractService<CamelContext> {
    public static ServiceController<?> addService(ServiceTarget serviceTarget, CamelContext camelctx) {
        final ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)("java:jboss/camel/context/" + camelctx.getName()));
        BinderService binderService = new BinderService(bindInfo.getBindName()){

            public synchronized void start(StartContext context) throws StartException {
                super.start(context);
                CamelLogger.LOGGER.info("Bound camel naming object: {}", (Object)bindInfo.getAbsoluteJndiName());
            }

            public synchronized void stop(StopContext context) {
                CamelLogger.LOGGER.info("Unbind camel naming object: {}", (Object)bindInfo.getAbsoluteJndiName());
                super.stop(context);
            }
        };
        binderService.getManagedObjectInjector().inject((Object)new ImmediateManagedReferenceFactory((Object)camelctx));
        ServiceBuilder builder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService);
        builder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector());
        return builder.install();
    }
}

