/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave;

import com.github.kristofa.brave.SpanAndEndpoint;
import com.github.kristofa.brave.internal.Nullable;
import com.github.kristofa.brave.internal.Util;
import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Endpoint;
import com.twitter.zipkin.gen.Span;
import zipkin.reporter.Reporter;

public abstract class AnnotationSubmitter {
    static AnnotationSubmitter create(SpanAndEndpoint spanAndEndpoint) {
        return new AnnotationSubmitterImpl(spanAndEndpoint, DefaultClock.INSTANCE);
    }

    public static AnnotationSubmitter create(SpanAndEndpoint spanAndEndpoint, Clock clock) {
        return new AnnotationSubmitterImpl(spanAndEndpoint, clock);
    }

    abstract SpanAndEndpoint spanAndEndpoint();

    abstract Clock clock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitAnnotation(String value) {
        Span span = this.spanAndEndpoint().span();
        if (span != null) {
            Long startTick;
            Long startTimestamp;
            Span span2 = span;
            synchronized (span2) {
                startTimestamp = span.getTimestamp();
                startTick = span.startTick;
            }
            Annotation annotation = Annotation.create(this.currentTimeMicroseconds(startTimestamp, startTick), value, this.spanAndEndpoint().endpoint());
            this.addAnnotation(span, annotation);
        }
    }

    public void submitAnnotation(String value, long timestamp) {
        Span span = this.spanAndEndpoint().span();
        if (span != null) {
            Annotation annotation = Annotation.create(timestamp, value, this.spanAndEndpoint().endpoint());
            this.addAnnotation(span, annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submitStartAnnotation(String annotationName) {
        Span span = this.spanAndEndpoint().span();
        if (span != null) {
            Annotation annotation = Annotation.create(this.clock().currentTimeMicroseconds(), annotationName, this.spanAndEndpoint().endpoint());
            Span span2 = span;
            synchronized (span2) {
                span.setTimestamp(annotation.timestamp);
                span.addToAnnotations(annotation);
                span.startTick = System.nanoTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean submitEndAnnotation(String annotationName, Reporter<zipkin.Span> reporter) {
        Long startTick;
        Long startTimestamp;
        Span span = this.spanAndEndpoint().span();
        if (span == null) {
            return false;
        }
        Span span2 = span;
        synchronized (span2) {
            startTimestamp = span.getTimestamp();
            startTick = span.startTick;
        }
        long endTimestamp = this.currentTimeMicroseconds(startTimestamp, startTick);
        Annotation annotation = Annotation.create(endTimestamp, annotationName, this.spanAndEndpoint().endpoint());
        Span span3 = span;
        synchronized (span3) {
            span.addToAnnotations(annotation);
            if (startTimestamp != null) {
                span.setDuration(Math.max(1L, endTimestamp - startTimestamp));
            }
        }
        reporter.report((Object)span.toZipkin());
        return true;
    }

    void submitAddress(String key, Endpoint endpoint) {
        Span span = this.spanAndEndpoint().span();
        if (span != null) {
            if (endpoint.service_name == null) {
                endpoint = endpoint.toBuilder().serviceName("unknown").build();
            }
            BinaryAnnotation ba = BinaryAnnotation.address(key, endpoint);
            this.addBinaryAnnotation(span, ba);
        }
    }

    public void submitBinaryAnnotation(String key, String value) {
        Span span = this.spanAndEndpoint().span();
        if (span != null) {
            BinaryAnnotation ba = BinaryAnnotation.create(key, value, this.spanAndEndpoint().endpoint());
            this.addBinaryAnnotation(span, ba);
        }
    }

    public void submitBinaryAnnotation(String key, int value) {
        this.submitBinaryAnnotation(key, String.valueOf(value));
    }

    long currentTimeMicroseconds(@Nullable Long startTimestamp, @Nullable Long startTick) {
        return startTimestamp != null && startTick != null ? startTimestamp + (System.nanoTime() - startTick) / 1000L : this.clock().currentTimeMicroseconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAnnotation(Span span, Annotation annotation) {
        Span span2 = span;
        synchronized (span2) {
            span.addToAnnotations(annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBinaryAnnotation(Span span, BinaryAnnotation ba) {
        Span span2 = span;
        synchronized (span2) {
            span.addToBinary_annotations(ba);
        }
    }

    AnnotationSubmitter() {
    }

    static final class DefaultClock
    implements Clock {
        static final Clock INSTANCE = new DefaultClock();

        private DefaultClock() {
        }

        @Override
        public long currentTimeMicroseconds() {
            return System.currentTimeMillis() * 1000L;
        }
    }

    private static final class AnnotationSubmitterImpl
    extends AnnotationSubmitter {
        private final SpanAndEndpoint spanAndEndpoint;
        private final Clock clock;

        private AnnotationSubmitterImpl(SpanAndEndpoint spanAndEndpoint, Clock clock) {
            this.spanAndEndpoint = Util.checkNotNull(spanAndEndpoint, "Null spanAndEndpoint", new Object[0]);
            this.clock = clock;
        }

        @Override
        SpanAndEndpoint spanAndEndpoint() {
            return this.spanAndEndpoint;
        }

        @Override
        protected Clock clock() {
            return this.clock;
        }
    }

    public static interface Clock {
        public long currentTimeMicroseconds();
    }
}

