/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.samplers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.uber.jaeger.exceptions.SamplingStrategyErrorException;
import com.uber.jaeger.samplers.SamplingManager;
import com.uber.jaeger.samplers.http.SamplingStrategyResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;

public class HttpSamplingManager
implements SamplingManager {
    private static final String defaultSamplingServerHostPort = "localhost:5778";
    private String hostPort = "localhost:5778";
    private Gson gson = new Gson();

    public HttpSamplingManager(String hostPort) {
        if (hostPort != null) {
            this.hostPort = hostPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String makeGetRequest(String urlToRead) throws IOException {
        URL url = new URL(urlToRead);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        StringBuilder result = new StringBuilder();
        try {
            conn.setRequestMethod("GET");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("UTF-8")));
            try {
                String line;
                while ((line = rd.readLine()) != null) {
                    result.append(line);
                }
            }
            finally {
                rd.close();
            }
        }
        finally {
            conn.disconnect();
        }
        return result.toString();
    }

    SamplingStrategyResponse parseJson(String json) {
        try {
            return (SamplingStrategyResponse)this.gson.fromJson(json, SamplingStrategyResponse.class);
        }
        catch (JsonSyntaxException e) {
            throw new SamplingStrategyErrorException("Cannot deserialize json", e);
        }
    }

    @Override
    public SamplingStrategyResponse getSamplingStrategy(String serviceName) throws SamplingStrategyErrorException {
        String jsonString;
        try {
            jsonString = this.makeGetRequest("http://" + this.hostPort + "/?service=" + URLEncoder.encode(serviceName, "UTF-8"));
        }
        catch (IOException e) {
            throw new SamplingStrategyErrorException("http call to get sampling strategy from local agent failed.", e);
        }
        return this.parseJson(jsonString);
    }

    public String toString() {
        return "HttpSamplingManager(hostPort=" + this.hostPort + ", gson=" + this.gson + ")";
    }
}

