/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger.senders;

import com.uber.jaeger.senders.ThriftSender;
import com.uber.jaeger.thriftjava.Batch;
import com.uber.jaeger.thriftjava.Process;
import com.uber.jaeger.thriftjava.Span;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class HttpSender
extends ThriftSender {
    private static final String HTTP_COLLECTOR_JAEGER_THRIFT_FORMAT_PARAM = "format=jaeger.thrift";
    private static final TProtocolFactory PROTOCOL_FACTORY = new TBinaryProtocol.Factory();
    private static final TSerializer SERIALIZER = new TSerializer(PROTOCOL_FACTORY);
    private final HttpClient httpClient = new DefaultHttpClient();
    private final URI collectorUri;

    public HttpSender(String endpoint, int maxPacketSize) {
        super(PROTOCOL_FACTORY, maxPacketSize);
        this.collectorUri = this.constructCollectorUri(endpoint);
    }

    @Override
    public void send(Process process, List<Span> spans) throws TException {
        Batch batch = new Batch(process, spans);
        byte[] bytes = SERIALIZER.serialize((TBase)batch);
        try {
            HttpPost httpPost = new HttpPost(this.collectorUri);
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(bytes));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new TException("Could not send " + spans.size() + " spans, response " + response.getStatusLine().getStatusCode());
            }
        }
        catch (IOException e) {
            throw new TException("Could not send " + spans.size() + ", spans", (Throwable)e);
        }
    }

    private URI constructCollectorUri(String endpoint) {
        try {
            return new URI(String.format("%s?%s", endpoint, HTTP_COLLECTOR_JAEGER_THRIFT_FORMAT_PARAM));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Wrong collector host", e);
        }
    }
}

