/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.drools;

import java.util.Arrays;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.drools.RulesExecutionService;
import org.kie.server.services.impl.KieContainerCommandServiceImpl;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsKieContainerCommandServiceImpl
extends KieContainerCommandServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(DroolsKieContainerCommandServiceImpl.class);
    private RulesExecutionService rulesExecutionService;

    public DroolsKieContainerCommandServiceImpl(KieServerImpl kieServer, KieServerRegistry context, RulesExecutionService rulesExecutionService) {
        super(kieServer, context);
        this.rulesExecutionService = rulesExecutionService;
    }

    public ServiceResponse<ExecutionResults> callContainer(String containerId, String payload, MarshallingFormat marshallingFormat, String classType) {
        if (payload == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error calling container " + containerId + ". Empty payload. ");
        }
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(containerId);
            if (kci != null && kci.getKieContainer() != null) {
                Command cmd;
                Class type = BatchExecutionCommandImpl.class;
                if (classType != null && !classType.isEmpty()) {
                    type = Class.forName(classType, true, kci.getKieContainer().getClassLoader());
                }
                if (!((cmd = (Command)kci.getMarshaller(marshallingFormat).unmarshall(payload, type)) instanceof BatchExecutionCommandImpl)) {
                    cmd = new BatchExecutionCommandImpl(Arrays.asList((GenericCommand)cmd));
                }
                if (cmd == null || ((BatchExecutionCommandImpl)cmd).getCommands() == null || ((BatchExecutionCommandImpl)cmd).getCommands().isEmpty()) {
                    return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Bad request, no commands to be executed - either wrong format or no data");
                }
                ExecutionResults results = this.rulesExecutionService.call((KieContainerInstance)kci, (BatchExecutionCommand)((BatchExecutionCommandImpl)cmd));
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " successfully called.", (Object)results);
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + containerId + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error calling container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error calling container " + containerId + ": " + e.getMessage());
        }
    }
}

