/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.beanio;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.beanio.BeanIOConfiguration;
import org.apache.camel.dataformat.beanio.BeanIOIterator;
import org.beanio.BeanReaderErrorHandlerSupport;
import org.beanio.InvalidRecordException;
import org.beanio.UnexpectedRecordException;
import org.beanio.UnidentifiedRecordException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanIOErrorHandler
extends BeanReaderErrorHandlerSupport {
    static final String LOG_PREFIX = "BeanIO: ";
    static final Logger LOG = LoggerFactory.getLogger(BeanIOErrorHandler.class);
    private BeanIOConfiguration configuration;
    private Exchange exchange;
    private List<Object> results;
    private BeanIOIterator iterator;

    public void init() {
    }

    public BeanIOConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(BeanIOConfiguration configuration) {
        this.configuration = configuration;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    void setResults(List<Object> results) {
        this.results = results;
    }

    void setIterator(BeanIOIterator iterator) {
        this.iterator = iterator;
    }

    public void handleErrorAndAddAsResult(Object result) {
        if (this.results != null) {
            this.results.add(result);
        } else if (this.iterator != null) {
            this.iterator.setNext(result);
        }
    }

    public void invalidRecord(InvalidRecordException ex) throws Exception {
        String msg = "BeanIO: InvalidRecord: " + ex.getMessage() + ": " + ex.getRecordContext().getRecordText();
        if (!this.getConfiguration().isIgnoreInvalidRecords()) {
            LOG.warn(msg);
            throw ex;
        }
        LOG.debug(msg);
    }

    public void unexpectedRecord(UnexpectedRecordException ex) throws Exception {
        String msg = "BeanIO: UnexpectedRecord: " + ex.getMessage() + ": " + ex.getRecordContext().getRecordText();
        if (!this.getConfiguration().isIgnoreUnexpectedRecords()) {
            LOG.warn(msg);
            throw ex;
        }
        LOG.debug(msg);
    }

    public void unidentifiedRecord(UnidentifiedRecordException ex) throws Exception {
        String msg = "BeanIO: UnidentifiedRecord: " + ex.getMessage() + ": " + ex.getRecordContext().getRecordText();
        if (!this.getConfiguration().isIgnoreUnidentifiedRecords()) {
            LOG.warn(msg);
            throw ex;
        }
        LOG.debug(msg);
    }
}

