/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.nats.NatsConfiguration;
import org.apache.camel.component.nats.NatsEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Metadata;

public class NatsComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        NatsConfiguration config = new NatsConfiguration();
        this.setProperties(config, parameters);
        config.setServers(remaining);
        if (config.getSslContextParameters() == null) {
            config.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        NatsEndpoint endpoint = new NatsEndpoint(uri, this, config);
        return endpoint;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

